/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class PluginUtil {
    private final String pluginId;

    public PluginUtil(String pluginId) {
        this.pluginId = pluginId;
    }

    public File getPluginStoreFile(String path) {
        Bundle bundle = Platform.getBundle((String)this.pluginId);
        return bundle.getBundleContext().getDataFile(path);
    }

    public File getPluginFile(String path) throws IOException {
        File result = this.getPluginStoreFile(path);
        result.getParentFile().mkdirs();
        InputStream inStream = this.getInputStream(path);
        Lib.inputStreamToFile((InputStream)inStream, (File)result);
        if (!result.exists()) {
            return null;
        }
        return result;
    }

    public File copyPluginFileToOseeData(String path, String resultPath) throws IOException {
        InputStream inStream = this.getInputStream(path);
        File resultFile = OseeData.getFile((String)resultPath);
        Lib.inputStreamToFile((InputStream)inStream, (File)resultFile);
        return resultFile;
    }

    public InputStream getInputStream(String resource) throws IOException {
        Bundle bundle = Platform.getBundle((String)this.pluginId);
        return bundle.getEntry(resource).openStream();
    }

    public List<URL> getInputStreams(String directory, String pattern, boolean recurse) {
        Bundle bundle = Platform.getBundle((String)this.pluginId);
        Enumeration enumeration = bundle.findEntries(directory, pattern, recurse);
        ArrayList<URL> inputs = new ArrayList<URL>();
        while (enumeration.hasMoreElements()) {
            inputs.add((URL)enumeration.nextElement());
        }
        return inputs;
    }

    public BundleContext getBundleContext() {
        Bundle bundle = Platform.getBundle((String)this.pluginId);
        return bundle.getBundleContext();
    }
}

