/*
 * Decompiled with CFR 0.152.
 */
package jms.activemq.launch;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class RunActiveMq
implements IApplication {
    private static String BROKER_URI;
    private BrokerService broker;
    private final boolean isKillable = true;
    private Session session;
    private MessageConsumer replyToConsumer;
    private Connection connection;

    public Object start(IApplicationContext appContext) throws Exception {
        this.broker = new BrokerService();
        this.broker.setBrokerName("osee");
        this.broker.setUseShutdownHook(true);
        this.broker.setUseJmx(false);
        String[] myArgs = (String[])appContext.getArguments().get("application.args");
        BROKER_URI = "tcp://localhost:" + myArgs[0];
        this.broker.addConnector(BROKER_URI);
        this.broker.start();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(ActiveMQConnection.DEFAULT_USER, ActiveMQConnection.DEFAULT_PASSWORD, BROKER_URI);
        this.connection = factory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 2);
        Topic destination = this.session.createTopic("jms.kill.broker");
        this.replyToConsumer = this.session.createConsumer((Destination)destination);
        this.replyToConsumer.setMessageListener(new MessageListener(){

            public void onMessage(Message arg0) {
                try {
                    System.err.println("got a kill message");
                    RunActiveMq.this.stopBrokerInNewThread();
                    System.err.println("did something with a kill message");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        while (this.broker.isStarted()) {
            Thread.sleep(1000L);
        }
        return null;
    }

    public void stop() {
        try {
            this.broker.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void stopBrokerInNewThread() throws Exception {
        new Thread(new StopIt()).start();
    }

    private class StopIt
    implements Runnable {
        private StopIt() {
        }

        @Override
        public void run() {
            try {
                System.err.println("close the connection");
                RunActiveMq.this.connection.close();
                System.err.println("stop the broker");
                RunActiveMq.this.broker.stop();
                System.err.println("done");
            }
            catch (Throwable th) {
                th.printStackTrace();
            }
        }
    }
}

