/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.osee.ats.ide.PortPairsOperation;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;

public class PortPairsBlam
extends AbstractBlam {
    private static final String PORT_NAME = "Porting ID Pairs";
    private static final String USE_ATSID = "Use Ats IDs instead of RPCRs for Porting Workflows";

    public IOperation createOperation(VariableMap variableMap, OperationLogger logger) throws Exception {
        String pairs = variableMap.getString(PORT_NAME);
        boolean checked = variableMap.getBoolean(USE_ATSID);
        return new PortPairsOperation(logger, pairs, checked);
    }

    public Collection<String> getCategories() {
        return Collections.singletonList("ATS.Admin");
    }

    public String getXWidgetsXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xWidgets>");
        sb.append("<XWidget xwidgetType=\"XText\" fill=\"Vertically\" displayName=\"");
        sb.append(PORT_NAME);
        sb.append("\" />");
        sb.append(String.format("<XWidget xwidgetType=\"XCheckBox\" displayName=\"%s\" horizontalLabel=\"true\"/>", USE_ATSID));
        sb.append("</xWidgets>");
        return sb.toString();
    }

    public String getDescriptionUsage() {
        return "Port a given list of workflows represented by either RPCRs or ATS IDs, formated like: <from>,<to>. Each pair should be separated by a return. The BLAM can be run multiple times, as the conflicts are resolved on the port branch merges.";
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }
}

