/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions.newaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.ide.actions.wizard.IAtsWizardItem;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XActionableItemWidget;
import org.eclipse.osee.ats.ide.workflow.ATSXWidgetOptionResolver;
import org.eclipse.osee.ats.ide.workflow.cr.CreateNewChangeRequestBlam;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.builder.XWidgetBuilder;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.ICheckBoxStateTreeListener;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IDynamicWidgetLayoutListener;
import org.eclipse.osee.framework.ui.skynet.widgets.util.IXWidgetOptionResolver;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetPage;
import org.eclipse.osee.framework.ui.skynet.widgets.util.XWidgetRendererItem;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.framework.Bundle;

public class CreateNewActionBlam
extends AbstractBlam
implements INewActionListener {
    private static final String BLAM_DESCRIPTION = "Select options to create new ATS Action";
    protected static final String TITLE = "Title";
    protected static final String PROGRAM = "Program";
    protected static final String DESCRIPTION = "Description";
    protected static final String CHANGE_TYPE = "Change Type";
    protected static final String PRIORITY = "Priority";
    protected static final String NEED_BY = "Need By";
    protected XText titleWidget;
    protected XText descWidget;
    protected XCombo changeWidget;
    protected XCombo priorityWidget;
    protected XActionableItemWidget aiWidget;
    protected final AtsApi atsApi;
    protected XWidgetBuilder wb;
    private ActionResult actionResult;
    private XWidgetPage page;
    private Composite teamComp;
    private static Set<IAtsWizardItem> wizardExtensionItems = new HashSet<IAtsWizardItem>();
    private final Set<IAtsWizardItem> handledExtensionItems = new HashSet<IAtsWizardItem>();
    private IManagedForm form;
    private Section section;
    private Composite comp;

    public CreateNewActionBlam() {
        super("Create New Action (Beta)", BLAM_DESCRIPTION, null);
        this.atsApi = AtsApiService.get();
    }

    protected boolean isValidEntry() {
        return true;
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        String desc;
        this.variableMap = variableMap;
        boolean valid = true;
        String title = variableMap.getString(TITLE);
        if (Strings.isInValid((String)title)) {
            this.log(new String[]{"Enter Title"});
            valid = false;
        }
        if (Strings.isInValid((String)(desc = variableMap.getString(DESCRIPTION)))) {
            this.log(new String[]{"Enter Description"});
            valid = false;
        }
        String changeType = variableMap.getString(CHANGE_TYPE);
        ChangeType cType = null;
        if (Strings.isInValid((String)changeType) || "--select--".equals(changeType)) {
            this.log(new String[]{"Select Change type"});
            valid = false;
        } else {
            try {
                cType = ChangeType.valueOf((String)changeType);
            }
            catch (Exception exception) {
                valid = false;
                this.log(new String[]{"Invalid Change Type"});
            }
        }
        String priority = variableMap.getString(PRIORITY);
        if (Strings.isInValid((String)priority) || "--select--".equals(priority)) {
            this.log(new String[]{"Select Priority"});
            valid = false;
        }
        Date needBy = (Date)variableMap.getValue(NEED_BY);
        Set<IAtsActionableItem> actionableItems = this.aiWidget.getSelectedIAtsActionableItems();
        if (actionableItems.isEmpty()) {
            valid = false;
            this.log(new String[]{"Must select Actionable Item(s)"});
        }
        if (!this.isValidEntry() || !valid) {
            return;
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet(this.getName());
        this.actionResult = this.atsApi.getActionService().createAction(this.atsApi.getUserService().getCurrentUser(), title, desc, cType, priority, false, needBy, actionableItems, new Date(), this.atsApi.getUserService().getCurrentUser(), Collections.singleton(this), changes);
        for (IAtsWizardItem wizardItem : this.handledExtensionItems) {
            wizardItem.wizardCompleted(this.actionResult, changes);
        }
        changes.execute();
        if (this.actionResult.getResults().isErrors()) {
            this.log(new String[]{this.actionResult.getResults().toString()});
            return;
        }
        IAtsTeamWorkflow teamWf = this.actionResult.getFirstTeam();
        WorkflowEditor.edit((IAtsWorkItem)teamWf);
    }

    public List<XWidgetRendererItem> getXWidgetItems() {
        this.wb = new XWidgetBuilder();
        this.wb.andXText(TITLE).andRequired().endWidget();
        this.wb.andXActionableItem().endWidget();
        this.wb.andXText((AttributeTypeToken)AtsAttributeTypes.Description).andHeight(80).andRequired().endWidget();
        this.wb.andXCombo((AttributeTypeToken)AtsAttributeTypes.ChangeType).andComposite(this.getChangeTypeRowColumns()).andRequired().endWidget();
        this.wb.andXCombo(this.getPriorityAttr()).andRequired().endWidget();
        this.addWidgetAfterPriority();
        this.wb.andXDate((AttributeTypeToken)AtsAttributeTypes.NeedBy).endComposite().endWidget();
        return this.wb.getItems();
    }

    public void createWidgets(Composite comp, IManagedForm form, Section section) {
        this.comp = comp;
        this.form = form;
        this.section = section;
        this.teamComp = new Composite(comp, 0);
        this.teamComp.setLayout((Layout)new GridLayout(1, false));
        this.teamComp.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void updateTeamComposites() {
        try {
            boolean hasWizardXWidgetExtensions;
            this.teamComp.dispose();
            this.createWidgets(this.comp, this.form, this.section);
            this.handledExtensionItems.clear();
            this.getWizardXWidgetExtensions();
            ArrayList allWidgets = new ArrayList();
            StringBuffer stringBuffer = new StringBuffer(500);
            stringBuffer.append("<WorkPage>");
            IDynamicWidgetLayoutListener dynamicWidgetLayoutListener = null;
            for (IAtsWizardItem item : wizardExtensionItems) {
                hasWizardXWidgetExtensions = item.hasWizardXWidgetExtensions(this.aiWidget.getSelectedIAtsActionableItems());
                if (!hasWizardXWidgetExtensions) continue;
                stringBuffer.append("<XWidget displayName=\"--- Extra fields for " + item.getName() + " ---\" xwidgetType=\"XLabel\" horizontalLabel=\"true\" toolTip=\"These fields are available for only the team workflow specified here.\"/>");
                try {
                    if (item instanceof IDynamicWidgetLayoutListener) {
                        dynamicWidgetLayoutListener = (IDynamicWidgetLayoutListener)item;
                    }
                    item.getWizardXWidgetExtensions(this.aiWidget.getSelectedIAtsActionableItems(), stringBuffer);
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
            stringBuffer.append("</WorkPage>");
            this.page = new XWidgetPage(stringBuffer.toString(), (IXWidgetOptionResolver)ATSXWidgetOptionResolver.getInstance(), dynamicWidgetLayoutListener);
            this.page.createBody(null, this.teamComp, null, null, true);
            allWidgets.addAll(this.page.getDynamicXWidgetLayout().getXWidgets());
            for (IAtsWizardItem item : wizardExtensionItems) {
                if (this.handledExtensionItems.contains(item) || !(hasWizardXWidgetExtensions = item.hasWizardXWidgetExtensions(this.aiWidget.getSelectedIAtsActionableItems()))) continue;
                item.getWizardXWidgetExtensions(this.aiWidget.getSelectedIAtsActionableItems(), this.teamComp);
                this.handledExtensionItems.add(item);
            }
            this.teamComp.getParent().layout(true, true);
            this.teamComp.getParent().getParent().layout(true, true);
            this.form.reflow(true);
            this.section.layout(true, true);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public void widgetCreated(XWidget xWidget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener xModListener, boolean isEditable) {
        super.widgetCreated(xWidget, toolkit, art, dynamicXWidgetLayout, xModListener, isEditable);
        if (xWidget.getLabel().equals(TITLE)) {
            this.titleWidget = (XText)xWidget;
            this.titleWidget.getLabelWidget().addListener(4, new Listener(){

                public void handleEvent(Event event) {
                    if (event.button == 3) {
                        CreateNewActionBlam.this.handlePopulateWithDebugInfo();
                    }
                }
            });
        } else if (xWidget.getLabel().equals(DESCRIPTION)) {
            this.descWidget = (XText)xWidget;
        } else if (xWidget.getLabel().equals(CHANGE_TYPE)) {
            this.changeWidget = (XCombo)xWidget;
            CreateNewChangeRequestBlam.setChangeTypeWidget(this.changeWidget);
        } else if (xWidget.getLabel().equals(PRIORITY)) {
            this.priorityWidget = (XCombo)xWidget;
        } else if (xWidget instanceof XActionableItemWidget) {
            this.aiWidget = (XActionableItemWidget)xWidget;
            this.aiWidget.getTreeViewer().addCheckListener(new ICheckBoxStateTreeListener(){

                public void checkStateChanged(Object obj) {
                    CreateNewActionBlam.this.updateTeamComposites();
                }
            });
        }
    }

    public void handlePopulateWithDebugInfo() {
        String title = "New Action " + this.atsApi.getRandomNum();
        this.handlePopulateWithDebugInfo(title);
    }

    public void handlePopulateWithDebugInfo(String title) {
        try {
            this.titleWidget.set(title);
            this.descWidget.set("Description...");
            this.changeWidget.getComboBox().select(1);
            this.priorityWidget.getComboBox().select(1);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private Set<IAtsWizardItem> getWizardXWidgetExtensions() {
        IExtension[] extensions;
        if (!wizardExtensionItems.isEmpty()) {
            return wizardExtensionItems;
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.osee.ats.ide.AtsWizardItem");
        if (point == null) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't access AtsWizardItem extension point");
            return wizardExtensionItems;
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String classname = null;
            String bundleName = null;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (el.getName().equals("AtsWizardItem")) {
                    classname = el.getAttribute("classname");
                    bundleName = el.getContributor().getName();
                    if (classname != null && bundleName != null) {
                        Bundle bundle = Platform.getBundle((String)bundleName);
                        try {
                            Class taskClass = bundle.loadClass(classname);
                            Object obj = taskClass.newInstance();
                            wizardExtensionItems.add((IAtsWizardItem)obj);
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error loading AtsWizardItem extension", (Throwable)ex);
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return wizardExtensionItems;
    }

    public String getRunText() {
        return "Create New Action";
    }

    public String getOutputMessage() {
        return "Not yet run.";
    }

    public String getTabTitle() {
        return "New Action";
    }

    public String getTitle() {
        return this.getName();
    }

    public boolean showInBlamSection() {
        return false;
    }

    public Collection<String> getCategories() {
        return Collections.singleton("ATS");
    }

    public Image getImage() {
        return ImageManager.getImage((OseeImage)AtsImage.CHANGE_REQUEST);
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.CHANGE_REQUEST);
    }

    public ActionResult getActionResult() {
        return this.actionResult;
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.emptyList();
    }

    protected void addWidgetAfterPriority() {
    }

    protected int getChangeTypeRowColumns() {
        return 6;
    }

    protected AttributeTypeToken getPriorityAttr() {
        return AtsAttributeTypes.Priority;
    }
}

