/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.agile;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.window.Window;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.agile.SprintFilteredListDialog;
import org.eclipse.osee.ats.ide.agile.SprintItems;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class SprintColumn
extends XViewerAtsColumn
implements IXViewerValueColumn,
IAltLeftClickProvider,
IMultiColumnEditProvider {
    public static SprintColumn instance = new SprintColumn();

    public static SprintColumn getInstance() {
        return instance;
    }

    private SprintColumn() {
        super("ats.column.sprint", "Sprint", 100, XViewerAlign.Left, false, SortDataType.String, true, "Sprint");
    }

    public SprintColumn copy() {
        SprintColumn newXCol = new SprintColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        block5: {
            Artifact useArt;
            block6: {
                if (!(treeItem.getData() instanceof Artifact)) break block5;
                useArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                if (useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) break block6;
                return false;
            }
            try {
                boolean modified = SprintColumn.promptChangeSprint(useArt, this.isPersistViewer());
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                if (modified && this.isPersistViewer(xViewer)) {
                    useArt.persist("persist sprints via alt-left-click");
                }
                if (modified) {
                    xViewer.update((Object)useArt, null);
                    return true;
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return false;
    }

    public static boolean promptChangeSprint(Artifact awa, boolean persist) {
        return SprintColumn.promptChangeSprint(Arrays.asList(awa), persist);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean promptChangeSprint(Collection<? extends Artifact> awas, boolean persist) {
        SprintItems items = new SprintItems(awas);
        if (items.isNoBacklogDetected()) {
            AWorkbench.popup((String)"Workflow(s) must belong to a Backlog to set their Sprint.");
            return false;
        }
        if (items.isMultipleBacklogsDetected()) {
            AWorkbench.popup((String)"All workflows must belong to same Backlog.");
            return false;
        }
        Artifact backlogArt = AtsApiService.get().getQueryServiceIde().getArtifact(items.getCommonBacklog());
        Artifact agileTeamArt = null;
        try {
            agileTeamArt = backlogArt.getRelatedArtifact(AtsRelationTypes.AgileTeamToBacklog_AgileTeam);
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        if (agileTeamArt == null) {
            AWorkbench.popup((String)"No Agile Team for Agile Backlog [%s]", (String)backlogArt.toStringWithId());
            return false;
        }
        Set<IAgileSprint> activeSprints = SprintColumn.getActiveSprints(agileTeamArt);
        if (activeSprints.isEmpty()) {
            AWorkbench.popup((String)"No Active Sprints available for the Agile Team [%s]", (String)agileTeamArt.toStringWithId());
            return false;
        }
        SprintFilteredListDialog dialog = SprintColumn.createDialog(items, activeSprints);
        if (dialog.open() == 0) {
            if (dialog.isRemoveFromSprint()) {
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("Remove Sprint");
                for (Artifact artifact : awas) {
                    Collection collection = AtsApiService.get().getAgileService().getRelatedSprints((ArtifactId)artifact);
                    for (ArtifactToken relatedSprint : collection) {
                        changes.unrelate((ArtifactId)artifact, AtsRelationTypes.AgileSprintToItem_AgileSprint, (ArtifactId)relatedSprint);
                    }
                }
                changes.executeIfNeeded();
            } else {
                IAgileSprint selectedSprint = (IAgileSprint)dialog.getSelectedFirst();
                Object var8_12 = null;
                if (selectedSprint != null) {
                    Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(selectedSprint);
                }
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("Set Sprint");
                for (Artifact artifact : awas) {
                    void var8_14;
                    Collection relatedSprintArts = AtsApiService.get().getAgileService().getRelatedSprints((ArtifactId)artifact);
                    for (ArtifactToken relatedSprint : relatedSprintArts) {
                        changes.unrelate((ArtifactId)artifact, AtsRelationTypes.AgileSprintToItem_AgileSprint, (ArtifactId)relatedSprint);
                    }
                    changes.relate((Object)artifact, AtsRelationTypes.AgileSprintToItem_AgileSprint, (Object)var8_14);
                }
                TransactionManager.persistInTransaction((String)"Set Sprint", awas);
            }
            return true;
        }
        return false;
    }

    private static SprintFilteredListDialog createDialog(SprintItems items, Set<IAgileSprint> activeSprints) {
        SprintFilteredListDialog dialog = new SprintFilteredListDialog("Select Sprint", "Select Sprint", activeSprints);
        Window.setDefaultImage((Image)ImageManager.getImage((KeyedImage)AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_SPRINT)));
        dialog.setInput(activeSprints);
        if (items.isCommonSelectedSprint() && items.getMultipleSprints().size() == 1) {
            dialog.setInitialSelections(Arrays.asList(items.getMultipleSprints().iterator().next()));
        }
        return dialog;
    }

    private static Set<IAgileSprint> getActiveSprints(Artifact agileTeamArt) {
        HashSet<IAgileSprint> activeSprints = new HashSet<IAgileSprint>();
        for (Artifact sprintArt : agileTeamArt.getRelatedArtifacts(AtsRelationTypes.AgileTeamToSprint_Sprint)) {
            IAgileSprint agileSprint = AtsApiService.get().getWorkItemService().getAgileSprint((ArtifactToken)sprintArt);
            if (!agileSprint.isActive()) continue;
            activeSprints.add(agileSprint);
        }
        return activeSprints;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        try {
            if (element instanceof Artifact) {
                return Collections.toString((String)"; ", (Iterable)AtsApiService.get().getQueryServiceIde().getArtifact(element).getRelatedArtifacts(AtsRelationTypes.AgileSprintToItem_AgileSprint));
            }
        }
        catch (OseeCoreException ex) {
            return LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<AbstractWorkflowArtifact> awas = new HashSet<AbstractWorkflowArtifact>();
            for (TreeItem item : treeItems) {
                Artifact art;
                if (!(item.getData() instanceof Artifact) || !((art = AtsApiService.get().getQueryServiceIde().getArtifact(item)) instanceof AbstractWorkflowArtifact)) continue;
                awas.add((AbstractWorkflowArtifact)art);
            }
            SprintColumn.promptChangeSprint(awas, true);
            return;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return;
        }
    }
}

