/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.branch;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.branch.BranchData;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;

public class CreateAtsBaselineBranchBlam
extends AbstractBlam {
    private static final String PARENT_BRANCH = "Parent Branch";
    private static final String BRANCH_NAME = "Branch Name";
    private static final String APPLY_ACCESS_CONTROL = "Apply Access Control";

    public String getName() {
        return "Create ATS Baseline Branch";
    }

    public Collection<String> getCategories() {
        return Arrays.asList("ATS.Admin");
    }

    public String getDescriptionUsage() {
        return "Create an ATS Basline Branch including access control and setting associated artifact.";
    }

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<xWidgets>");
        builder.append("<XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"Parent Branch\" />");
        builder.append("<XWidget xwidgetType=\"XText\" displayName=\"Branch Name\"/>");
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Apply Access Control\" defaultValue=\"true\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        builder.append("</xWidgets>");
        return builder.toString();
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        BranchToken parentBranch = (BranchToken)variableMap.getBranch(PARENT_BRANCH);
        if (parentBranch == null) {
            this.log(new String[]{"Must select Parent Branch"});
            return;
        }
        BranchType branchType = AtsApiService.get().getBranchService().getBranchType((BranchId)parentBranch);
        if (!branchType.equals((Object)BranchType.BASELINE)) {
            this.logf("ERROR: Parent Branch %s is [%s] and should be Baseline", new Object[]{parentBranch.toStringWithId(), branchType});
            return;
        }
        String branchName = variableMap.getString(BRANCH_NAME);
        if (Strings.isInValid((String)branchName)) {
            this.log(new String[]{"Must select Branch Name"});
            return;
        }
        boolean applyAccess = variableMap.getBoolean(APPLY_ACCESS_CONTROL);
        BranchData bd = new BranchData();
        bd.setParent((BranchId)parentBranch);
        bd.setAssociatedArt(AtsArtifactToken.AtsCmBranch);
        bd.setAuthor(ArtifactToken.valueOf((long)UserManager.getUser().getId(), (String)UserManager.getUser().getName(), (BranchId)AtsApiService.get().getAtsBranch()));
        bd.setCreationComment(String.format("New Baseline Branch from %s", parentBranch.toStringWithId()));
        bd.setBranchType(BranchType.BASELINE);
        bd.setBranchName(branchName);
        bd.setApplyAccess(applyAccess);
        BranchData createBranch = AtsApiService.get().getBranchService().createBranch(bd);
        if (createBranch.getResults().isErrors()) {
            XResultDataUI.report((XResultData)createBranch.getResults(), (String)this.getName());
        } else {
            if (applyAccess) {
                this.log(new String[]{"NOTE: Apply Access not implemented yet"});
            }
            this.log(new String[]{"Branch Created"});
        }
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.OseeAdmin);
    }
}

