/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.ide.column.AbstractMembersOrderColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.GoalManager;
import org.eclipse.osee.ats.ide.workflow.goal.GoalXViewerFactory;
import org.eclipse.osee.ats.ide.workflow.goal.MembersManager;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class GoalOrderColumn
extends AbstractMembersOrderColumn {
    public static final String COLUMN_ID = "ats.column.goalOrder";
    private boolean backlog = false;
    private GoalManager goalManager;
    static GoalOrderColumn instance = new GoalOrderColumn();

    public static GoalOrderColumn getInstance() {
        return instance;
    }

    public GoalOrderColumn() {
        this(false, COLUMN_ID, "Goal Order");
    }

    protected GoalOrderColumn(boolean backlog, String id, String name) {
        super(id, name, DEFAULT_WIDTH, XViewerAlign.Left, false, SortDataType.Integer, true, "Order of item within displayed " + (backlog ? "Backlog" : "Goal") + ".  Editing this field changes order.");
        this.backlog = backlog;
    }

    public GoalOrderColumn copy() {
        GoalOrderColumn newXCol = new GoalOrderColumn(this.backlog, this.getId(), this.getName());
        super.copy(this, newXCol);
        newXCol.setBacklog(this.backlog);
        return newXCol;
    }

    private void setBacklog(boolean backlog) {
        this.backlog = backlog;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            XViewer xViewer = (XViewer)this.getXViewer();
            IXViewerFactory xViewerFactory = xViewer.getXViewerFactory();
            GoalArtifact parentGoalArtifact = null;
            if (xViewerFactory instanceof GoalXViewerFactory) {
                parentGoalArtifact = ((GoalXViewerFactory)xViewerFactory).getSoleGoalArtifact();
            }
            if (parentGoalArtifact == null) {
                parentGoalArtifact = this.getParentGoalArtifact(treeItem);
            }
            GoalArtifact changedGoal = null;
            if (treeItem.getData() instanceof Artifact) {
                changedGoal = parentGoalArtifact != null ? new GoalManager().promptChangeMemberOrder(parentGoalArtifact, AtsApiService.get().getQueryServiceIde().getArtifact(treeItem)) : new GoalManager().promptChangeGoalOrder(AtsApiService.get().getQueryServiceIde().getArtifact(treeItem));
                if (changedGoal != null) {
                    xViewer.refresh((Object)changedGoal);
                    xViewer.update(treeItem.getData(), null);
                }
                return true;
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public ArtifactTypeToken getArtifactType() {
        return AtsArtifactTypes.Goal;
    }

    public GoalArtifact getParentGoalArtifact(TreeItem treeItem) {
        return GoalOrderColumn.getParentGoalArtifact(treeItem, this.getArtifactType());
    }

    public static GoalArtifact getParentGoalArtifact(TreeItem treeItem, ArtifactTypeToken artifactType) {
        if (Widgets.isAccessible((Widget)treeItem) && Widgets.isAccessible((Widget)treeItem.getParentItem()) && Artifacts.isOfType((Object)treeItem.getParentItem().getData(), (ArtifactTypeToken)artifactType)) {
            return (GoalArtifact)treeItem.getParentItem().getData();
        }
        return null;
    }

    @Override
    public Artifact getParentMembersArtifact(WorldXViewer worldXViewer) {
        return worldXViewer.getParentGoalArtifact();
    }

    @Override
    public MembersManager<?> getMembersManager() {
        if (this.goalManager == null) {
            this.goalManager = new GoalManager();
        }
        return this.goalManager;
    }
}

