/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.version;

import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.config.version.VersionReportJob;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.result.Manipulations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;

public class GenerateFullVersionReportItem
extends XNavigateItemAction {
    private final IAtsTeamDefinition teamDef = null;

    public GenerateFullVersionReportItem(XNavigateItem parent) {
        super(parent, "Generate Full Version Report", (KeyedImage)FrameworkImage.VERSION);
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        IAtsTeamDefinition teamDef = this.getTeamDefinition();
        if (teamDef == null) {
            return;
        }
        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getName(), (String)this.getName())) {
            return;
        }
        PublishReportJob job = new PublishReportJob(teamDef);
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
    }

    private IAtsTeamDefinition getTeamDefinition() {
        if (this.teamDef == null) {
            Set teamDefinitions = null;
            try {
                teamDefinitions = AtsApiService.get().getTeamDefinitionService().getTeamReleaseableDefinitions(Active.Active);
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error loading team definitions", (Throwable)ex);
            }
            TeamDefinitionDialog dialog = new TeamDefinitionDialog();
            dialog.setInput(teamDefinitions);
            int result = dialog.open();
            if (result == 0) {
                return (IAtsTeamDefinition)dialog.getSelectedFirst();
            }
            return null;
        }
        return this.teamDef;
    }

    private static class PublishReportJob
    extends Job {
        private final IAtsTeamDefinition teamDef;

        public PublishReportJob(IAtsTeamDefinition teamDef) {
            super(String.valueOf(teamDef.getName()) + " as of " + DateUtil.getDateNow());
            this.teamDef = teamDef;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                String html = VersionReportJob.getFullReleaseReport(this.teamDef, monitor);
                XResultData rd = new XResultData();
                rd.addRaw(html);
                XResultDataUI.report((XResultData)rd, (String)this.getName(), (Manipulations[])new Manipulations[]{Manipulations.RAW_HTML});
            }
            catch (Exception ex) {
                return new Status(4, "org.eclipse.osee.ats.ide", -1, ex.toString(), (Throwable)ex);
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

