/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.health;

import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Shell;

public class AtsHealthCheckNavigateItem
extends XNavigateItem {
    public AtsHealthCheckNavigateItem(XNavigateItem parent) {
        super(parent, "ATS Health Check", (KeyedImage)PluginUiImage.ADMIN);
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getName(), (String)this.getName())) {
            return;
        }
        Jobs.startJob((Job)new Report(this.getName()), (boolean)true);
    }

    public class Report
    extends Job {
        public Report(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                String name = this.getName();
                String dbName = AtsApiService.get().getConfigValue("DatabaseName");
                if (Strings.isValid((String)dbName)) {
                    name = String.valueOf(name) + name + " - " + dbName;
                }
                XResultData rd = AtsApiService.get().getServerEndpoints().getConfigEndpoint().validate();
                XResultDataUI.report((XResultData)rd, (String)this.getName());
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                return new Status(4, "org.eclipse.osee.ats.ide", -1, ex.getMessage(), (Throwable)ex);
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

