/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionTreeWithChildrenDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.program.Program;

public class EmailTeamsItem
extends XNavigateItemAction {
    private final IAtsTeamDefinition teamDef;
    private final Collection<MemberType> memberTypes;

    public EmailTeamsItem(XNavigateItem parent, IAtsTeamDefinition teamDef, MemberType ... memberType) {
        super(parent, "Email " + (teamDef == null ? "Team " : "\"" + teamDef + "\" Team ") + (Arrays.asList(memberType).contains((Object)MemberType.Both) ? "Leads / Members" : (Arrays.asList(memberType).contains((Object)MemberType.Leads) ? "Leads" : "Members")), (KeyedImage)FrameworkImage.EMAIL);
        this.memberTypes = Arrays.asList(memberType);
        this.teamDef = teamDef;
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        Collection<IAtsTeamDefinition> teamDefs = this.getTeamDefinitions();
        if (teamDefs.isEmpty()) {
            return;
        }
        HashSet<String> emails = new HashSet<String>();
        for (IAtsTeamDefinition teamDef : teamDefs) {
            if (this.memberTypes.contains((Object)MemberType.Members) || this.memberTypes.contains((Object)MemberType.Both)) {
                for (AtsUser user : AtsApiService.get().getTeamDefinitionService().getMembers(teamDef)) {
                    if (!Strings.isValid((String)user.getEmail()) || !user.isActive()) continue;
                    emails.add(user.getEmail());
                }
            }
            if (!this.memberTypes.contains((Object)MemberType.Leads) && !this.memberTypes.contains((Object)MemberType.Both)) continue;
            for (AtsUser user : AtsApiService.get().getTeamDefinitionService().getLeads(teamDef)) {
                if (!Strings.isValid((String)user.getEmail()) || !user.isActive()) continue;
                emails.add(user.getEmail());
            }
        }
        if (emails.isEmpty()) {
            AWorkbench.popup((String)"Error", (String)"No emails or active users configured.");
            return;
        }
        Program.launch((String)("mailto:" + Collections.toString((String)";", emails)));
        AWorkbench.popup((String)"Complete", (String)"Configured emails openened in local email client.");
    }

    public Collection<IAtsTeamDefinition> getTeamDefinitions() {
        if (this.teamDef != null) {
            HashSet<IAtsTeamDefinition> teamDefs = new HashSet<IAtsTeamDefinition>();
            teamDefs.add(this.teamDef);
            teamDefs.addAll(AtsApiService.get().getTeamDefinitionService().getChildren(this.teamDef, true));
            return teamDefs;
        }
        TeamDefinitionTreeWithChildrenDialog ld = new TeamDefinitionTreeWithChildrenDialog(Active.Active);
        int result = ld.open();
        if (result == 0) {
            return AtsApiService.get().getTeamDefinitionService().getTeamDefs(ld.getResultAndRecursedTeamDefs());
        }
        return java.util.Collections.emptyList();
    }

    public static enum MemberType {
        Leads,
        Members,
        Both;

    }
}

