/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.core.agile.AgileUtil;
import org.eclipse.osee.ats.ide.actions.NewAction;
import org.eclipse.osee.ats.ide.actions.NewGoal;
import org.eclipse.osee.ats.ide.actions.OpenArtifactEditorById;
import org.eclipse.osee.ats.ide.actions.OpenOrphanedTasks;
import org.eclipse.osee.ats.ide.actions.RevertDuplicateAtsTransitionByIdAction;
import org.eclipse.osee.ats.ide.actions.RevertDuplicateAtsTransitionsAction;
import org.eclipse.osee.ats.ide.actions.newaction.CreateNewActionBlam;
import org.eclipse.osee.ats.ide.agile.navigate.CreateNewAgileBacklog;
import org.eclipse.osee.ats.ide.agile.navigate.CreateNewAgileFeatureGroup;
import org.eclipse.osee.ats.ide.agile.navigate.CreateNewAgileSprint;
import org.eclipse.osee.ats.ide.agile.navigate.CreateNewAgileTeam;
import org.eclipse.osee.ats.ide.agile.navigate.OpenAgileBacklog;
import org.eclipse.osee.ats.ide.agile.navigate.OpenAgileSprint;
import org.eclipse.osee.ats.ide.agile.navigate.OpenAgileSprintReports;
import org.eclipse.osee.ats.ide.agile.navigate.OpenAgileStoredSprintReports;
import org.eclipse.osee.ats.ide.agile.navigate.SortAgileBacklog;
import org.eclipse.osee.ats.ide.agile.navigate.SyncJiraAndOseeByEpicBlam;
import org.eclipse.osee.ats.ide.branch.CreateAtsBaselineBranchBlam;
import org.eclipse.osee.ats.ide.config.AtsConfig2ExampleNavigateItem;
import org.eclipse.osee.ats.ide.config.editor.AtsConfigResultsEditorNavigateItem;
import org.eclipse.osee.ats.ide.config.version.CreateNewVersionItem;
import org.eclipse.osee.ats.ide.config.version.GenerateFullVersionReportItem;
import org.eclipse.osee.ats.ide.config.version.GenerateVersionReportItem;
import org.eclipse.osee.ats.ide.config.version.MassEditTeamVersionItem;
import org.eclipse.osee.ats.ide.config.version.ParallelConfigurationView;
import org.eclipse.osee.ats.ide.config.version.ReleaseVersionItem;
import org.eclipse.osee.ats.ide.ev.EvNavigateItems;
import org.eclipse.osee.ats.ide.export.AtsExportAction;
import org.eclipse.osee.ats.ide.health.AtsHealthCheckNavigateItem;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.internal.OseePerspective;
import org.eclipse.osee.ats.ide.navigate.ArtifactImpactToActionSearchItem;
import org.eclipse.osee.ats.ide.navigate.AtsRemoteEventTestItem;
import org.eclipse.osee.ats.ide.navigate.ClearAtsConfigCache;
import org.eclipse.osee.ats.ide.navigate.CommaDelimitLines;
import org.eclipse.osee.ats.ide.navigate.CompareEditorExample;
import org.eclipse.osee.ats.ide.navigate.ConvertVersionToAgileSprint;
import org.eclipse.osee.ats.ide.navigate.DisplayCurrentOseeEventListeners;
import org.eclipse.osee.ats.ide.navigate.EmailTeamsItem;
import org.eclipse.osee.ats.ide.navigate.FilteredCheckboxTreeArtifactDialogExample;
import org.eclipse.osee.ats.ide.navigate.FilteredCheckboxTreeDialogExample;
import org.eclipse.osee.ats.ide.navigate.FilteredCheckboxTreeDialogSelectAllExample;
import org.eclipse.osee.ats.ide.navigate.FilteredTreeArtifactDialogExample;
import org.eclipse.osee.ats.ide.navigate.FilteredTreeDialogExample;
import org.eclipse.osee.ats.ide.navigate.FilteredTreeDialogSingleExample;
import org.eclipse.osee.ats.ide.navigate.FirstTimeQualityMetricReportItem;
import org.eclipse.osee.ats.ide.navigate.GenerateIdsAndArtId;
import org.eclipse.osee.ats.ide.navigate.IAtsNavigateItem;
import org.eclipse.osee.ats.ide.navigate.OpenArtifactExplorerViewAction;
import org.eclipse.osee.ats.ide.navigate.OpenArtifactQuickSearchViewAction;
import org.eclipse.osee.ats.ide.navigate.OpenBranchManagerAction;
import org.eclipse.osee.ats.ide.navigate.RecentlyVisitedNavigateItems;
import org.eclipse.osee.ats.ide.navigate.SavedActionSearchNavigateItem;
import org.eclipse.osee.ats.ide.navigate.SearchNavigateItem;
import org.eclipse.osee.ats.ide.navigate.SubscribeByActionableItem;
import org.eclipse.osee.ats.ide.navigate.SubscribeByTeamDefinition;
import org.eclipse.osee.ats.ide.navigate.ToggleAccessControlDebug;
import org.eclipse.osee.ats.ide.navigate.ToggleAtsAdmin;
import org.eclipse.osee.ats.ide.navigate.ValidateOseeTypes;
import org.eclipse.osee.ats.ide.navigate.XResultDataTableExample;
import org.eclipse.osee.ats.ide.notify.EmailActionsBlam;
import org.eclipse.osee.ats.ide.operation.ConvertWorkflowStatesBlam;
import org.eclipse.osee.ats.ide.operation.MoveTeamWorkflowsBlam;
import org.eclipse.osee.ats.ide.search.AtsQuickSearchOperationFactory;
import org.eclipse.osee.ats.ide.search.AtsSearchWorkflowSearchItem;
import org.eclipse.osee.ats.ide.util.AtsEditor;
import org.eclipse.osee.ats.ide.util.CleanupOseeSystemAssignedWorkflows;
import org.eclipse.osee.ats.ide.util.CreateActionUsingAllActionableItems;
import org.eclipse.osee.ats.ide.util.Import.ImportActionsViaSpreadsheetBlam;
import org.eclipse.osee.ats.ide.util.Import.ImportAgileActionsViaSpreadsheetBlam;
import org.eclipse.osee.ats.ide.workdef.ValidateWorkDefinitionNavigateItem;
import org.eclipse.osee.ats.ide.workdef.editor.WorkDefinitionViewer;
import org.eclipse.osee.ats.ide.workflow.cr.CreateNewChangeRequestBlam;
import org.eclipse.osee.ats.ide.world.search.ArtifactTypeSearchItem;
import org.eclipse.osee.ats.ide.world.search.ArtifactTypeWithInheritenceSearchItem;
import org.eclipse.osee.ats.ide.world.search.AtsSearchGoalSearchItem;
import org.eclipse.osee.ats.ide.world.search.AtsSearchTaskSearchItem;
import org.eclipse.osee.ats.ide.world.search.AtsSearchTeamWorkflowSearchItem;
import org.eclipse.osee.ats.ide.world.search.MultipleIdSearchData;
import org.eclipse.osee.ats.ide.world.search.MultipleIdSearchOperation;
import org.eclipse.osee.ats.ide.world.search.MyFavoritesSearchItem;
import org.eclipse.osee.ats.ide.world.search.MySubscribedSearchItem;
import org.eclipse.osee.ats.ide.world.search.MyWorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.NextVersionSearchItem;
import org.eclipse.osee.ats.ide.world.search.SearchTeamWorkflowsByProgramSearchItem;
import org.eclipse.osee.ats.ide.world.search.VersionTargetedForTeamSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.util.OpenPerspectiveNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IOperationFactory;
import org.eclipse.osee.framework.ui.plugin.xnavigate.IXNavigateCommonItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateCommonItems;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateContributionManager;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateExtensionPointData;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemFolder;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemOperation;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateViewItems;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.action.PurgeTransactionAction;
import org.eclipse.osee.framework.ui.skynet.action.XWidgetsDialogExampleAction;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.BlamContributionManager;
import org.eclipse.osee.framework.ui.skynet.change.OpenChangeReportByTransactionIdAction;
import org.eclipse.osee.framework.ui.skynet.results.example.ResultsEditorExample;
import org.eclipse.osee.framework.ui.skynet.results.example.XResultDataDialogExample;
import org.eclipse.osee.framework.ui.skynet.results.example.XResultDataExample;
import org.eclipse.osee.framework.ui.skynet.results.example.XViewerExample;
import org.eclipse.osee.framework.ui.skynet.util.DbConnectionUtility;
import org.eclipse.osee.framework.ui.skynet.util.email.EmailUserGroups;
import org.eclipse.osee.framework.ui.skynet.widgets.xnavigate.XNavigateItemBlam;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.osgi.framework.Bundle;

public final class NavigateViewItems
implements XNavigateViewItems,
IXNavigateCommonItem {
    private final List<XNavigateItem> items = new CopyOnWriteArrayList<XNavigateItem>();
    private boolean ensurePopulatedRanOnce = false;
    private boolean debug = false;
    private static final NavigateViewItems instance = new NavigateViewItems();

    public static NavigateViewItems getInstance() {
        return instance;
    }

    public List<XNavigateItem> getSearchNavigateItems() {
        this.debug = false;
        ElapsedTime time = new ElapsedTime("NavigateViewItems", this.debug);
        this.ensurePopulated();
        time.end();
        return this.items;
    }

    public void addUtilItems(XNavigateItem utilItems) {
        ElapsedTime time = new ElapsedTime("NVI - addUtilItems", this.debug);
        try {
            new ToggleAtsAdmin(utilItems);
            new XNavigateItemBlam(utilItems, (AbstractBlam)new ImportActionsViaSpreadsheetBlam());
            new XNavigateItemBlam(utilItems, (AbstractBlam)new ImportAgileActionsViaSpreadsheetBlam());
            new XNavigateItemAction(utilItems, (Action)new AtsExportAction(), (KeyedImage)FrameworkImage.EXPORT_DATA);
            new GenerateIdsAndArtId(utilItems);
            new ValidateOseeTypes(utilItems);
            new CommaDelimitLines(utilItems);
            new ClearAtsConfigCache(utilItems);
            new XNavigateItemBlam(utilItems, (AbstractBlam)new MoveTeamWorkflowsBlam(), (OseeImage)AtsImage.WORKFLOW);
            new AtsConfigResultsEditorNavigateItem(utilItems);
            new ToggleAccessControlDebug(utilItems);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        time.end();
    }

    private synchronized void ensurePopulated() {
        if (!this.ensurePopulatedRanOnce) {
            if (DbConnectionUtility.areOSEEServicesAvailable().isFalse()) {
                return;
            }
            this.ensurePopulatedRanOnce = true;
            this.addAtsSectionChildren(null);
            ElapsedTime time = new ElapsedTime("NVI - addCommonNavigateItems", this.debug);
            XNavigateCommonItems.addCommonNavigateItems(this.items, Arrays.asList(this.getSectionId()));
            time.end();
        }
    }

    public void addAtsSectionChildren(XNavigateItem item) {
        ElapsedTime time = new ElapsedTime("NVI - addAtsSectionChildren", this.debug);
        try {
            ElapsedTime time2 = new ElapsedTime("NVI - addAtsSectionChildren - My World", this.debug);
            this.items.add(new SearchNavigateItem(item, new MyWorldSearchItem("My World", true)));
            time2.end();
            time2.start("NVI - addAtsSectionChildren - Recently Visited");
            this.items.add((XNavigateItem)new RecentlyVisitedNavigateItems(item));
            time2.end();
            time2.start("NVI - addAtsSectionChildren - Search");
            this.items.add(new SearchNavigateItem(item, new AtsSearchWorkflowSearchItem()));
            time2.end();
            time2.start("NVI - addAtsSectionChildren - Saved Srch");
            this.items.add(new SavedActionSearchNavigateItem(item));
            time2.end();
            this.createAdvancedSearchesSection(item, this.items, null);
            this.createOpenViewsSection(item, this.items);
            time2.start("NVI - addAtsSectionChildren - NewAction");
            this.items.add((XNavigateItem)new XNavigateItemAction(item, (Action)new NewAction(), (OseeImage)AtsImage.NEW_ACTION));
            if (AtsApiService.get().getUserService().isAtsAdmin()) {
                for (AbstractBlam blam : BlamContributionManager.getBlamOperations()) {
                    if (!(blam instanceof CreateNewActionBlam)) continue;
                    this.items.add((XNavigateItem)new XNavigateItemBlam(item, blam, (OseeImage)AtsImage.NEW_ACTION));
                    break;
                }
            }
            for (AbstractBlam blam : BlamContributionManager.getBlamOperations()) {
                if (!(blam instanceof CreateNewChangeRequestBlam)) continue;
                boolean isOverrideAccess = blam.isOverrideAccess();
                Collection myUserGroups = AtsApiService.get().getUserGroupService().getMyUserGroups();
                Collection blamUserGroups = blam.getUserGroups();
                if (!isOverrideAccess && Collections.setIntersection((Collection)blamUserGroups, (Collection)myUserGroups).isEmpty()) continue;
                this.items.add((XNavigateItem)new XNavigateItemBlam(item, blam, (OseeImage)AtsImage.CHANGE_REQUEST));
            }
            time2.end();
            time2.start("NVI - addAtsSectionChildren - agileUser");
            boolean agileUser = AgileUtil.isAgileUser((AtsApi)AtsApiService.get());
            time2.end();
            if (agileUser) {
                this.createAgileSection(item, this.items);
            }
            time2.start("NVI - addAtsSectionChildren - EV Items");
            if (AgileUtil.isEarnedValueUser((AtsApi)AtsApiService.get())) {
                EvNavigateItems.createSection(item, this.items);
            }
            time2.end();
            this.addExtensionPointItems(item, this.items);
            this.createVersionsSection(item, this.items);
            this.createEmailItems(item, this.items);
            this.createReportItems(item, this.items);
            this.createGoalItems(item, this.items);
            this.createAdminItems(item, this.items);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        time.end();
    }

    private void createAdvancedSearchesSection(XNavigateItem parent, List<XNavigateItem> items, AtsUser user) {
        ElapsedTime time = new ElapsedTime("NVI - advSearch", this.debug);
        XNavigateItemFolder advancedSearchesItems = new XNavigateItemFolder(parent, "Advanced Searches");
        new SearchNavigateItem((XNavigateItem)advancedSearchesItems, new MyFavoritesSearchItem("My Favorites", null));
        new SearchNavigateItem((XNavigateItem)advancedSearchesItems, new MySubscribedSearchItem("My Subscribed", null));
        new SearchNavigateItem((XNavigateItem)advancedSearchesItems, new AtsSearchTeamWorkflowSearchItem());
        new SearchNavigateItem((XNavigateItem)advancedSearchesItems, new AtsSearchTaskSearchItem());
        new SearchNavigateItem((XNavigateItem)advancedSearchesItems, new MyWorldSearchItem("User's World", false));
        new ArtifactImpactToActionSearchItem((XNavigateItem)advancedSearchesItems);
        new SearchNavigateItem((XNavigateItem)advancedSearchesItems, new AtsSearchGoalSearchItem());
        new SearchNavigateItem((XNavigateItem)advancedSearchesItems, new SearchTeamWorkflowsByProgramSearchItem("Search Team Workflows by Program", null, false));
        new XNavigateItemOperation((XNavigateItem)advancedSearchesItems, (KeyedImage)FrameworkImage.BRANCH_CHANGE, "Open Change Report(s) by ID(s)", (IOperationFactory)new MultipleIdSearchOperationFactory("Open Change Report(s) by ID(s)", AtsEditor.ChangeReport));
        new XNavigateItemOperation((XNavigateItem)advancedSearchesItems, (OseeImage)AtsImage.OPEN_BY_ID, "Search by ID(s) - Open World Editor", (IOperationFactory)new MultipleIdSearchOperationFactory("Search by ID(s) - Open World Editor", AtsEditor.WorldEditor));
        new XNavigateItemOperation((XNavigateItem)advancedSearchesItems, (OseeImage)AtsImage.OPEN_BY_ID, "Search by ID(s) - Multi-Line - Open World Editor", (IOperationFactory)new MultipleIdMultiLineSearchOperationFactory("Search by ID(s) - Open World Editor", AtsEditor.WorldEditor));
        new XNavigateItemOperation((XNavigateItem)advancedSearchesItems, (OseeImage)AtsImage.WORKFLOW, "Search by ID(s) - Open Workflow Editor", (IOperationFactory)new MultipleIdSearchOperationFactory("Search by ID(s) - Open Workflow Editor", AtsEditor.WorkflowEditor));
        new XNavigateItemOperation((XNavigateItem)advancedSearchesItems, (OseeImage)AtsImage.GLOBE, "Action Quick Search", (IOperationFactory)new AtsQuickSearchOperationFactory());
        items.add((XNavigateItem)advancedSearchesItems);
        time.end();
    }

    private void createOpenViewsSection(XNavigateItem parent, List<XNavigateItem> items) {
        ElapsedTime time = new ElapsedTime("NVI - openViews", this.debug);
        XNavigateItemFolder openViewsItems = new XNavigateItemFolder(parent, "Open Views");
        new XNavigateItemAction((XNavigateItem)openViewsItems, (Action)new OpenArtifactExplorerViewAction(), (KeyedImage)FrameworkImage.ARTIFACT_EXPLORER);
        new XNavigateItemAction((XNavigateItem)openViewsItems, (Action)new OpenArtifactQuickSearchViewAction(), (KeyedImage)FrameworkImage.ARTIFACT_SEARCH);
        new XNavigateItemAction((XNavigateItem)openViewsItems, (Action)new OpenBranchManagerAction(), (KeyedImage)FrameworkImage.BRANCH);
        items.add((XNavigateItem)openViewsItems);
        time.end();
    }

    private void createAdminItems(XNavigateItem parent, List<XNavigateItem> items) {
        ElapsedTime time = new ElapsedTime("NVI - admin", this.debug);
        if (AtsApiService.get().getUserService().isAtsAdmin()) {
            this.createWorkDefinitionsSection(parent, items);
            this.createExampleItems(parent, items);
            XNavigateItem adminItems = new XNavigateItem(parent, "Admin", (KeyedImage)PluginUiImage.ADMIN);
            XNavigateItem dbConvertItems = new XNavigateItem(adminItems, "Database Conversions", (KeyedImage)PluginUiImage.ADMIN);
            new XNavigateItemBlam(dbConvertItems, (AbstractBlam)new ConvertWorkflowStatesBlam());
            new DisplayCurrentOseeEventListeners(adminItems);
            XNavigateItemFolder demoItems = new XNavigateItemFolder(adminItems, "Demo");
            new AtsRemoteEventTestItem((XNavigateItem)demoItems);
            new SearchNavigateItem((XNavigateItem)demoItems, new ArtifactTypeSearchItem("Show all Actions", AtsArtifactTypes.Action));
            new SearchNavigateItem((XNavigateItem)demoItems, new ArtifactTypeSearchItem("Show all Decision Review", AtsArtifactTypes.DecisionReview));
            new SearchNavigateItem((XNavigateItem)demoItems, new ArtifactTypeSearchItem("Show all PeerToPeer Review", AtsArtifactTypes.PeerToPeerReview));
            new SearchNavigateItem((XNavigateItem)demoItems, new ArtifactTypeWithInheritenceSearchItem("Show all Team Workflows", AtsArtifactTypes.TeamWorkflow));
            new SearchNavigateItem((XNavigateItem)demoItems, new ArtifactTypeSearchItem("Show all Tasks", AtsArtifactTypes.Task));
            new CreateActionUsingAllActionableItems((XNavigateItem)demoItems);
            new AtsConfig2ExampleNavigateItem((XNavigateItem)demoItems);
            new XNavigateItemBlam(adminItems, (AbstractBlam)new CreateAtsBaselineBranchBlam());
            new XNavigateItemAction(adminItems, (Action)new OpenChangeReportByTransactionIdAction(), (KeyedImage)FrameworkImage.BRANCH_CHANGE);
            new XNavigateItemAction(adminItems, (Action)new OpenArtifactEditorById(), (KeyedImage)FrameworkImage.ARTIFACT_EDITOR);
            new XNavigateItemAction(adminItems, (Action)new PurgeTransactionAction(), (KeyedImage)FrameworkImage.PURGE);
            XNavigateItemFolder healthItems = new XNavigateItemFolder(adminItems, "Health");
            new AtsHealthCheckNavigateItem((XNavigateItem)healthItems);
            new CleanupOseeSystemAssignedWorkflows((XNavigateItem)healthItems);
            new XNavigateItemAction((XNavigateItem)healthItems, (Action)new OpenOrphanedTasks(), (OseeImage)AtsImage.TASK);
            new XNavigateItemAction(adminItems, (Action)new RevertDuplicateAtsTransitionByIdAction(), (OseeImage)AtsImage.TASK);
            new XNavigateItemAction(adminItems, (Action)new RevertDuplicateAtsTransitionsAction(), (OseeImage)AtsImage.TASK);
            Set extraItems = XNavigateContributionManager.getNavigateItems((String)"org.eclipse.osee.navigate.NavigateView");
            if (!extraItems.isEmpty()) {
                XNavigateItemFolder extra = new XNavigateItemFolder(adminItems, "Other");
                for (XNavigateExtensionPointData extraItem : extraItems) {
                    for (XNavigateItem navigateItem : extraItem.getNavigateItems()) {
                        extra.addChild(navigateItem);
                    }
                }
            }
            items.add(adminItems);
        }
        time.end();
    }

    private void createEmailItems(XNavigateItem parent, List<XNavigateItem> items) {
        ElapsedTime time = new ElapsedTime("NVI - email", this.debug);
        XNavigateItem emailItems = new XNavigateItem(parent, "Email & Notifications", (KeyedImage)FrameworkImage.EMAIL);
        new EmailTeamsItem(emailItems, null, EmailTeamsItem.MemberType.Both);
        new EmailTeamsItem(emailItems, null, EmailTeamsItem.MemberType.Leads);
        new EmailTeamsItem(emailItems, null, EmailTeamsItem.MemberType.Members);
        new EmailUserGroups(emailItems);
        new SubscribeByActionableItem(emailItems);
        new SubscribeByTeamDefinition(emailItems);
        new XNavigateItemBlam(emailItems, (AbstractBlam)new EmailActionsBlam(), (KeyedImage)FrameworkImage.EMAIL);
        items.add(emailItems);
        time.end();
    }

    private void createReportItems(XNavigateItem parent, List<XNavigateItem> items) {
        ElapsedTime time = new ElapsedTime("NVI - report", this.debug);
        XNavigateItem reportItems = new XNavigateItem(parent, "Reports", (OseeImage)AtsImage.REPORT);
        new FirstTimeQualityMetricReportItem(reportItems);
        time.end();
    }

    private void createGoalItems(XNavigateItem parent, List<XNavigateItem> items) {
        ElapsedTime time = new ElapsedTime("NVI - goal", this.debug);
        XNavigateItem goalItems = new XNavigateItem(parent, "Goals", (OseeImage)AtsImage.REPORT);
        items.add((XNavigateItem)new XNavigateItemAction(goalItems, (Action)new NewGoal(), (OseeImage)AtsImage.GOAL));
        time.end();
    }

    private void createExampleItems(XNavigateItem parent, List<XNavigateItem> items) {
        ElapsedTime time = new ElapsedTime("NVI - example", this.debug);
        if (AtsApiService.get().getUserService().isUserMember(CoreUserGroups.OseeAdmin).booleanValue() || AtsApiService.get().getUserService().isUserMember(CoreUserGroups.Everyone).booleanValue()) {
            XNavigateItem exampleItems = new XNavigateItem(parent, "Examples", (OseeImage)AtsImage.REPORT);
            new ResultsEditorExample(exampleItems);
            new CompareEditorExample(exampleItems);
            new XViewerExample(exampleItems);
            new XResultDataExample(exampleItems);
            new XResultDataDialogExample(exampleItems);
            new XResultDataTableExample(exampleItems);
            new FilteredTreeDialogExample(exampleItems);
            new FilteredTreeDialogSingleExample(exampleItems);
            new FilteredTreeArtifactDialogExample(exampleItems);
            new FilteredCheckboxTreeDialogExample(exampleItems);
            new FilteredCheckboxTreeArtifactDialogExample(exampleItems);
            new FilteredCheckboxTreeDialogSelectAllExample(exampleItems);
            new XNavigateItemAction(exampleItems, (Action)new XWidgetsDialogExampleAction(), (KeyedImage)FrameworkImage.GEAR);
            items.add(exampleItems);
        }
        time.end();
    }

    private void createWorkDefinitionsSection(XNavigateItem parent, List<XNavigateItem> items) {
        ElapsedTime time = new ElapsedTime("NVI - workDef", this.debug);
        try {
            XNavigateItem workDefItems = new XNavigateItem(parent, "Work Definition", (KeyedImage)FrameworkImage.VERSION);
            new WorkDefinitionViewer(workDefItems);
            new ValidateWorkDefinitionNavigateItem(workDefItems);
            items.add(workDefItems);
        }
        catch (OseeCoreException oseeCoreException) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Can't create Goals section");
        }
        time.end();
    }

    private void createVersionsSection(XNavigateItem parent, List<XNavigateItem> items) {
        ElapsedTime time = new ElapsedTime("NVI - version", this.debug);
        try {
            XNavigateItem releaseItems = new XNavigateItem(parent, "Versions", (KeyedImage)FrameworkImage.VERSION);
            new ParallelConfigurationView(releaseItems);
            new SearchNavigateItem(releaseItems, new VersionTargetedForTeamSearchItem(null, null, false, WorldSearchItem.LoadView.WorldEditor));
            new SearchNavigateItem(releaseItems, new NextVersionSearchItem(null, WorldSearchItem.LoadView.WorldEditor));
            new GenerateVersionReportItem(releaseItems);
            new GenerateFullVersionReportItem(releaseItems);
            if (AtsApiService.get().getUserService().isAtsAdmin()) {
                new MassEditTeamVersionItem("Team Versions (Admin)", releaseItems, (KeyedImage)FrameworkImage.VERSION);
                new CreateNewVersionItem(releaseItems, null);
                new ReleaseVersionItem(releaseItems, null);
            }
            items.add(releaseItems);
        }
        catch (OseeCoreException oseeCoreException) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Can't create Goals section");
        }
        time.end();
    }

    private void createAgileSection(XNavigateItem parent, List<XNavigateItem> items) {
        ElapsedTime time = new ElapsedTime("NVI - agile section", this.debug);
        try {
            XNavigateItem agileItems = new XNavigateItem(parent, "Agile", (KeyedImage)FrameworkImage.VERSION);
            new OpenAgileBacklog(agileItems);
            new OpenAgileSprint(agileItems);
            new SortAgileBacklog(agileItems);
            XNavigateItem agileReports = new XNavigateItem(agileItems, "Reports", (OseeImage)AtsImage.REPORT);
            new OpenAgileSprintReports(agileReports);
            new OpenAgileStoredSprintReports(agileReports);
            new XNavigateItemBlam(agileReports, (AbstractBlam)new SyncJiraAndOseeByEpicBlam());
            XNavigateItem agileConfigs = new XNavigateItem(agileItems, "Configuration", (KeyedImage)FrameworkImage.GEAR);
            new CreateNewAgileTeam(agileConfigs);
            new CreateNewAgileFeatureGroup(agileConfigs);
            new CreateNewAgileSprint(agileConfigs);
            new CreateNewAgileBacklog(agileConfigs);
            XNavigateItem conversionItems = new XNavigateItem(agileItems, "Conversions", (KeyedImage)FrameworkImage.VERSION);
            new ConvertVersionToAgileSprint(conversionItems);
            items.add(agileItems);
        }
        catch (OseeCoreException oseeCoreException) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Can't create Agile section");
        }
        time.end();
    }

    private void addExtensionPointItems(XNavigateItem parentItem, List<XNavigateItem> items) {
        ElapsedTime time = new ElapsedTime("NVI - extPts", this.debug);
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.osee.ats.ide.AtsNavigateItem");
        if (point == null) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Can't access AtsNavigateItem extension point");
            return;
        }
        IExtension[] extensions = point.getExtensions();
        TreeMap<String, XNavigateItem> nameToNavItem = new TreeMap<String, XNavigateItem>();
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            String classname = null;
            String bundleName = null;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if (el.getName().equals("AtsNavigateItem")) {
                    classname = el.getAttribute("classname");
                    bundleName = el.getContributor().getName();
                }
                ++n4;
            }
            if (classname != null && bundleName != null) {
                Bundle bundle = Platform.getBundle(bundleName);
                try {
                    Object obj = bundle.loadClass(classname).newInstance();
                    IAtsNavigateItem task = (IAtsNavigateItem)obj;
                    if (task != null) {
                        for (XNavigateItem navItem : task.getNavigateItems(parentItem)) {
                            nameToNavItem.put(navItem.getName(), navItem);
                        }
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error loading AtsNavigateItem extension", (Throwable)ex);
                }
            }
            ++n2;
        }
        items.addAll(nameToNavItem.values());
        time.end();
    }

    public void createCommonSection(List<XNavigateItem> items, List<String> excludeSectionIds) {
        XNavigateItem reviewItem = new XNavigateItem(null, "OSEE ATS", (OseeImage)AtsImage.ACTION);
        new OpenPerspectiveNavigateItem(reviewItem, "ATS", OseePerspective.ID, (OseeImage)AtsImage.ACTION);
        this.addAtsSectionChildren(reviewItem);
        items.add(reviewItem);
    }

    public String getSectionId() {
        return "ATS";
    }

    public void clearCaches() {
        this.ensurePopulatedRanOnce = false;
        this.items.clear();
    }

    private static final class MultipleIdMultiLineSearchOperationFactory
    implements IOperationFactory {
        private final AtsEditor atsEditor;
        private final String operationName;

        public MultipleIdMultiLineSearchOperationFactory(String operationName, AtsEditor atsEditor) {
            this.operationName = operationName;
            this.atsEditor = atsEditor;
        }

        public IOperation createOperation() {
            MultipleIdSearchOperation op = new MultipleIdSearchOperation(new MultipleIdSearchData(this.operationName, this.atsEditor));
            op.setMultiLine(true);
            return op;
        }
    }

    private static final class MultipleIdSearchOperationFactory
    implements IOperationFactory {
        private final AtsEditor atsEditor;
        private final String operationName;

        public MultipleIdSearchOperationFactory(String operationName, AtsEditor atsEditor) {
            this.operationName = operationName;
            this.atsEditor = atsEditor;
        }

        public IOperation createOperation() {
            return new MultipleIdSearchOperation(new MultipleIdSearchData(this.operationName, this.atsEditor));
        }
    }
}

