/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.util.ArtifactTypeAndDescriptiveLabelProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredCheckboxTreeArtifactDialog;
import org.eclipse.osee.framework.ui.swt.Displays;

public class ReAssignATSObjectsToUser
extends AbstractBlam {
    public static final String FROM_ASSIGNEE = "From Assignee";
    public static final String TO_ASSIGNEE = "To Assignee";

    public String getName() {
        return "Admin - Re-Assign ATS Objects To User";
    }

    public void runOperation(final VariableMap variableMap, IProgressMonitor monitor) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    User fromUser = variableMap.getUser(ReAssignATSObjectsToUser.FROM_ASSIGNEE);
                    if (fromUser == null) {
                        AWorkbench.popup((String)"ERROR", (String)"Please select From Assignee");
                        return;
                    }
                    User toUser = variableMap.getUser(ReAssignATSObjectsToUser.TO_ASSIGNEE);
                    if (toUser == null) {
                        AWorkbench.popup((String)"ERROR", (String)"Please select To Assignee");
                        return;
                    }
                    Set<Artifact> assignedToArts = AtsEditors.getAssigned(AtsApiService.get().getUserService().getUserById((ArtifactId)fromUser));
                    HashSet<Artifact> atsArts = new HashSet<Artifact>();
                    for (Artifact assignedArt : assignedToArts) {
                        if (!(assignedArt instanceof AbstractWorkflowArtifact)) continue;
                        atsArts.add(assignedArt);
                    }
                    if (atsArts.isEmpty()) {
                        AWorkbench.popup((String)"ERROR", (String)("Not workflows, tasks or reviews assigned to " + fromUser));
                        return;
                    }
                    FilteredCheckboxTreeArtifactDialog dialog = new FilteredCheckboxTreeArtifactDialog("ReAssign ATS Object to User", "Select to re-assign to user \"" + toUser, atsArts, (ILabelProvider)new ArtifactTypeAndDescriptiveLabelProvider());
                    dialog.setShowSelectButtons(true);
                    if (dialog.open() != 0) {
                        return;
                    }
                    Collection artsToReAssign = dialog.getChecked();
                    IAtsChangeSet changes = AtsApiService.get().createChangeSet("ReAssign ATS Object to User");
                    for (Artifact artifact : artsToReAssign) {
                        if (!(artifact instanceof AbstractWorkflowArtifact)) continue;
                        AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)artifact;
                        awa.getStateMgr().removeAssignee(AtsApiService.get().getUserService().getUserById((ArtifactId)fromUser));
                        awa.getStateMgr().addAssignee(AtsApiService.get().getUserService().getUserById((ArtifactId)toUser));
                        changes.add((Object)awa);
                    }
                    changes.execute();
                }
                catch (Exception ex) {
                    ReAssignATSObjectsToUser.this.log(ex);
                }
            }
        });
    }

    public String getXWidgetsXml() {
        StringBuffer buffer = new StringBuffer("<xWidgets>");
        buffer.append("<XWidget xwidgetType=\"XMembersComboAll\" displayName=\"From Assignee\" />");
        buffer.append("<XWidget xwidgetType=\"XMembersCombo\" displayName=\"To Assignee\" />");
        buffer.append("</xWidgets>");
        return buffer.toString();
    }

    public String getDescriptionUsage() {
        return "Re-Assign ATS Workflows, Tasks and Reviews to another user.  Enter to and from User and select play.  You will be promted to select the ATS Objects to reassign.";
    }

    public Collection<String> getCategories() {
        return Arrays.asList("ATS.Admin");
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }
}

