/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.Import;

import java.io.File;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.Import.ExcelAtsTaskArtifactExtractor;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.logging.OseeLog;

public class TaskImportJob
extends Job {
    private final File file;
    private final ExcelAtsTaskArtifactExtractor atsTaskExtractor;
    private XResultData errorLog;

    public TaskImportJob(File file, ExcelAtsTaskArtifactExtractor atsTaskExtractor) {
        super("Importing Tasks");
        this.file = file;
        this.atsTaskExtractor = atsTaskExtractor;
    }

    public TaskImportJob(File file, ExcelAtsTaskArtifactExtractor atsTaskExtractor, XResultData blamXResultData) {
        this(file, atsTaskExtractor);
        this.errorLog = blamXResultData;
    }

    public IStatus run(IProgressMonitor monitor) {
        IStatus toReturn = Status.CANCEL_STATUS;
        try {
            try {
                this.atsTaskExtractor.setMonitor(monitor);
                monitor.beginTask("Importing Tasks", 0);
                if (this.file != null && this.file.isFile()) {
                    try {
                        this.atsTaskExtractor.process(this.file.toURI(), this.errorLog);
                    }
                    catch (Throwable ex) {
                        throw new Exception(ex.getMessage(), ex.getCause());
                    }
                } else {
                    throw new OseeArgumentException("All files passed must be a file", new Object[0]);
                }
                toReturn = Status.OK_STATUS;
            }
            catch (Exception ex) {
                if (ex.getCause().getMessage() != "Invalid BLAM Spreadsheet") {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    toReturn = new Status(4, "org.eclipse.osee.ats.ide", -1, ex.getMessage(), (Throwable)ex);
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return toReturn;
    }
}

