/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.UserCheckTreeDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelCmdValueSelection;

public class XAssigneesHyperlinkWidget
extends XHyperlinkLabelCmdValueSelection {
    public static final Object WIDGET_ID = XAssigneesHyperlinkWidget.class.getSimpleName();
    Collection<AtsUser> assignees = new HashSet<AtsUser>();
    private final IAtsTeamDefinition teamDef;

    public XAssigneesHyperlinkWidget(IAtsTeamDefinition teamDef) {
        super("Assignees", true, Integer.valueOf(50));
        this.teamDef = teamDef;
    }

    public String getCurrentValue() {
        HashSet<String> assigneeNames = new HashSet<String>();
        for (AtsUser singleAssignee : this.assignees) {
            assigneeNames.add(singleAssignee.getName());
        }
        return Collections.toString((String)"; ", assigneeNames);
    }

    public boolean handleSelection() {
        UserCheckTreeDialog uld = new UserCheckTreeDialog("Select Assigness", "Select to assign.\nDeSelect to un-assign.", AtsApiService.get().getUserService().getUsers(Active.Active));
        if (this.teamDef != null) {
            uld.setTeamMembers(AtsApiService.get().getTeamDefinitionService().getMembersAndLeads(this.teamDef));
        }
        if (!this.assignees.isEmpty()) {
            uld.setInitialSelections(this.assignees);
        }
        if (uld.open() == 0) {
            Collection<AtsUser> users = uld.getUsersSelected();
            this.assignees.clear();
            this.assignees.addAll(users);
            return true;
        }
        return false;
    }

    public boolean handleClear() {
        this.assignees.clear();
        return true;
    }

    public Collection<AtsUser> getSelected() {
        return this.assignees;
    }

    public Collection<AtsUser> getAssignees() {
        return this.assignees;
    }
}

