/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.commit.menu;

import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class CommitOverrideAction
extends Action {
    private final AtsApi atsApi;
    private final IAtsTeamWorkflow teamWf;
    private final BranchToken branch;

    public CommitOverrideAction(IAtsTeamWorkflow teamWf, BranchToken branch, AtsApi atsApi) {
        super(String.format("Override Commit for [%s]", branch.getName()));
        this.teamWf = teamWf;
        this.branch = branch;
        this.atsApi = atsApi;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.ADD_GREEN);
    }

    public void run() {
        try {
            Result result;
            EntryDialog dialog = new EntryDialog("Override Commit", String.valueOf(this.getText()) + "\n\nEnter Reason");
            if (dialog.open() == 0 && (result = this.atsApi.getBranchService().getCommitOverrideOps().setCommitOverride(this.teamWf, (BranchId)this.branch, dialog.getEntry())).isFalse()) {
                AWorkbench.popup((String)this.getText(), (String)result.getText());
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

