/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.support.test.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;
import org.eclipse.osee.framework.jdk.core.type.MutableInteger;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.MatchFilter;
import org.eclipse.osee.support.test.util.UnitTestUtil;

public class SourceCounter {
    private static int sourceFileCounter = 0;
    private static int slocCounter = 0;
    private static final CountingMap<String> authorToFileCount = new CountingMap(10);
    private static final CountingMap<String> authorToSlocCount = new CountingMap(10);
    private static final CountingMap<String> packageToSlocCount = new CountingMap(10);
    private static final CountingMap<String> productToSlocCount = new CountingMap(10);
    private static List<String> gitRepos = Arrays.asList("C:\\UserData\\git_merge\\org.eclipse.osee\\plugins\\", "C:\\UserData\\git_merge\\lba.osee\\plugins\\");
    private static Pattern semiPattern = Pattern.compile("\\;");
    private static Set<String> bundleNames;

    public static void main(String[] args) {
        try {
            StringBuffer results = new StringBuffer();
            StringBuffer errors = new StringBuffer();
            bundleNames = new HashSet<String>();
            for (String dirNam : gitRepos) {
                File dir1 = new File(dirNam);
                for (String bundleMatchStr : Arrays.asList(".*\\.osee\\..*", ".*\\.ats\\..*", ".*\\.xviewer\\..*", ".*\\.tte\\..*", ".*\\.lba\\..*", ".*\\.rdt\\..*", ".*\\.coverage\\..*")) {
                    for (String filename : Lib.readListFromDir((File)dir1, (FilenameFilter)new MatchFilter(bundleMatchStr), (boolean)true)) {
                        if (!Strings.isValid((String)filename)) continue;
                        bundleNames.add(filename);
                    }
                }
                bundleNames.remove("org.eclipse.osee.support.dev.java");
                bundleNames.remove("org.eclipse.osee.framework.ui.data.model.editor");
                for (String filename : bundleNames) {
                    System.out.println(String.format("Processing [%s]", filename));
                    File file = new File(dir1 + "\\" + filename);
                    SourceCounter.recurseAndFind(file, results, errors);
                }
            }
            results.append("\n\nSource files by Author\n");
            results.append("\nAuthor, Count, Percent of Total\n");
            results.append("\nTotal, " + sourceFileCounter + "\n");
            ArrayList<String> names = new ArrayList<String>();
            for (Map.Entry entry : authorToFileCount.getCounts()) {
                System.out.println(String.format("Author [%s]", entry.getKey()));
                int count = ((MutableInteger)entry.getValue()).getValue();
                double percent = new Double(count) / new Double(sourceFileCounter);
                names.add(String.valueOf((String)entry.getKey()) + ", " + entry.getValue() + ", " + SourceCounter.doubleToI18nString(percent, false) + "\n");
            }
            Collections.sort(names);
            for (String name : names) {
                results.append(name);
            }
            results.append("\n\nSLOC by Author\n");
            results.append("\nAuthor, Count, Percent of Total\n");
            results.append("\nTotal, " + slocCounter + "\n");
            names.clear();
            for (Map.Entry entry : authorToSlocCount.getCounts()) {
                int count = ((MutableInteger)entry.getValue()).getValue();
                double percent = new Double(count) / new Double(slocCounter);
                names.add(String.valueOf((String)entry.getKey()) + ", " + count + ", " + SourceCounter.doubleToI18nString(percent, false) + "\n");
            }
            Collections.sort(names);
            for (String name : names) {
                results.append(name);
            }
            results.append("\n\nSLOC by Product/Feature\n");
            results.append("\nProduct, Count, Percent of Total\n");
            names.clear();
            for (Map.Entry entry : productToSlocCount.getCounts()) {
                String featureName = (String)entry.getKey();
                int count = ((MutableInteger)entry.getValue()).getValue();
                double percent = new Double(count) / new Double(slocCounter);
                names.add(String.valueOf(featureName) + ", " + count + ", " + SourceCounter.doubleToI18nString(percent, false) + "\n");
            }
            Collections.sort(names);
            for (String name : names) {
                results.append(name);
            }
            results.append("\n\nSLOC By Package\n");
            names.clear();
            for (Map.Entry entry : packageToSlocCount.getCounts()) {
                String packageName = (String)entry.getKey();
                String featureName = SourceCounter.getFeatureName(packageName);
                MutableInteger slocs = (MutableInteger)entry.getValue();
                names.add(String.valueOf(packageName) + ", " + slocs + ", " + featureName + "\n");
            }
            Collections.sort(names);
            for (String name : names) {
                results.append(name);
            }
            results.append("\n\nBundles Searched \n");
            for (String bundle : bundleNames) {
                results.append("bundle: " + bundle + "\n");
            }
            results.append("\n\n");
            XConsoleLogger.err((String)("\n\n" + errors), (Object[])new Object[0]);
            String outputFilename = "C:\\UserData\\SourceCounter.csv";
            System.out.println("\n\nResults written to " + outputFilename + "\n");
            Lib.writeStringToFile((String)(String.valueOf(results.toString()) + "\n\n" + errors.toString()), (File)new File(outputFilename));
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
        }
    }

    private static String doubleToI18nString(double d, boolean blankIfZero) {
        if (blankIfZero && d == 0.0) {
            return "";
        }
        if (d == 0.0) {
            return "0.00";
        }
        return String.format("%4.2f", d);
    }

    private static String getFeatureName(String thePackageName) {
        String packageName = thePackageName.toLowerCase();
        if (packageName.contains("trax")) {
            return "TRAX";
        }
        if (packageName.contains("cpcr")) {
            return "CPCR";
        }
        if (packageName.contains("tpcr")) {
            return "tpcr";
        }
        if (packageName.contains("process") || packageName.contains("pacr")) {
            return "pacr";
        }
        if (packageName.contains("ats")) {
            if (packageName.contains("review") || packageName.contains("peer")) {
                return "Peer";
            }
            if (packageName.contains("promote")) {
                return "Engineering Build";
            }
            return "ATS";
        }
        if (packageName.contains("rdt")) {
            return "RDT";
        }
        if (packageName.contains("ote")) {
            return "OTE";
        }
        if (packageName.contains("coverage")) {
            return "Coverage";
        }
        if (packageName.contains("osee.display") || packageName.contains("orcs")) {
            return "OSEE Web";
        }
        if (packageName.contains("skynet.results")) {
            return "Results Editor";
        }
        if (packageName.contains("branch.gantt")) {
            return "Branch Visualization";
        }
        if (packageName.contains("xviewer")) {
            return "XViewer";
        }
        if (packageName.contains("skywalker")) {
            return "Skywalker";
        }
        if (packageName.contains("tte")) {
            return "TTE";
        }
        if (packageName.contains("widget") || packageName.contains("skynet.widgets") || packageName.contains("swt")) {
            return "XWidgets";
        }
        if (packageName.contains("event") || packageName.contains("messaging")) {
            return "Event System";
        }
        if (packageName.contains("define")) {
            return "Define";
        }
        if (packageName.contains("artifact") || packageName.contains("attribute") || packageName.contains("relation")) {
            return "Persistence";
        }
        if (packageName.contains("test")) {
            return "Testing";
        }
        if (packageName.contains("framework") || packageName.contains("client.integration") || packageName.contains("cluster") || packageName.contains("executor") || packageName.contains("database")) {
            return "Framework";
        }
        return "Unknown";
    }

    private static void recurseAndFind(File file, StringBuffer results, StringBuffer errors) throws IOException {
        if (file.isDirectory()) {
            for (String filename : Lib.readListFromDir((File)file, (FilenameFilter)new MatchFilter(".*"), (boolean)true)) {
                File childFile = new File(String.valueOf(file.getAbsolutePath()) + "\\" + filename);
                SourceCounter.recurseAndFind(childFile, results, errors);
            }
        }
        if (file.getAbsolutePath().endsWith(".java")) {
            String text = Lib.fileToString((File)file);
            if (file.getAbsolutePath().contains("src-gen")) {
                System.out.println("Ignoring SRC-GEN file [%s]" + file.getAbsolutePath());
            } else if (file.getName().contains("UnitTestCounter") || file.getName().contains("UnitTestUtil")) {
                System.out.println("Ignoring Counter and Util file cause author search string in [%s]" + file.getAbsolutePath());
            } else {
                ++sourceFileCounter;
                Set<String> authors = UnitTestUtil.getAuthors(text);
                if (authors.isEmpty()) {
                    if (file.getAbsolutePath().toLowerCase().contains("rdt")) {
                        authors.add("Robert A. Fisher");
                    } else if (file.getAbsolutePath().toLowerCase().contains("ote")) {
                        authors.add("OTE Team");
                    } else {
                        errors.append(String.format("File [%s] has no authors\n", file.getName()));
                        authors.add("unauthored");
                    }
                }
                Matcher m = semiPattern.matcher(text);
                int slocCount = 0;
                while (m.find()) {
                    ++slocCount;
                }
                slocCounter += slocCount;
                for (String author : authors) {
                    authorToFileCount.put((Object)author);
                    authorToSlocCount.put((Object)author, slocCount);
                }
                String packageName = SourceCounter.getPackageName(file);
                packageToSlocCount.put((Object)packageName, slocCount);
                String featureName = SourceCounter.getFeatureName(packageName);
                productToSlocCount.put((Object)featureName, slocCount);
                XConsoleLogger.err((String)String.format("[%s] sloc from author(s) [%s] for file [%s] and package [%s]", slocCount, authors, file.getName(), packageName), (Object[])new Object[0]);
            }
        }
    }

    private static String getPackageName(File file) {
        String filename = file.getAbsolutePath();
        filename = filename.replaceFirst("^.*src\\\\", "");
        filename = filename.replaceFirst(file.getName(), "");
        filename = filename.replaceAll("\\\\", ".");
        filename = filename.replace("\\.$", "");
        return filename;
    }
}

