/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.eclipse.osee.cache.admin.CacheAdmin;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.exception.UserNotInDatabase;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserAdmin;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.internal.users.UserAdminImpl;

public final class UserManager {
    public static String DOUBLE_CLICK_SETTING_KEY_EDIT = "onDoubleClickOpenUsingEditMode";
    private static AtomicBoolean showTokenForChangeName;
    private static final LazyObject<UserAdmin> provider;

    static {
        provider = new LazyObject<UserAdmin>(){

            protected FutureTask<UserAdmin> createLoaderTask() {
                Callable<UserAdmin> callable = new Callable<UserAdmin>(){

                    @Override
                    public UserAdmin call() throws Exception {
                        UserAdminImpl userAdmin = new UserAdminImpl();
                        CacheAdmin cacheAdmin = ServiceUtil.getCacheAdmin();
                        userAdmin.setCacheAdmin(cacheAdmin);
                        userAdmin.start();
                        return userAdmin;
                    }
                };
                return new FutureTask<UserAdmin>(callable);
            }
        };
    }

    private UserManager() {
    }

    private static UserAdmin getUserAdmin() {
        return (UserAdmin)provider.get();
    }

    public static User getUser() {
        return UserManager.getUserAdmin().getCurrentUser();
    }

    public static void releaseUser() {
        UserManager.getUserAdmin().releaseCurrentUser();
    }

    public static void clearCache() {
        UserManager.getUserAdmin().reset();
    }

    public static List<User> getUsersByUserId(Collection<String> userIds) {
        ArrayList<User> users = new ArrayList<User>();
        for (String userId : userIds) {
            try {
                User user = UserManager.getUserAdmin().getUserByUserId(userId);
                if (user == null) continue;
                users.add(user);
            }
            catch (UserNotInDatabase ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return users;
    }

    public static List<User> getUsers() {
        return UserManager.getUserAdmin().getActiveUsers();
    }

    public static List<User> getUsersAll() {
        return UserManager.getUserAdmin().getUsersAll();
    }

    public static List<User> getUsersSortedByName() {
        return UserManager.getUserAdmin().getActiveUsersSortedByName();
    }

    public static List<User> getUsersAllSortedByName() {
        return UserManager.getUserAdmin().getUsersAllSortedByName();
    }

    public static String[] getUserNames() {
        return UserManager.getUserAdmin().getUserNames();
    }

    public static String getSafeUserNameById(ArtifactId userArtifactId) {
        UserAdmin userAdmin = null;
        try {
            userAdmin = UserManager.getUserAdmin();
        }
        catch (OseeCoreException oseeCoreException) {}
        String name = userAdmin == null ? String.format("Unable resolve user by artId[%s] since userAdmin was unavailable", userArtifactId) : userAdmin.getSafeUserNameById(userArtifactId);
        return name;
    }

    public static User getUserByArtId(ArtifactId userArtifactId) {
        return UserManager.getUserAdmin().getUserByArtId(userArtifactId);
    }

    public static User getUserByArtId(long userArtifactId) {
        return UserManager.getUserAdmin().getUserByArtId(ArtifactId.valueOf((Long)userArtifactId));
    }

    public static User getUserByName(String name) {
        return UserManager.getUserAdmin().getUserByName(name);
    }

    public static User getUser(UserToken user) {
        return UserManager.getUserAdmin().getUser(user);
    }

    public static User getUserByUserId(String userId) {
        return UserManager.getUserAdmin().getUserByUserId(userId);
    }

    public static boolean duringMainUserCreation() {
        return UserManager.getUserAdmin().isDuringCurrentUserCreation();
    }

    public static String getSetting(String key) {
        return UserManager.getUser().getSetting(key);
    }

    public static String getSetting(Long key) {
        return UserManager.getUser().getSetting(String.valueOf(key));
    }

    public static boolean getBooleanSetting(String key) {
        return UserManager.getUser().getBooleanSetting(key);
    }

    public static void setSetting(String key, String value) {
        UserManager.getUser().setSetting(key, value);
    }

    public static void setSetting(String key, Long value) {
        UserManager.getUser().setSetting(key, String.valueOf(value));
    }

    public static void setShowTokenForChangeName(boolean showTokenForChangeName) {
        UserManager.showTokenForChangeName.set(showTokenForChangeName);
        UserManager.getUser().setBooleanSetting("osee.show.token.for.change.name", showTokenForChangeName);
    }

    public static synchronized boolean isShowTokenForChangeName() {
        if (showTokenForChangeName == null) {
            showTokenForChangeName = new AtomicBoolean(false);
            showTokenForChangeName.set(UserManager.getUser().getBooleanSetting("osee.show.token.for.change.name"));
        }
        return showTokenForChangeName.get();
    }

    public static boolean isBootstrap() {
        return UserManager.getUser().getUserId().equals("bootstrap");
    }
}

