/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.users;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.cache.admin.CacheDataLoader;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.core.exception.MultipleArtifactsExist;
import org.eclipse.osee.framework.core.exception.UserInDatabaseMultipleTimes;
import org.eclipse.osee.framework.core.exception.UserNotInDatabase;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class UserDataLoader
implements CacheDataLoader<String, User> {
    public Map<String, User> load(Iterable<? extends String> keys) {
        List<Artifact> artifacts = ArtifactQuery.getArtifactListFromType(CoreArtifactTypes.User, (BranchId)CoreBranches.COMMON);
        HashMap<String, User> result = new HashMap<String, User>();
        for (Artifact artifact : artifacts) {
            User user = (User)artifact;
            result.put(user.getUserId(), user);
        }
        return result;
    }

    public User load(String userId) {
        User user = null;
        try {
            Artifact artifact = ArtifactQuery.getArtifactFromTypeAndAttribute((ArtifactTypeId)CoreArtifactTypes.User, (AttributeTypeId)CoreAttributeTypes.UserId, userId, (BranchId)CoreBranches.COMMON);
            user = (User)artifact;
        }
        catch (ArtifactDoesNotExist ex1) {
            throw new UserNotInDatabase((Throwable)ex1, "Unable to load user with userId[%s]", new Object[]{userId});
        }
        catch (MultipleArtifactsExist ex2) {
            throw new UserInDatabaseMultipleTimes((Throwable)ex2, "Unable to load user with userId[%s] - multiple users found.", new Object[]{userId});
        }
        return user;
    }

    public User reload(String key, User oldValue) {
        Collection<? extends Artifact> reloadArtifacts = ArtifactQuery.reloadArtifacts(Collections.singleton(oldValue));
        ArtifactToken artifact = reloadArtifacts.isEmpty() ? null : (ArtifactToken)reloadArtifacts.iterator().next();
        return (User)artifact;
    }
}

