/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.users;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.eclipse.osee.cache.admin.CacheKeysLoader;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class UserKeysProvider
extends LazyObject<Iterable<? extends String>>
implements CacheKeysLoader<String> {
    public Iterable<? extends String> getAllKeys() {
        return (Iterable)this.get();
    }

    protected FutureTask<Iterable<? extends String>> createLoaderTask() {
        Callable<Iterable<? extends String>> callable = new Callable<Iterable<? extends String>>(){

            @Override
            public Iterable<? extends String> call() throws Exception {
                LinkedHashSet<String> userIds = new LinkedHashSet<String>();
                List<Artifact> artifacts = ArtifactQuery.getArtifactListFromType(CoreArtifactTypes.User, (BranchId)CoreBranches.COMMON);
                for (Artifact artifact : artifacts) {
                    User user = (User)artifact;
                    userIds.add(user.getUserId());
                }
                return userIds;
            }
        };
        return new FutureTask<Iterable<? extends String>>(callable);
    }
}

