/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.order.IRelationSorter;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderData;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationSorterProvider;

public class RelationTypeSideSorter
extends RelationTypeSide {
    private final RelationTypeToken relationType;
    private final RelationOrderData orderData;
    private final RelationSorterProvider sorterProvider;
    private final Map<Artifact, RelationLink> artToRelation = new HashMap<Artifact, RelationLink>();

    public RelationTypeSideSorter(RelationTypeToken relationType, RelationSide side, RelationSorterProvider sorterProvider, RelationOrderData orderData) {
        super(relationType, side);
        this.relationType = relationType;
        this.sorterProvider = sorterProvider;
        this.orderData = orderData;
    }

    public Artifact getArtifact() {
        return this.orderData.getArtifact();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof RelationTypeSideSorter) {
            RelationTypeSideSorter arg = (RelationTypeSideSorter)((Object)arg0);
            if (this.getArtifact() == null && arg.getArtifact() == null) {
                return super.equals((Object)arg);
            }
            if (this.getArtifact() == null) {
                return false;
            }
            if (arg.getArtifact() == null) {
                return false;
            }
            return this.getArtifact().equals((Object)arg.getArtifact()) && super.equals((Object)arg);
        }
        return super.equals(arg0);
    }

    public RelationSorter getSorterId() {
        return this.orderData.getCurrentSorterGuid(this.relationType, this.getSide());
    }

    public void sort(List<? extends ArtifactToken> listToOrder) {
        IRelationSorter order = this.sorterProvider.getRelationOrder(this.getSorterId());
        List<String> relativeOrder = this.orderData.getOrderList(this.getRelationType(), this.getSide());
        order.sort(listToOrder, relativeOrder);
    }

    public void sortRelations(List<? extends RelationLink> listToOrder) {
        IRelationSorter order = this.sorterProvider.getRelationOrder(this.getSorterId());
        List<String> relativeOrder = this.orderData.getOrderList(this.getRelationType(), this.getSide());
        order.sortRelations(listToOrder, relativeOrder);
    }

    public RelationLink getRelation(Artifact artifact) {
        return this.artToRelation.get((Object)artifact);
    }

    public void addItem(RelationSorter sorterId, Artifact itemToAdd) {
        RelationSorter sorterIdToUse = sorterId;
        if (sorterIdToUse == RelationSorter.PREEXISTING) {
            sorterIdToUse = this.getSorterId();
        }
        List<Artifact> relatives = Collections.emptyList();
        if (RelationSorter.USER_DEFINED == sorterIdToUse) {
            Artifact target = this.getArtifact();
            relatives = target.getRelatedArtifacts(this);
            if (relatives.contains((Object)itemToAdd)) {
                relatives.remove((Object)itemToAdd);
            }
            relatives.add(itemToAdd);
        }
        this.setOrder(relatives, sorterIdToUse);
    }

    public void removeItem(ArtifactId itemToRemove) {
        Artifact target;
        List<Artifact> relatives = Collections.emptyList();
        if (RelationSorter.USER_DEFINED == this.getSorterId() && (relatives = (target = this.getArtifact()).getRelatedArtifacts(this)).contains(itemToRemove)) {
            relatives.remove(itemToRemove);
        }
        this.setOrder(relatives, this.getSorterId());
    }

    public void setOrder(List<Artifact> relatives, RelationSorter sorterId) {
        this.orderData.store(this.relationType, this.getSide(), sorterId, relatives);
    }

    public String toString() {
        RelationSorter sorterId = null;
        try {
            sorterId = this.getSorterId();
        }
        catch (Exception exception) {}
        return String.format("Relation Sorter {relationType=%s, relationSide=[%s], artifact=%s, sorterId=%s}", new Object[]{this.getRelationType(), this.getSide(), this.getArtifact(), sorterId});
    }

    public RelationTypeToken getRelationType() {
        return this.relationType;
    }
}

