/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.internal.Activator;

public class EmailUtil {
    private static Pattern addressPattern = Pattern.compile(".+?@.+?\\.[a-z]+");

    public static boolean isEmailValid(String email) {
        return addressPattern.matcher(email).matches();
    }

    public static boolean isEmailValid(User user) {
        return EmailUtil.isEmailValid(user.getEmail());
    }

    public static Collection<User> getValidEmailUsers(Collection<User> users) {
        HashSet<User> validUsers = new HashSet<User>();
        for (User user : users) {
            try {
                if (!EmailUtil.isEmailValid(user)) continue;
                validUsers.add(user);
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return validUsers;
    }

    public static Collection<User> getActiveEmailUsers(Collection<? extends User> users) {
        HashSet<User> activeUsers = new HashSet<User>();
        for (User user : users) {
            try {
                if (!user.isActive()) continue;
                activeUsers.add(user);
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return activeUsers;
    }
}

