/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.object;

import org.eclipse.osee.framework.core.access.object.ArtifactAccessObject;
import org.eclipse.osee.framework.core.access.object.BranchAccessObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.HasBranch;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public abstract class AccessObject
implements HasBranch {
    private final NamedId id;

    public abstract void removeFromCache();

    public AccessObject(NamedId id) {
        this.id = id;
    }

    public boolean isArtifact() {
        return this.id instanceof ArtifactId;
    }

    public boolean isBranch() {
        return this.id instanceof BranchId;
    }

    public abstract Long getId();

    public String toStringWithId() {
        return this.id.toStringWithId();
    }

    public static AccessObject valueOf(Object object) {
        if (object instanceof AccessObject) {
            return (AccessObject)object;
        }
        if (object instanceof ArtifactToken) {
            return ArtifactAccessObject.valueOf((ArtifactToken)object);
        }
        if (object instanceof BranchToken) {
            return BranchAccessObject.valueOf((BranchToken)object);
        }
        throw new OseeArgumentException("object must be ArtifactToken or BranchToken", new Object[0]);
    }
}

