/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public enum RelationSide {
    SIDE_A,
    SIDE_B;


    public RelationSide oppositeSide() {
        return this == SIDE_A ? SIDE_B : SIDE_A;
    }

    public boolean isSideA() {
        return this == SIDE_A;
    }

    public boolean isOppositeSide(RelationSide side) {
        return this != side;
    }

    public static RelationSide fromString(String name) {
        if (!Strings.isValid((String)name)) {
            throw new OseeArgumentException("Name cannot be null or empty", new Object[0]);
        }
        String toMatch = name.toUpperCase();
        RelationSide[] relationSideArray = RelationSide.values();
        int n = relationSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            RelationSide side = relationSideArray[n2];
            if (side.name().equals(toMatch)) {
                return side;
            }
            ++n2;
        }
        throw new OseeCoreException("Invalid name - Relation Side was not found", new Object[0]);
    }

    public static RelationSide valueOf(String string) {
        return Enum.valueOf(RelationSide.class, string);
    }
}

