/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.ide.demo.internal.Activator;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class DemoDbUtil {
    public static String INTERFACE_INITIALIZATION = "Interface Initialization";
    public static String HAPTIC_CONSTRAINTS_REQ = "Haptic Constraints";

    public static Collection<Artifact> getSoftwareRequirements(boolean DEBUG, SoftwareRequirementStrs str, BranchId branch) {
        return DemoDbUtil.getArtTypeRequirements(DEBUG, CoreArtifactTypes.SoftwareRequirementMsWord, str.name(), branch);
    }

    public static Collection<Artifact> getArtTypeRequirements(boolean DEBUG, ArtifactTypeToken artifactType, String artifactNameStr, BranchId branch) {
        if (DEBUG) {
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)("Getting \"" + artifactNameStr + "\" requirement(s) from Branch " + branch.getIdString()));
        }
        List arts = ArtifactQuery.getArtifactListFromTypeAndName((ArtifactTypeId)artifactType, (String)artifactNameStr, (BranchId)branch, (QueryOption[])QueryOption.CONTAINS_MATCH_OPTIONS);
        if (DEBUG) {
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)("Found " + arts.size() + " Artifacts"));
        }
        return arts;
    }

    public static Artifact getInterfaceInitializationSoftwareRequirement(boolean DEBUG, BranchId branch) {
        if (DEBUG) {
            OseeLog.log(Activator.class, (Level)Level.INFO, (String)("Getting \"" + INTERFACE_INITIALIZATION + "\" requirement."));
        }
        return ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)CoreArtifactTypes.SoftwareRequirementMsWord, (String)INTERFACE_INITIALIZATION, (BranchId)branch);
    }

    public static Collection<IAtsActionableItem> getActionableItems(ArtifactToken ... aiTokens) {
        HashSet<IAtsActionableItem> aias = new HashSet<IAtsActionableItem>();
        ArtifactToken[] artifactTokenArray = aiTokens;
        int n = aiTokens.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactToken aiToken = artifactTokenArray[n2];
            aias.add((IAtsActionableItem)AtsApiService.get().getActionableItemService().getActionableItemById((ArtifactId)aiToken));
            ++n2;
        }
        return aias;
    }

    public static enum SoftwareRequirementStrs {
        Robot,
        CISST,
        daVinci,
        Functional,
        Event,
        Haptic;

    }
}

