/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.populate;

import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.config.JaxAtsObject;
import org.eclipse.osee.ats.api.country.CountryEndpointApi;
import org.eclipse.osee.ats.api.country.JaxCountry;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.demo.DemoCountry;
import org.eclipse.osee.ats.api.demo.DemoInsertion;
import org.eclipse.osee.ats.api.demo.DemoInsertionActivity;
import org.eclipse.osee.ats.api.demo.DemoProgram;
import org.eclipse.osee.ats.api.insertion.InsertionActivityEndpointApi;
import org.eclipse.osee.ats.api.insertion.InsertionEndpointApi;
import org.eclipse.osee.ats.api.insertion.JaxInsertion;
import org.eclipse.osee.ats.api.insertion.JaxInsertionActivity;
import org.eclipse.osee.ats.api.program.JaxProgram;
import org.eclipse.osee.ats.api.program.ProgramEndpointApi;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.demo.DemoUtil;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class Pdd95CreateDemoEVConfigAndWorkPackages {
    public void run() {
        this.createUsgCountryConfig();
        this.createCntryCountryConfig();
        this.createAndSetWorkPackages();
        this.setWorkPacakgeForWfs();
    }

    public void setWorkPacakgeForWfs() {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getClass().getSimpleName());
        TeamWorkFlowArtifact commWf = DemoUtil.getSawCodeCommittedWf();
        changes.setSoleAttributeValue((IAtsObject)commWf, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, (Object)DemoArtifactToken.SAW_Code_Team_WorkPackage_01);
        TeamWorkFlowArtifact unCommWf = DemoUtil.getSawCodeUnCommittedWf();
        changes.setSoleAttributeValue((IAtsObject)unCommWf, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, (Object)DemoArtifactToken.SAW_Code_Team_WorkPackage_01);
        TeamWorkFlowArtifact noBranchWf = DemoUtil.getSawCodeNoBranchWf();
        changes.setSoleAttributeValue((IAtsObject)noBranchWf, (AttributeTypeToken)AtsAttributeTypes.WorkPackageReference, (Object)DemoArtifactToken.SAW_Code_Team_WorkPackage_03);
        changes.execute();
    }

    private void createAndSetWorkPackages() {
        SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)"Create Work Packages");
        Artifact codeTeamArt = ArtifactQuery.getArtifactFromToken((ArtifactId)DemoArtifactToken.SAW_Code);
        Artifact workPkg1 = this.createWorkPackage(DemoArtifactToken.SAW_Code_Team_WorkPackage_01, "ASDHFA443");
        workPkg1.addRelation(AtsRelationTypes.TeamDefinitionToWorkPackage_AtsTeamDefOrAi, codeTeamArt);
        this.relateInsertionActivity(workPkg1, DemoInsertionActivity.commPage);
        workPkg1.persist(transaction);
        Artifact workPkg2 = this.createWorkPackage(DemoArtifactToken.SAW_Code_Team_WorkPackage_02, "ASDHFA443");
        workPkg2.addRelation(AtsRelationTypes.TeamDefinitionToWorkPackage_AtsTeamDefOrAi, codeTeamArt);
        this.relateInsertionActivity(workPkg2, DemoInsertionActivity.commPage);
        workPkg2.persist(transaction);
        Artifact workPkg3 = this.createWorkPackage(DemoArtifactToken.SAW_Code_Team_WorkPackage_03, "ASDHFA443");
        workPkg3.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, (Object)false);
        workPkg3.addRelation(AtsRelationTypes.TeamDefinitionToWorkPackage_AtsTeamDefOrAi, codeTeamArt);
        this.relateInsertionActivity(workPkg3, DemoInsertionActivity.commButton);
        workPkg3.persist(transaction);
        Artifact testTeamArt = ArtifactQuery.getArtifactFromToken((ArtifactId)DemoArtifactToken.SAW_Test_AI);
        Artifact workPkg11 = this.createWorkPackage(DemoArtifactToken.SAW_Test_AI_WorkPackage_0A, "AHESSH3");
        workPkg11.addRelation(AtsRelationTypes.TeamDefinitionToWorkPackage_AtsTeamDefOrAi, testTeamArt);
        this.relateInsertionActivity(workPkg11, DemoInsertionActivity.commPage);
        workPkg11.persist(transaction);
        Artifact workPkg21 = this.createWorkPackage(DemoArtifactToken.SAW_Test_AI_WorkPackage_0B, "HAKSHD3");
        workPkg21.addRelation(AtsRelationTypes.TeamDefinitionToWorkPackage_AtsTeamDefOrAi, testTeamArt);
        this.relateInsertionActivity(workPkg21, DemoInsertionActivity.commPage);
        workPkg21.persist(transaction);
        Artifact workPkg31 = this.createWorkPackage(DemoArtifactToken.SAW_Test_AI_WorkPackage_0C, "EHA4DS");
        workPkg31.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Active, (Object)false);
        workPkg31.addRelation(AtsRelationTypes.TeamDefinitionToWorkPackage_AtsTeamDefOrAi, testTeamArt);
        this.relateInsertionActivity(workPkg31, DemoInsertionActivity.commButton);
        workPkg31.persist(transaction);
        transaction.execute();
    }

    private void relateInsertionActivity(Artifact workPackageArt, DemoInsertionActivity insertionActivity) {
        Artifact insertionActivityArt = AtsApiService.get().getQueryServiceIde().getArtifact((Object)insertionActivity.getId());
        insertionActivityArt.addRelation(AtsRelationTypes.InsertionActivityToWorkPackage_WorkPackage, workPackageArt);
    }

    private Artifact createWorkPackage(ArtifactToken workPackageToken, String activityId) {
        Artifact workPkg1 = ArtifactTypeManager.addArtifact((ArtifactToken)workPackageToken, (BranchToken)AtsApiService.get().getAtsBranch());
        char charAt = workPackageToken.getName().charAt(workPackageToken.getName().length() - 1);
        workPkg1.addAttributeFromString((AttributeTypeId)AtsAttributeTypes.WorkPackageId, "WP_0" + charAt);
        workPkg1.addAttributeFromString((AttributeTypeId)AtsAttributeTypes.WorkPackageProgram, "Program A");
        workPkg1.addAttributeFromString((AttributeTypeId)AtsAttributeTypes.WorkPackageType, "LOE");
        workPkg1.addAttributeFromString((AttributeTypeId)AtsAttributeTypes.ActivityId, activityId);
        workPkg1.addAttributeFromString((AttributeTypeId)AtsAttributeTypes.ActivityName, "HUF 2" + charAt + "0");
        return workPkg1;
    }

    private void createUsgCountryConfig() {
        try {
            CountryEndpointApi countryEp = AtsApiService.get().getServerEndpoints().getCountryEp();
            InsertionEndpointApi insertionEp = AtsApiService.get().getServerEndpoints().getInsertionEp();
            InsertionActivityEndpointApi insertionActivityEp = AtsApiService.get().getServerEndpoints().getInsertionActivityEp();
            this.createCountry(countryEp, DemoCountry.usg);
            SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)"Create USG Country Config");
            Artifact country = ArtifactQuery.getArtifactFromId((long)DemoCountry.usg.getId(), (BranchId)AtsApiService.get().getAtsBranch());
            Artifact program = ArtifactQuery.getArtifactFromId((long)DemoProgram.sawProgram.getId(), (BranchId)AtsApiService.get().getAtsBranch());
            country.addRelation(AtsRelationTypes.CountryToProgram_Program, program);
            program.persist(transaction);
            program = ArtifactQuery.getArtifactFromId((long)DemoProgram.cisProgram.getId(), (BranchId)AtsApiService.get().getAtsBranch());
            country.addRelation(AtsRelationTypes.CountryToProgram_Program, program);
            program.persist(transaction);
            country.persist(transaction);
            transaction.execute();
            DemoInsertion.getInsertions();
            DemoInsertionActivity.getActivities();
            for (DemoProgram demoProg : DemoCountry.usg.getPrograms()) {
                this.createInsertions(insertionEp, insertionActivityEp, demoProg);
            }
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private void createCntryCountryConfig() {
        try {
            DemoCountry country = DemoCountry.cntry;
            CountryEndpointApi countryEp = AtsApiService.get().getServerEndpoints().getCountryEp();
            ProgramEndpointApi programEp = AtsApiService.get().getServerEndpoints().getProgramEp();
            InsertionEndpointApi insertionEp = AtsApiService.get().getServerEndpoints().getInsertionEp();
            InsertionActivityEndpointApi insertionActivityEp = AtsApiService.get().getServerEndpoints().getInsertionActivityEp();
            this.createCountry(countryEp, country);
            DemoInsertion.getInsertions();
            DemoInsertionActivity.getActivities();
            for (DemoProgram program : country.getPrograms()) {
                this.createProgram(programEp, program);
                this.createInsertions(insertionEp, insertionActivityEp, program);
            }
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private void createInsertions(InsertionEndpointApi insertionEp, InsertionActivityEndpointApi insertionActivityEp, DemoProgram demoProg) throws Exception {
        for (DemoInsertion demoIns : demoProg.getInsertions()) {
            this.createInsertion(insertionEp, demoIns);
            for (DemoInsertionActivity demoInsertionActivity : demoIns.getActivities()) {
                this.createInsertionActivity(insertionActivityEp, demoInsertionActivity);
            }
        }
    }

    private JaxInsertionActivity createInsertionActivity(InsertionActivityEndpointApi insertionActivityEp, DemoInsertionActivity insertionActivity) throws Exception {
        JaxInsertionActivity jaxInsertionActivity = new JaxInsertionActivity();
        jaxInsertionActivity.setName(insertionActivity.getName());
        jaxInsertionActivity.setId(insertionActivity.getId());
        jaxInsertionActivity.setActive(insertionActivity.isActive());
        jaxInsertionActivity.setDescription(insertionActivity.getDescription());
        jaxInsertionActivity.setInsertionId(insertionActivity.getInsertionId());
        insertionActivityEp.create((JaxAtsObject)jaxInsertionActivity);
        return jaxInsertionActivity;
    }

    private JaxInsertion createInsertion(InsertionEndpointApi insertionEp, DemoInsertion insertion) throws Exception {
        JaxInsertion jaxInsertion = new JaxInsertion();
        jaxInsertion.setName(insertion.getName());
        jaxInsertion.setId(insertion.getId());
        jaxInsertion.setActive(insertion.isActive());
        jaxInsertion.setDescription(insertion.getDescription());
        jaxInsertion.setProgramId(insertion.getProgramId());
        insertionEp.create((JaxAtsObject)jaxInsertion);
        return jaxInsertion;
    }

    private JaxProgram createProgram(ProgramEndpointApi programEp, DemoProgram program) throws Exception {
        JaxProgram jaxProgram = new JaxProgram();
        jaxProgram.setName(program.getName());
        jaxProgram.setId(program.getId());
        jaxProgram.setActive(program.isActive());
        jaxProgram.setDescription(program.getDescription());
        jaxProgram.setCountryId(program.getCountryId());
        programEp.create((JaxAtsObject)jaxProgram);
        return jaxProgram;
    }

    private JaxCountry createCountry(CountryEndpointApi countryEp, DemoCountry country) throws Exception {
        JaxCountry jaxCountry = new JaxCountry();
        jaxCountry.setName(country.getName());
        jaxCountry.setId(country.getId());
        jaxCountry.setActive(country.isActive());
        countryEp.create((JaxAtsObject)jaxCountry);
        return jaxCountry;
    }
}

