/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelSaxHandler;
import org.eclipse.osee.framework.jdk.core.util.io.xml.RowProcessor;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryBuilderArtifact;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DataRightsImporter
extends AbstractBlam {
    private Map<String, Artifact> nameToArtifact;

    public Collection<String> getCategories() {
        return Arrays.asList("Util");
    }

    public String getXWidgetsXml() {
        StringBuffer buffer = new StringBuffer("<xWidgets>");
        buffer.append("<XWidget xwidgetType=\"XBranchSelectWidget\" horizontalLabel=\"true\" displayName=\"Branch\" />");
        buffer.append("<XWidget xwidgetType=\"XFileSelectionDialog\" displayName=\"Path to DataRights XML\" />");
        buffer.append("</xWidgets>");
        return buffer.toString();
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        BranchId branch = variableMap.getBranch("Branch");
        String xmlPath = variableMap.getString("Path to DataRights XML");
        if (branch == null) {
            this.log(new String[]{String.format("A branch needs to be defined.", new Object[0])});
        } else if (!Strings.isValid((String)xmlPath)) {
            this.log(new String[]{String.format("A path needs to be defined.", new Object[0])});
        } else {
            this.log(new String[]{"path [" + xmlPath + "]"});
            if (this.nameToArtifact == null) {
                QueryBuilderArtifact builder = ArtifactQuery.createQueryBuilder((BranchId)branch);
                builder.andIsOfType(new ArtifactTypeId[]{CoreArtifactTypes.CodeUnit});
                ResultSet results = builder.getResults();
                this.nameToArtifact = new HashMap<String, Artifact>();
                for (Artifact artifact : results) {
                    this.nameToArtifact.put(artifact.getName(), artifact);
                }
            }
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            DataRightsProcessor processor = null;
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(xmlPath);
                processor = new DataRightsProcessor(branch);
                xmlReader.setContentHandler((ContentHandler)new ExcelSaxHandler((RowProcessor)processor, true));
                xmlReader.parse(new InputSource(inputStream));
            }
            catch (Throwable throwable) {
                Lib.close(inputStream);
                throw throwable;
            }
            Lib.close((AutoCloseable)inputStream);
            processor.persist();
        }
    }

    public String getName() {
        return "Data Rights Importer";
    }

    public String getDescriptionUsage() {
        return "This BLAM imports data rights attributes (SME, Classification and Basis) from a XML spreadsheet into existing Artifacts in ATS";
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }

    private final class DataRightsProcessor
    implements RowProcessor {
        private final BranchId branch;
        private boolean ignore;
        private int smeIndex;
        private int dataRightsIndex;
        private int fileNameIndex;
        private int dataRightsBasisIndex;
        private boolean changesAvailable;
        private SkynetTransaction transaction;

        public DataRightsProcessor(BranchId branch) {
            this.branch = branch;
        }

        private SkynetTransaction getTransaction() {
            if (this.transaction == null) {
                this.transaction = TransactionManager.createTransaction((BranchId)this.branch, (String)"Data Rights Importer");
                this.changesAvailable = true;
            }
            return this.transaction;
        }

        public void processRow(String[] row) throws Exception {
            if (!this.ignore) {
                String SME = row[this.smeIndex];
                String dataRightsClassification = row[this.dataRightsIndex];
                String fileName = row[this.fileNameIndex];
                String dataRightsBasis = row[this.dataRightsBasisIndex];
                if (!Strings.isValid((String)SME)) {
                    SME = "Unspecified";
                }
                if (!Strings.isValid((String)dataRightsClassification)) {
                    dataRightsClassification = "Unspecified";
                }
                if (!Strings.isValid((String)dataRightsBasis)) {
                    dataRightsBasis = "Unspecified";
                }
                try {
                    Artifact artifact = this.getArtifactByName(fileName);
                    if (artifact == null) {
                        DataRightsImporter.this.log(new String[]{"artifact [" + fileName + "] does not exist"});
                    } else {
                        artifact.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.DataRightsClassification, (Object)dataRightsClassification);
                        artifact.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.DataRightsBasis, (Object)dataRightsBasis);
                        artifact.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.SubjectMatterExpert, (Object)SME);
                        SkynetTransaction transaction = this.getTransaction();
                        artifact.persist(transaction);
                    }
                }
                catch (Exception ex) {
                    DataRightsImporter.this.log(new String[]{"dataRightsClassification [" + dataRightsClassification + "] does not exist"});
                    DataRightsImporter.this.log(new String[]{"dataRightsBasis [" + dataRightsBasis + "] does not exist"});
                    DataRightsImporter.this.log(new String[]{"SME [" + SME + "] does not exist"});
                    DataRightsImporter.this.log(new String[]{"artifact [" + fileName + "] does not exist"});
                    DataRightsImporter.this.log(ex);
                }
            }
        }

        public Artifact getArtifactByName(String name) {
            return (Artifact)DataRightsImporter.this.nameToArtifact.get(name);
        }

        public void processHeaderRow(String[] row) {
            int index = 0;
            while (index < row.length) {
                String header = row[index];
                if ("SME".equals(header)) {
                    this.smeIndex = index;
                } else if ("Classification".equals(header)) {
                    this.dataRightsIndex = index;
                } else if ("Virtual Path (formula)".equals(header)) {
                    this.fileNameIndex = index;
                } else if ("Basis".equals(header)) {
                    this.dataRightsBasisIndex = index;
                }
                ++index;
            }
        }

        public void reachedEndOfWorksheet() {
            this.ignore = true;
        }

        public void processEmptyRow() {
            this.ignore = true;
        }

        public void processCommentRow(String[] row) {
        }

        public void foundStartOfWorksheet(String sheetName) throws Exception {
        }

        public void detectedRowAndColumnCounts(int rowCount, int columnCount) {
        }

        public void persist() {
            if (this.changesAvailable) {
                this.getTransaction().execute();
            }
        }
    }
}

