/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.swt.program.Program;

public class FindMissingOrUnspecifiedAttributes
extends AbstractBlam {
    public String getName() {
        return "Find Artifacts with Unspecified Attributes";
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss");
        Date date = new Date();
        File file = OseeData.getFile((String)("UNSPECIFIED_" + dateFormat.format(date) + ".xml"));
        ExcelXmlWriter excelWriter = new ExcelXmlWriter(file);
        BranchId branch = variableMap.getBranch("Branch");
        AttributeTypeToken attributeType = variableMap.getAttributeType("Attribute Type");
        List artifacts = ArtifactQuery.getArtifactListFromAttribute((AttributeTypeId)attributeType, (String)"Unspecified", (BranchId)branch);
        excelWriter.startSheet("Attrs", 6);
        excelWriter.writeRow(new Object[]{"Artifact", "Artifact Type", "Subsystem", "Guid", "Attribute Type", "Attribute Value"});
        for (Artifact art : artifacts) {
            String subsystem = art.getSoleAttributeValueAsString((AttributeTypeToken)CoreAttributeTypes.Subsystem, "");
            excelWriter.writeRow(new Object[]{art.getName(), art.getArtifactType(), subsystem, art.getGuid(), attributeType, "Unspecified".toString()});
        }
        excelWriter.endSheet();
        excelWriter.endWorkbook();
        Program.launch((String)file.getAbsolutePath());
    }

    public String getXWidgetsXml() {
        return "<xWidgets><XWidget xwidgetType=\"XAttributeTypeMultiChoiceSelect\" displayName=\"Attribute Type\" /><XWidget xwidgetType=\"XBranchSelectWidget\" displayName=\"Branch\" /></xWidgets>";
    }

    public Collection<String> getCategories() {
        return Arrays.asList("Define.Publish.Check");
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }
}

