/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.osee.define.ide.blam.operation.FixAttributeOperation;
import org.eclipse.osee.define.ide.blam.operation.FixAttributesUIReport;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;

public class FixDuplicateEnumeratedAttributes
extends AbstractBlam {
    public static String SELECT_BRANCH_LABEL = "Select Branch";
    public static String COMMIT_CHANGES_LABEL = "Commit Changes to Branch?";

    public String getName() {
        return "Fix Duplicate Enumerated Attributes";
    }

    public String getXWidgetsXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<XWidgets>");
        builder.append("<XWidget xwidgetType=\"XBranchSelectWidget\" multiSelect=\"false\" displayName=\"");
        builder.append(SELECT_BRANCH_LABEL);
        builder.append("\" />");
        builder.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"");
        builder.append(COMMIT_CHANGES_LABEL);
        builder.append("\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        builder.append("</XWidgets>");
        return builder.toString();
    }

    public IOperation createOperation(VariableMap variableMap, OperationLogger logger) throws Exception {
        BranchId branch = variableMap.getBranch(SELECT_BRANCH_LABEL);
        boolean commitChangesBool = variableMap.getBoolean(COMMIT_CHANGES_LABEL);
        FixAttributesUIReport display = new FixAttributesUIReport();
        return new FixAttributeOperation(logger, display, BranchManager.getBranchToken((BranchId)branch), commitChangesBool);
    }

    public String getDescriptionUsage() {
        return "Remove duplciate enumerated attributes";
    }

    public Collection<String> getCategories() {
        return Arrays.asList("Admin");
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }
}

