/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.traceability.ScriptTraceabilityOperation;
import org.eclipse.osee.define.ide.traceability.TraceUnitExtensionManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.CharBackedInputStream;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.framework.plugin.core.util.AIFile;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.branch.ViewApplicabilityUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.skynet.widgets.XCombo;
import org.eclipse.osee.framework.ui.skynet.widgets.XListDropViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XModifiedListener;
import org.eclipse.osee.framework.ui.skynet.widgets.XText;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.util.SwtXWidgetRenderer;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SubsystemFullTraceReport
extends AbstractBlam {
    private static final String SUBSYSTEM_REQUIREMENTS = "Subsystem Requirements";
    private CharBackedInputStream charBak;
    private ISheetWriter writer;
    private HashCollectionSet<Artifact, String> requirementsToCodeUnits;
    private static int SOFTWARE_REQUIREMENT_INDEX = 9;
    private static int TEST_INDEX = 13;
    private final ArrayList<String> tests = new ArrayList(50);
    private final String SCRIPT_ROOT_DIR = "Script Root Directory";
    private final String USE_TRACE_IN_OSEE = "Use traceability from Subsystem Requirements";
    private final String USE_GIT_CODE_STRUCTURE = "Use Git Code Structure";
    private XCheckBox useTraceInOsee;
    private XText scriptDir;
    private static final String TRACE_HANDLER_CHECKBOX = "<XWidget xwidgetType=\"XCheckBox\" displayName=\"%s\" labelAfter=\"true\" horizontalLabel=\"true\"/>";
    private Collection<String> availableTraceHandlers;
    private XCombo branchViewWidget;
    private XListDropViewer subSystem;

    public String getName() {
        return "Subsystem Full Trace Report";
    }

    private void init() throws IOException {
        this.charBak = new CharBackedInputStream();
        this.writer = new ExcelXmlWriter(this.charBak.getWriter());
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        File dir;
        List artifacts = variableMap.getArtifacts(SUBSYSTEM_REQUIREMENTS);
        if (artifacts.isEmpty()) {
            throw new OseeArgumentException("must specify a set of artifacts", new Object[0]);
        }
        BranchToken branch = ((Artifact)artifacts.get(0)).getBranch();
        Object view = variableMap.getValue("Branch View");
        this.setViewId(view);
        this.init();
        String scriptDir = variableMap.getString("Script Root Directory");
        Boolean checked = variableMap.getBoolean("Use traceability from Subsystem Requirements");
        Boolean isGitCodeStructure = variableMap.getBoolean("Use Git Code Structure");
        LinkedList<TraceUnitExtensionManager.TraceHandler> traceHandlers = new LinkedList<TraceUnitExtensionManager.TraceHandler>();
        for (String handler : this.availableTraceHandlers) {
            if (!variableMap.getBoolean(handler)) continue;
            TraceUnitExtensionManager.TraceHandler traceHandler = TraceUnitExtensionManager.getInstance().getTraceHandlerByName(handler);
            traceHandlers.add(traceHandler);
        }
        if (!checked.booleanValue() && (dir = new File(scriptDir)).exists()) {
            ScriptTraceabilityOperation traceOperation = new ScriptTraceabilityOperation(dir.getParentFile(), (BranchId)branch, false, traceHandlers, isGitCodeStructure, (ArtifactId)this.viewId, false);
            Operations.executeWorkAndCheckStatus((IOperation)traceOperation, (IProgressMonitor)monitor);
            this.requirementsToCodeUnits = traceOperation.getRequirementToCodeUnitsMap();
        }
        this.writeMainSheet(this.prepareSubsystemRequirements(artifacts));
        this.writer.endWorkbook();
        IFile iFile = OseeData.getIFile((String)("Subsystem_Trace_Report_" + Lib.getDateTimeString() + ".xml"));
        AIFile.writeToFile((IFile)iFile, (InputStream)this.charBak);
        Program.launch((String)iFile.getLocation().toOSString());
    }

    private List<Artifact> prepareSubsystemRequirements(List<Artifact> artifacts) {
        ArrayList<Artifact> subsystemRequirements = new ArrayList<Artifact>(400);
        for (Artifact artifact : artifacts) {
            if (artifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.Folder})) {
                subsystemRequirements.addAll(artifact.getDescendants());
                continue;
            }
            subsystemRequirements.add(artifact);
        }
        return subsystemRequirements;
    }

    private void writeMainSheet(List<Artifact> artifacts) throws IOException {
        this.writer.startSheet("report", 18);
        this.writer.writeRow(new Object[]{CoreArtifactTypes.SystemRequirementMsWord.getName(), null, null, CoreArtifactTypes.SubsystemRequirementMsWord.getName(), null, null, null, null, null, CoreArtifactTypes.SoftwareRequirementMsWord.getName()});
        this.writer.writeRow(new Object[]{"Paragraph #", "Requirement Name", "Requirement Text", "Paragraph #", "Requirement Name", "Requirement Text", "Subsystem", CoreAttributeTypes.QualificationMethod.getName(), "Test Procedure", "Paragraph #", "Requirement Name", "Partitions", CoreAttributeTypes.QualificationMethod.getName(), "Test Script/Test Procedure"});
        for (Artifact subSystemRequirement : artifacts) {
            this.processSubSystemRequirement(subSystemRequirement);
        }
        this.writer.endSheet();
    }

    private void processSubSystemRequirement(Artifact subSystemRequirement) throws IOException {
        boolean topRowForSubsystemReq = true;
        for (Artifact systemRequirement : subSystemRequirement.getRelatedArtifacts(CoreRelationTypes.RequirementTrace_HigherLevelRequirement)) {
            this.writer.writeCell(systemRequirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)""));
            this.writer.writeCell((Object)systemRequirement.getName());
            this.writer.writeCell((Object)this.getRequirementText(systemRequirement));
            if (topRowForSubsystemReq) {
                this.writer.writeCell(subSystemRequirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)""));
                this.writer.writeCell((Object)subSystemRequirement.getName());
                this.writer.writeCell((Object)this.getRequirementText(subSystemRequirement));
                this.writer.writeCell(subSystemRequirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)""));
                this.writer.writeCell((Object)subSystemRequirement.getAttributesToStringSorted((AttributeTypeId)CoreAttributeTypes.QualificationMethod));
                this.writer.writeCell((Object)org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", (Iterable)subSystemRequirement.getRelatedArtifacts(CoreRelationTypes.Verification_Verifier)));
                topRowForSubsystemReq = false;
            }
            for (Artifact softwareRequirement : subSystemRequirement.getRelatedArtifacts(CoreRelationTypes.RequirementTrace_LowerLevelRequirement)) {
                this.processSoftwareRequirement(softwareRequirement);
            }
            this.writer.endRow();
        }
    }

    private String getRequirementText(Artifact req) {
        Attribute templateContent = req.getSoleAttribute((AttributeTypeId)CoreAttributeTypes.WordTemplateContent);
        String ret = templateContent.getDisplayableString();
        return StringUtils.trim((String)ret);
    }

    private void processSoftwareRequirement(Artifact softwareRequirement) throws IOException {
        this.writer.writeCell(softwareRequirement.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)""), SOFTWARE_REQUIREMENT_INDEX);
        this.writer.writeCell((Object)softwareRequirement.getName());
        this.writer.writeCell((Object)org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)",", (Iterable)softwareRequirement.getAttributesToStringList((AttributeTypeId)CoreAttributeTypes.Partition)));
        this.writer.writeCell((Object)softwareRequirement.getAttributesToStringSorted((AttributeTypeId)CoreAttributeTypes.QualificationMethod));
        this.tests.clear();
        for (Artifact testProcedure : softwareRequirement.getRelatedArtifacts(CoreRelationTypes.Validation_Validator)) {
            this.tests.add(testProcedure.getName());
        }
        Collection testScripts = null;
        if (this.requirementsToCodeUnits != null) {
            testScripts = this.requirementsToCodeUnits.getValues((Object)softwareRequirement);
        } else {
            List relatedArtifacts = softwareRequirement.getRelatedArtifacts(CoreRelationTypes.Verification_Verifier);
            testScripts = Artifacts.getNames((Collection)relatedArtifacts);
        }
        if (testScripts != null) {
            for (String testScript : testScripts) {
                this.tests.add(new File(testScript).getName());
            }
        }
        this.writer.writeCell((Object)org.eclipse.osee.framework.jdk.core.util.Collections.toString((String)", ", this.tests), TEST_INDEX);
        this.writer.endRow();
    }

    public String getXWidgetsXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xWidgets>");
        sb.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Use traceability from Subsystem Requirements\" defaultValue=\"true\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        sb.append("<XWidget xwidgetType=\"XCheckBox\" displayName=\"Use Git Code Structure\" defaultValue=\"true\" labelAfter=\"true\" horizontalLabel=\"true\" />");
        sb.append("<XWidget xwidgetType=\"XText\" displayName=\"Script Root Directory\" defaultValue=\"C:/UserData/workspaceScripts\" toolTip=\"Leave blank if test script traceability is not needed.\" />");
        this.availableTraceHandlers = new LinkedList<String>();
        sb.append("<XWidget xwidgetType=\"XLabel\" displayName=\"Select appropriate script parser (if script traceability needed):\" />");
        List<String> traceHandlerNames = TraceUnitExtensionManager.getInstance().getAllTraceHandlerNames();
        for (String handler : traceHandlerNames) {
            sb.append(String.format(TRACE_HANDLER_CHECKBOX, handler));
            this.availableTraceHandlers.add(handler);
        }
        sb.append("<XWidget xwidgetType=\"XListDropViewer\" displayName=\"Subsystem Requirements\" />");
        sb.append("<XWidget xwidgetType=\"XCombo()\" displayName=\"Branch View\" horizontalLabel=\"true\"/>");
        sb.append("</xWidgets>");
        return sb.toString();
    }

    public String getDescriptionUsage() {
        return "Generates subsystem requirement full traceability report";
    }

    public Collection<String> getCategories() {
        return Arrays.asList("Define.Trace");
    }

    public void widgetCreated(XWidget widget, FormToolkit toolkit, Artifact art, SwtXWidgetRenderer dynamicXWidgetLayout, XModifiedListener modListener, boolean isEditable) {
        super.widgetCreated(widget, toolkit, art, dynamicXWidgetLayout, modListener, isEditable);
        if (widget.getLabel().equals("Script Root Directory")) {
            this.scriptDir = (XText)widget;
            this.scriptDir.setEnabled(false);
            this.scriptDir.getControl().setBackground(Displays.getSystemColor((int)15));
        }
        if (widget.getLabel().equals("Use traceability from Subsystem Requirements")) {
            this.useTraceInOsee = (XCheckBox)widget;
            this.useTraceInOsee.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (SubsystemFullTraceReport.this.useTraceInOsee.isChecked()) {
                        SubsystemFullTraceReport.this.scriptDir.setEnabled(false);
                        SubsystemFullTraceReport.this.scriptDir.getControl().setBackground(Displays.getSystemColor((int)15));
                    } else {
                        SubsystemFullTraceReport.this.scriptDir.setEnabled(true);
                        SubsystemFullTraceReport.this.scriptDir.getControl().setBackground(Displays.getSystemColor((int)1));
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        if (widget.getLabel().equals(SUBSYSTEM_REQUIREMENTS)) {
            this.subSystem = (XListDropViewer)widget;
            this.subSystem.addXModifiedListener(new XModifiedListener(){

                public void widgetModified(XWidget widget) {
                    if (SubsystemFullTraceReport.this.branchViewWidget != null) {
                        BranchToken branch;
                        SubsystemFullTraceReport.this.branchViewWidget.setEditable(true);
                        List arts = SubsystemFullTraceReport.this.subSystem.getArtifacts();
                        if (arts != null && !arts.isEmpty() && (branch = ((Artifact)arts.iterator().next()).getBranch()) != null && branch.isValid()) {
                            SubsystemFullTraceReport.this.branchViews = ViewApplicabilityUtil.getBranchViews((BranchId)ViewApplicabilityUtil.getParentBranch((BranchId)branch));
                            SubsystemFullTraceReport.this.branchViewWidget.setDataStrings(SubsystemFullTraceReport.this.branchViews.values());
                        }
                    }
                }
            });
        }
        if (widget.getLabel().equals("Branch View")) {
            this.branchViewWidget = (XCombo)widget;
            this.branchViewWidget.setEditable(false);
        }
    }

    public Collection<IUserGroupArtifactToken> getUserGroups() {
        return Collections.singleton(CoreUserGroups.Everyone);
    }
}

