/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.TraceabilityProviderOperation;
import org.eclipse.osee.define.ide.traceability.data.RequirementData;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.utility.ViewIdUtility;

public class RequirementTraceabilityData {
    private final BranchId testProcedureBranch;
    private final TraceabilityProviderOperation traceabilityProvider;
    private RequirementData requirementData;
    private HashCollectionSet<Artifact, String> requirementsToCodeUnits;
    private final HashCollectionSet<String, Artifact> requirementNameToTestProcedures = new HashCollectionSet(HashSet::new);
    private final Set<String> codeUnits = new TreeSet<String>();
    private final Map<String, Artifact> testProcedures = new HashMap<String, Artifact>();
    private File testProcedureFilter;
    private final ArtifactId viewId;
    private Set<ArtifactId> excludedArtifactIdMap = new HashSet<ArtifactId>();

    public RequirementTraceabilityData(BranchId testProcedureBranch, TraceabilityProviderOperation traceabilityProvider, ArtifactId viewId) {
        this.testProcedureBranch = testProcedureBranch;
        this.traceabilityProvider = traceabilityProvider;
        this.testProcedureFilter = null;
        this.viewId = viewId;
        this.reset();
    }

    private void reset() {
        this.codeUnits.clear();
        this.testProcedures.clear();
        this.requirementsToCodeUnits = null;
        this.requirementData = null;
        this.requirementsToCodeUnits = null;
    }

    public IStatus initialize(IProgressMonitor monitor) {
        IStatus status = Status.CANCEL_STATUS;
        try {
            this.reset();
            monitor.subTask("Loading traceability data...");
            status = Operations.executeWork((IOperation)this.traceabilityProvider, (IProgressMonitor)monitor);
            this.requirementData = this.traceabilityProvider.getRequirementData();
            this.requirementsToCodeUnits = this.traceabilityProvider.getRequirementToCodeUnitsMap();
            this.codeUnits.addAll(this.traceabilityProvider.getCodeUnits());
            this.excludedArtifactIdMap = ViewIdUtility.findExcludedArtifactsByView((ArtifactId)this.viewId, (BranchId)this.testProcedureBranch);
            if (!monitor.isCanceled()) {
                if (status.getSeverity() == 0) {
                    this.getTestProcedureTraceability(this.testProcedureBranch);
                }
            } else {
                status = Status.CANCEL_STATUS;
            }
        }
        catch (Exception ex) {
            status = new Status(4, "org.eclipse.osee.define.ide", "Error gathering traceability data", (Throwable)ex);
        }
        return status;
    }

    private void getTestProcedureTraceability(BranchId testProcedureBranch) {
        HashMap<String, Artifact> testProcedureBranchReqsToReqsBranchMap = new HashMap<String, Artifact>();
        List artifacts = ArtifactQuery.getArtifactListFromType((ArtifactTypeToken)CoreArtifactTypes.SoftwareRequirementMsWord, (BranchId)testProcedureBranch);
        if (artifacts != null) {
            ViewIdUtility.removeExcludedArtifacts(artifacts.iterator(), this.excludedArtifactIdMap);
            for (Artifact tpRequirement : artifacts) {
                testProcedureBranchReqsToReqsBranchMap.put(tpRequirement.getName(), tpRequirement);
            }
        }
        Set<String> testProceduresFilter = this.getAllowedTestProcedures();
        for (Map.Entry entry : testProcedureBranchReqsToReqsBranchMap.entrySet()) {
            Artifact requirement = (Artifact)entry.getValue();
            HashSet foundProcedures = new HashSet(requirement.getRelatedArtifacts(CoreRelationTypes.Validation_Validator));
            ViewIdUtility.removeExcludedArtifacts(foundProcedures.iterator(), this.excludedArtifactIdMap);
            HashSet<Artifact> toAdd = new HashSet<Artifact>();
            if (!testProceduresFilter.isEmpty()) {
                for (Artifact artifact : foundProcedures) {
                    if (!testProceduresFilter.contains(artifact.getName())) continue;
                    toAdd.add(artifact);
                }
            } else {
                toAdd = foundProcedures;
            }
            this.requirementNameToTestProcedures.put((Object)((String)entry.getKey()), toAdd);
            for (Artifact artifact : toAdd) {
                this.testProcedures.put(artifact.getName(), artifact);
            }
        }
    }

    public Collection<Artifact> getDirectSwRequirements() {
        return this.requirementData.getDirectRequirements();
    }

    public Collection<Artifact> getAllSwRequirements() {
        return this.requirementData.getAllRequirements();
    }

    public Artifact getRequirementFromTraceMark(String traceMark) {
        return this.requirementData.getRequirementFromTraceMarkIncludeStructuredRequirements(traceMark);
    }

    public Artifact getRequirementFromArtifactId(ArtifactId artId) {
        return this.requirementData.getRequirementFromArtifactId(artId);
    }

    public HashCollectionSet<Artifact, String> getRequirementsToCodeUnits() {
        return this.requirementsToCodeUnits;
    }

    public Set<String> getCodeUnits() {
        return this.codeUnits;
    }

    public Set<String> getTestProcedures() {
        return this.testProcedures.keySet();
    }

    public Collection<Artifact> getTestScriptsForRequirement(Artifact artifact) {
        return this.traceabilityProvider.getTestUnitArtifacts(artifact);
    }

    public Artifact getTestProcedureByName(String name) {
        return this.testProcedures.get(name);
    }

    public Artifact getTestScriptByName(String name) {
        return this.traceabilityProvider.getTestUnitByName(name);
    }

    public void setTestProcedureFilterFile(File filter) {
        this.testProcedureFilter = filter;
    }

    private File getTestProcedureFilterFile() {
        return this.testProcedureFilter;
    }

    private Set<String> getAllowedTestProcedures() {
        HashSet<String> toReturn;
        block14: {
            toReturn = new HashSet<String>();
            File filter = this.getTestProcedureFilterFile();
            if (filter != null && filter.exists() && filter.canRead()) {
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new InputStreamReader(new FileInputStream(filter)));
                        String line = "";
                        while ((line = reader.readLine()) != null) {
                            toReturn.add(line.trim());
                        }
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                        if (reader == null) break block14;
                        try {
                            reader.close();
                        }
                        catch (IOException ex2) {
                            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex2);
                        }
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex) {
                            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                        }
                    }
                }
            }
        }
        return toReturn;
    }
}

