/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.RelationalConstants;
import org.eclipse.osee.framework.core.enums.DirtyState;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.orcs.core.ds.OrcsData;
import org.eclipse.osee.orcs.core.ds.VersionData;

public abstract class OrcsVersionedObjectImpl<T extends Id>
implements OrcsData<T> {
    private Integer localId = Id.SENTINEL.intValue();
    private T type;
    private T baseType;
    private ModificationType baseModType = RelationalConstants.DEFAULT_MODIFICATION_TYPE;
    private ModificationType previousModType = RelationalConstants.DEFAULT_MODIFICATION_TYPE;
    private ModificationType currentModType = RelationalConstants.DEFAULT_MODIFICATION_TYPE;
    private final VersionData version;
    private ApplicabilityId applicId;
    private boolean applicDirty;
    private DirtyState dirtyState = DirtyState.CLEAN;

    protected OrcsVersionedObjectImpl(VersionData version) {
        this.version = version;
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public void setType(T type) {
        this.type = type;
    }

    @Override
    public T getBaseType() {
        return this.baseType;
    }

    @Override
    public void setBaseType(T baseType) {
        this.baseType = baseType;
    }

    @Override
    public void setBaseModType(ModificationType modType) {
        this.baseModType = modType;
    }

    @Override
    public ModificationType getModType() {
        return this.currentModType;
    }

    @Override
    public void setModType(ModificationType modType) {
        this.previousModType = this.currentModType;
        this.currentModType = modType;
    }

    @Override
    public ModificationType getPreviousModType() {
        return this.previousModType;
    }

    @Override
    public ModificationType getBaseModType() {
        return this.baseModType;
    }

    @Override
    public boolean hasTypeUuidChange() {
        return this.type.notEqual(this.baseType);
    }

    @Override
    public boolean hasModTypeChange() {
        return this.getBaseModType() != this.getModType();
    }

    @Override
    public VersionData getVersion() {
        return this.version;
    }

    @Override
    public void setApplicabilityId(ApplicabilityId applicId) {
        if (this.applicId != null && this.applicId.notEqual((Id)applicId) && !this.dirtyState.isDirty()) {
            this.applicDirty = true;
            this.dirtyState = DirtyState.APPLICABILITY_ONLY;
        }
        this.applicId = applicId;
    }

    @Override
    public ApplicabilityId getApplicabilityId() {
        return this.applicId;
    }

    @Override
    public DirtyState getDirtyState() {
        return this.dirtyState;
    }

    @Override
    public boolean isDirty() {
        return this.dirtyState.isDirty();
    }

    @Override
    public DirtyState calculateDirtyState(boolean dirty) {
        if (!dirty) {
            this.dirtyState = this.applicDirty ? DirtyState.APPLICABILITY_ONLY : DirtyState.CLEAN;
        } else if (dirty) {
            this.dirtyState = DirtyState.OTHER_CHANGES;
            return this.dirtyState;
        }
        return this.dirtyState;
    }

    public int hashCode() {
        return this.getLocalId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OrcsVersionedObjectImpl) {
            OrcsVersionedObjectImpl other = (OrcsVersionedObjectImpl)obj;
            if (!this.getLocalId().equals(other.getLocalId())) {
                return false;
            }
            if (this.baseModType != other.baseModType) {
                return false;
            }
            if (this.baseType.notEqual(other.baseType)) {
                return false;
            }
            return this.version != null;
        }
        if (obj instanceof Id) {
            return ((Id)obj).getId().equals(this.getLocalId().longValue());
        }
        return false;
    }

    public String toString() {
        return "OrcsVersionedObject [" + super.toString() + ", type=" + this.type + ", baseType=" + this.baseType + ", modType=" + this.currentModType + ", previousModType=" + this.previousModType + ", baseModType=" + this.baseModType + ", version=" + this.version + "]";
    }

    @Override
    public Integer getLocalId() {
        return this.localId;
    }

    @Override
    public void setLocalId(Integer localId) {
        this.localId = localId;
    }
}

