/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.applicability;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.FileTypeApplicabilityData;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.orcs.core.internal.applicability.BatFileProcessor;
import org.eclipse.osee.orcs.core.internal.applicability.BlockApplicabilityOps;

public class BatStagingCreator {
    private final BlockApplicabilityOps orcsApplicability;
    private final Map<String, FileTypeApplicabilityData> fileTypeApplicabilityDataMap;
    private final Pattern validFileExtensions;
    private final boolean commentNonApplicableBlocks;

    public BatStagingCreator(BlockApplicabilityOps orcsApplicability, Map<String, FileTypeApplicabilityData> fileTypeApplicabilityData, Pattern validFileExtensions, boolean commentNonApplicableBlocks) {
        this.orcsApplicability = orcsApplicability;
        this.fileTypeApplicabilityDataMap = fileTypeApplicabilityData;
        this.validFileExtensions = validFileExtensions;
        this.commentNonApplicableBlocks = commentNonApplicableBlocks;
    }

    public File processDirectory(XResultData results, File inFile, File stageFileParent, Set<String> filesToExclude) {
        boolean isDirectory;
        if (results.isErrors()) {
            return null;
        }
        HashSet<String> excludedFiles = new HashSet<String>();
        excludedFiles.addAll(filesToExclude);
        String inFileName = inFile.getName();
        if (!(excludedFiles.contains(inFileName) || (isDirectory = inFile.isDirectory()) && inFileName.startsWith("."))) {
            File stageFile = new File(stageFileParent, inFileName);
            if (isDirectory) {
                if (!stageFile.exists() && !stageFile.mkdir()) {
                    results.warningf("Unable to create stage directory for %s\n", new Object[]{inFile.getPath()});
                    return null;
                }
                ArrayList<File> children = new ArrayList<File>();
                children.addAll(Arrays.asList(inFile.listFiles()));
                ConcurrentSkipListSet<File> stagedChildren = new ConcurrentSkipListSet<File>();
                stagedChildren.addAll(Arrays.asList(stageFile.listFiles()));
                Set<String> filesInConfig = this.processConfig(results, children, stageFile);
                excludedFiles.addAll(filesInConfig);
                ExecutorService executor = Executors.newFixedThreadPool(2);
                for (File child : children) {
                    Runnable task = () -> {
                        File stagedFile = this.processDirectory(results, child, stageFile, excludedFiles);
                        if (stagedFile != null) {
                            stagedChildren.remove(stagedFile);
                        }
                    };
                    executor.execute(task);
                }
                executor.shutdown();
                try {
                    executor.awaitTermination(3600L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    results.warningf("A thread was interrupted while processing a subdirectory of %s\n", new Object[]{inFile.getPath()});
                }
                for (File fileToRemove : stagedChildren) {
                    try {
                        Files.walk(fileToRemove.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                    }
                    catch (IOException iOException) {
                        results.warningf("An exception occured while cleaning up unstaged files under %s\n", new Object[]{inFile.getPath()});
                    }
                }
                if (!excludedFiles.isEmpty()) {
                    this.orcsApplicability.addFileApplicabilityEntry(stageFile.getPath(), excludedFiles);
                }
            } else {
                try {
                    boolean isNew;
                    boolean tagProcessed = false;
                    File outFile = new File(stageFile.toPath() + ".tmp");
                    if (this.validFileExtensions.matcher(inFileName).matches()) {
                        FileTypeApplicabilityData fileTypeApplicabilityData = this.fileTypeApplicabilityDataMap.get(Lib.getExtension((String)inFile.getName()).toLowerCase());
                        try {
                            tagProcessed = new BatFileProcessor(this.orcsApplicability, fileTypeApplicabilityData, false, this.commentNonApplicableBlocks).processFile(inFile, outFile);
                        }
                        catch (Exception ex) {
                            results.warningf("Exception %s with file %s\n", new Object[]{ex.toString(), inFile.getPath()});
                        }
                    }
                    if (isNew = this.isStageFileNew(stageFile, outFile)) {
                        if (!tagProcessed) {
                            Files.createLink(stageFile.toPath(), inFile.toPath());
                        } else {
                            stageFile.delete();
                            outFile.setReadOnly();
                            com.google.common.io.Files.move((File)outFile, (File)stageFile);
                        }
                    }
                    if (outFile.exists()) {
                        outFile.delete();
                    }
                }
                catch (Exception ex) {
                    results.warningf("Exception %s with file %s\n", new Object[]{ex.toString(), inFile.getPath()});
                }
            }
            return stageFile;
        }
        return null;
    }

    private boolean isStageFileNew(File stageFile, File outFile) throws IOException {
        String outLine;
        String stageLine;
        if (!stageFile.exists()) {
            return true;
        }
        if (!outFile.exists()) {
            return false;
        }
        if (stageFile.length() != outFile.length()) {
            return true;
        }
        boolean isFileNew = false;
        BufferedReader stageReader = Files.newBufferedReader(stageFile.toPath());
        BufferedReader outReader = Files.newBufferedReader(outFile.toPath());
        while ((stageLine = stageReader.readLine()) != null && (outLine = outReader.readLine()) != null) {
            if (stageLine.equals(outLine) || stageFile.length() == outFile.length()) continue;
            isFileNew = true;
        }
        stageReader.close();
        outReader.close();
        return isFileNew;
    }

    private Set<String> processConfig(XResultData results, List<File> children, File stageFile) {
        HashSet<String> filesToExclude = new HashSet<String>();
        File configFile = null;
        for (File child : children) {
            String fileName = child.getName();
            if (!fileName.equals(".fileApplicability")) continue;
            configFile = child;
            FileTypeApplicabilityData fileTypeApplicabilityData = this.fileTypeApplicabilityDataMap.get(Lib.getExtension((String)configFile.getName()).toLowerCase());
            Pattern tagPattern = fileTypeApplicabilityData.getCommentedTagPattern();
            try {
                String readLine;
                BufferedReader reader = new BufferedReader(new FileReader(configFile));
                while ((readLine = reader.readLine()) != null) {
                    if (tagPattern.matcher(readLine).matches() || readLine.isEmpty()) continue;
                    filesToExclude.add(readLine);
                }
                reader.close();
                File stagedConfig = new File(stageFile, configFile.getName());
                new BatFileProcessor(this.orcsApplicability, fileTypeApplicabilityData, true, this.commentNonApplicableBlocks).processFile(configFile, stagedConfig);
                reader = new BufferedReader(new FileReader(stagedConfig));
                while ((readLine = reader.readLine()) != null) {
                    if (tagPattern.matcher(readLine).matches() || readLine.isEmpty()) continue;
                    filesToExclude.remove(readLine);
                }
                reader.close();
                stagedConfig.delete();
                break;
            }
            catch (Exception ex) {
                results.warningf("Exception %s with file %s\n", new Object[]{ex.toString(), configFile.getPath()});
                return new HashSet<String>();
            }
        }
        children.remove(configFile);
        return filesToExclude;
    }
}

