/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.relation.sorter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.SortOrder;
import org.eclipse.osee.orcs.core.internal.relation.sorter.LexicographicalSorter;
import org.eclipse.osee.orcs.core.internal.relation.sorter.Sorter;
import org.eclipse.osee.orcs.core.internal.relation.sorter.UnorderedSorter;
import org.eclipse.osee.orcs.core.internal.relation.sorter.UserDefinedSorter;

public class SorterProvider {
    private final Map<RelationSorter, Sorter> orderMap = new HashMap<RelationSorter, Sorter>();

    public SorterProvider() {
        this.registerOrderType(new LexicographicalSorter(SortOrder.ASCENDING));
        this.registerOrderType(new LexicographicalSorter(SortOrder.DESCENDING));
        this.registerOrderType(new UnorderedSorter());
        this.registerOrderType(new UserDefinedSorter());
    }

    private void registerOrderType(Sorter order) {
        this.orderMap.put(order.getId(), order);
    }

    public RelationSorter getDefaultSorterId(RelationTypeToken relationType) {
        Conditions.checkNotNull((Object)relationType, (String)"type");
        return relationType.getOrder();
    }

    public boolean exists(RelationSorter sorterId) {
        Conditions.checkNotNull((Object)sorterId, (String)"sorterId");
        return this.orderMap.containsKey(sorterId);
    }

    public Sorter getSorter(RelationSorter sorterId) {
        if (sorterId.equals((Object)RelationSorter.PREEXISTING)) {
            throw new OseeArgumentException("No sorted is defined for preexisting (nor should there be).", new Object[0]);
        }
        Sorter sorter = this.orderMap.get(sorterId);
        Conditions.checkNotNull((Object)sorter, (String)"sorter", (String)"Unable to locate sorter with sorterId %s", (Object[])new Object[]{sorterId});
        return sorter;
    }
}

