/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileService;
import org.eclipse.osee.ats.api.ai.IAtsActionableItemService;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.task.related.IAtsTaskRelatedService;
import org.eclipse.osee.ats.api.util.IAtsDatabaseConversion;
import org.eclipse.osee.ats.api.util.IAtsHealthService;
import org.eclipse.osee.ats.api.util.IAtsServerEndpointProvider;
import org.eclipse.osee.ats.api.workflow.AtsActionEndpointApi;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.core.agile.AgileService;
import org.eclipse.osee.ats.core.ai.ActionableItemServiceImpl;
import org.eclipse.osee.ats.core.util.AtsApiImpl;
import org.eclipse.osee.ats.rest.AtsApiServer;
import org.eclipse.osee.ats.rest.internal.branch.AtsBranchServiceImpl;
import org.eclipse.osee.ats.rest.internal.config.AtsConfigurationsService;
import org.eclipse.osee.ats.rest.internal.config.ConvertWorkDefinitionsToJava;
import org.eclipse.osee.ats.rest.internal.convert.ConvertBaselineGuidToBaselineId;
import org.eclipse.osee.ats.rest.internal.convert.ConvertFavoriteBranchGuidToId;
import org.eclipse.osee.ats.rest.internal.health.AtsHealthServiceImpl;
import org.eclipse.osee.ats.rest.internal.notify.AtsNotificationServiceImpl;
import org.eclipse.osee.ats.rest.internal.query.AtsQueryServiceImpl;
import org.eclipse.osee.ats.rest.internal.util.ArtifactResolverImpl;
import org.eclipse.osee.ats.rest.internal.util.AtsAttributeResolverServiceImpl;
import org.eclipse.osee.ats.rest.internal.util.AtsEarnedValueImpl;
import org.eclipse.osee.ats.rest.internal.util.AtsRelationResolverServiceImpl;
import org.eclipse.osee.ats.rest.internal.util.AtsStoreServiceImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsActionEndpointImpl;
import org.eclipse.osee.ats.rest.internal.workitem.AtsTaskService;
import org.eclipse.osee.framework.core.access.IAccessControlService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.orcs.OrcsApi;

public class AtsApiServerImpl
extends AtsApiImpl
implements AtsApiServer {
    public static String PLUGIN_ID = "org.eclipse.osee.ats.rest";
    private OrcsApi orcsApi;
    private IAgileService agileService;
    private final Map<String, IAtsDatabaseConversion> externalConversions = new ConcurrentHashMap<String, IAtsDatabaseConversion>();
    private AtsActionEndpointApi actionEndpoint;
    private IAtsHealthService healthService;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    @Override
    public void addAtsDatabaseConversion(IAtsDatabaseConversion conversion) {
        this.externalConversions.put(conversion.getName(), conversion);
    }

    public void removeAtsDatabaseConversion(IAtsDatabaseConversion conversion) {
        this.externalConversions.remove(conversion.getName());
    }

    public void start() {
        this.configurationsService = new AtsConfigurationsService(this, this.orcsApi);
        this.attributeResolverService = new AtsAttributeResolverServiceImpl(this);
        super.start();
        this.notificationService = new AtsNotificationServiceImpl(this);
        this.artifactResolver = new ArtifactResolverImpl(this);
        this.branchService = new AtsBranchServiceImpl(this, this.orcsApi, (ITeamWorkflowProvidersLazy)this.teamWorkflowProvidersLazy);
        this.relationResolver = new AtsRelationResolverServiceImpl(this);
        this.storeService = new AtsStoreServiceImpl(this, this.orcsApi, this.stateFactory, this.logFactory);
        this.queryService = new AtsQueryServiceImpl(this, this.jdbcService, this.orcsApi);
        this.actionableItemManager = new ActionableItemServiceImpl(this.attributeResolverService, (AtsApi)this);
        this.agileService = new AgileService(this.logger, (AtsApi)this);
        this.taskService = new AtsTaskService(this);
        this.earnedValueService = new AtsEarnedValueImpl(this.logger, this);
        this.addAtsDatabaseConversion(new ConvertBaselineGuidToBaselineId(this.logger, this.jdbcService.getClient(), this.orcsApi, this));
        this.addAtsDatabaseConversion(new ConvertFavoriteBranchGuidToId(this.logger, this.jdbcService.getClient(), this.orcsApi, this));
        this.addAtsDatabaseConversion(new ConvertWorkDefinitionsToJava());
        this.loadAtsConfigCache();
        this.logger.info("ATS Application started", new Object[0]);
    }

    private void loadAtsConfigCache() {
        Thread loadCache = new Thread("Load ATS Config Cache"){

            @Override
            public void run() {
                super.run();
                AtsApiServerImpl.this.getConfigService().getConfigurationsWithPend();
            }
        };
        loadCache.start();
    }

    public void stop() {
        super.stop();
    }

    @Override
    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    @Override
    public Iterable<IAtsDatabaseConversion> getDatabaseConversions() {
        return this.externalConversions.values();
    }

    public String getConfigValue(String key) {
        String result = null;
        ArtifactToken atsConfig = this.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.AtsConfig);
        if (atsConfig != null) {
            List attributeValues = this.getAttributeResolver().getAttributesToStringList((ArtifactId)atsConfig, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData);
            for (String str : attributeValues) {
                if (!str.startsWith(key)) continue;
                result = str.replaceFirst(String.valueOf(key) + "=", "");
                break;
            }
        }
        return result;
    }

    public Collection<ArtifactTypeToken> getArtifactTypes() {
        ArrayList<ArtifactTypeToken> types = new ArrayList<ArtifactTypeToken>();
        types.addAll(this.orcsApi.tokenService().getArtifactTypes());
        return types;
    }

    public IAgileService getAgileService() {
        return this.agileService;
    }

    public void clearImplementersCache(IAtsWorkItem workItem) {
    }

    private List<ArtifactId> getCustomizeArts() {
        List<ArtifactId> customizationArts = this.getGlobalCustomizeArts();
        for (ArtifactId artifact : this.getQueryService().getArtifacts(CoreArtifactTypes.User)) {
            customizationArts.add(artifact);
        }
        return customizationArts;
    }

    private List<ArtifactId> getGlobalCustomizeArts() {
        ArrayList<ArtifactId> customizationArts = new ArrayList<ArtifactId>();
        for (ArtifactId artifact : this.getQueryService().getArtifacts(CoreArtifactTypes.XViewerGlobalCustomization)) {
            customizationArts.add(artifact);
        }
        return customizationArts;
    }

    @Override
    public Collection<CustomizeData> getCustomizations(String namespace) {
        ArrayList<CustomizeData> customizations = new ArrayList<CustomizeData>();
        for (ArtifactId customizationArt : this.getCustomizeArts()) {
            this.addCustomizationsFromArts(namespace, customizations, customizationArt);
        }
        return customizations;
    }

    private void addCustomizationsFromArts(String namespace, List<CustomizeData> customizations, ArtifactId customizationArt) {
        for (String custXml : this.getAttributeResolver().getAttributesToStringList(customizationArt, (AttributeTypeToken)CoreAttributeTypes.XViewerCustomization)) {
            if (!custXml.contains("\"" + namespace + "\"") && !custXml.contains("." + namespace + "\"")) continue;
            CustomizeData data = new CustomizeData(custXml);
            customizations.add(data);
        }
    }

    @Override
    public Collection<CustomizeData> getCustomizationsGlobal(String namespace) {
        ArrayList<CustomizeData> customizations = new ArrayList<CustomizeData>();
        for (ArtifactId customizationArt : this.getGlobalCustomizeArts()) {
            this.addCustomizationsFromArts(namespace, customizations, customizationArt);
        }
        return customizations;
    }

    public void clearCaches() {
        super.clearCaches();
        this.getConfigService().getConfigurationsWithPend();
    }

    @Override
    public AtsActionEndpointApi getActionEndpoint() {
        if (this.actionEndpoint == null) {
            this.actionEndpoint = new AtsActionEndpointImpl(this, this.orcsApi);
        }
        return this.actionEndpoint;
    }

    public String getApplicationServerBase() {
        return System.getProperty("OseeApplicationServer");
    }

    @Override
    public IAtsActionableItemService getActionableItemService() {
        return this.actionableItemManager;
    }

    public IAtsTaskRelatedService getTaskRelatedService() {
        return this.taskRelatedService;
    }

    public IAtsHealthService getHealthService() {
        if (this.healthService == null) {
            this.healthService = new AtsHealthServiceImpl();
        }
        return this.healthService;
    }

    public IAtsServerEndpointProvider getServerEndpoints() {
        return null;
    }

    public boolean isIde() {
        return false;
    }

    public UserService getUserGroupService() {
        return this.orcsApi.userService();
    }

    public IAccessControlService getAccessControlService() {
        return this.orcsApi.getAccessControlService();
    }
}

