/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.agile.IAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxAgileFeatureGroup;
import org.eclipse.osee.ats.api.agile.JaxAgileTeam;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.config.AtsViews;
import org.eclipse.osee.ats.api.config.IAtsConfigurationsService;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.core.agile.AgileFactory;
import org.eclipse.osee.ats.core.config.AbstractAtsConfigurationService;
import org.eclipse.osee.ats.rest.internal.config.AtsDbConfigBase;
import org.eclipse.osee.ats.rest.internal.config.AtsUserServiceServerImpl;
import org.eclipse.osee.ats.rest.internal.config.UpdateAtsConfiguration;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.ElapsedTime;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsConfigurationsService
extends AbstractAtsConfigurationService {
    private final OrcsApi orcsApi;
    Pattern keyValuePattern = Pattern.compile("^(.*)=(.*)", 32);

    public AtsConfigurationsService(AtsApi atsApi, OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.atsApi = atsApi;
        atsApi.getUserService().setConfigurationService((IAtsConfigurationsService)this);
    }

    public AtsConfigurations getConfigurations() {
        if (this.atsConfigurations == null) {
            this.load(false);
        }
        return this.atsConfigurations;
    }

    public boolean isConfigLoaded() {
        return this.atsConfigurations != null;
    }

    public AtsConfigurations getConfigurationsWithPend() {
        AtsConfigurations configs = this.load(true);
        return configs;
    }

    private synchronized AtsConfigurations load(boolean reload) {
        if (reload || this.atsConfigurations == null) {
            this.atsConfigurations = this.orcsApi.getAdminOps().isDataStoreInitialized() ? this.getAtsConfigurationsFromDb() : new AtsConfigurations();
        }
        return this.atsConfigurations;
    }

    private AtsConfigurations getAtsConfigurationsFromDb() {
        AtsConfigurations configs = new AtsConfigurations();
        HashMap<Long, ArtifactReadable> idToArtifact = new HashMap<Long, ArtifactReadable>();
        boolean debugOn = false;
        ElapsedTime time = new ElapsedTime("Server ACS - getAtsConfigurationsFromDb", debugOn);
        if (!debugOn) {
            time.off();
        }
        ElapsedTime time2 = new ElapsedTime("Server ACS - query", debugOn);
        QueryBuilder query = this.orcsApi.getQueryFactory().fromBranch((BranchId)CoreBranches.COMMON);
        ResultSet results = query.andTypeEquals(new ArtifactTypeToken[]{AtsArtifactTypes.TeamDefinition, AtsArtifactTypes.ActionableItem, AtsArtifactTypes.Version, CoreArtifactTypes.User, AtsArtifactTypes.AgileTeam, AtsArtifactTypes.AgileFeatureGroup}).getResults();
        this.processConfigQueryResults(configs, idToArtifact, time2, (ResultSet<ArtifactReadable>)results);
        time2.end();
        time2.start("Server ACS - setConfigValues");
        Map<String, String> configValues = this.setConfigValues(configs);
        time2.end();
        time2.start("Server ACS - views/cols/states");
        UpdateAtsConfiguration update = new UpdateAtsConfiguration(this.atsApi, this.orcsApi);
        AtsViews views = update.getConfigViews(configValues.get("views"));
        configs.setViews(views);
        configs.setColorColumns(update.getColorColumns(configValues.get("colorColumns")));
        configs.setValidStateNames(update.getValidStateNames(configValues.get("validStateNames")));
        time2.end();
        time.end();
        return configs;
    }

    private void processConfigQueryResults(AtsConfigurations configs, Map<Long, ArtifactReadable> idToArtifact, ElapsedTime time2, ResultSet<ArtifactReadable> results) {
        time2.start("Server ACS - process configs");
        for (ArtifactReadable art : results) {
            try {
                if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) {
                    TeamDefinition teamDef = this.atsApi.getTeamDefinitionService().createTeamDefinition((ArtifactToken)art);
                    configs.addTeamDef(teamDef);
                    this.handleTeamDef(art, teamDef, idToArtifact, configs);
                    if (AtsArtifactToken.TopTeamDefinition.equals(art)) {
                        configs.setTopTeamDefinition(ArtifactId.valueOf((Long)art.getId()));
                    }
                    teamDef.setAtsApi(this.atsApi);
                } else if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) {
                    ActionableItem ai = this.atsApi.getActionableItemService().createActionableItem((ArtifactToken)art);
                    configs.addAi(ai);
                    this.handleAi(art, ai, idToArtifact, configs);
                    if (AtsArtifactToken.TopActionableItem.equals(art)) {
                        configs.setTopActionableItem(ArtifactId.valueOf((Long)art.getId()));
                    }
                    ai.setAtsApi(this.atsApi);
                } else if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Version})) {
                    Version version = this.atsApi.getVersionService().createVersion((ArtifactToken)art);
                    configs.addVersion(version);
                    this.handleVersion(art, version, idToArtifact, configs);
                    version.setAtsApi(this.atsApi);
                } else if (art.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.User})) {
                    AtsUser user = AtsUserServiceServerImpl.valueOf(art);
                    configs.addUser(user);
                    user.setAtsApi(this.atsApi);
                    user.getTags().addAll(this.atsApi.getAttributeResolver().getAttributeValues((ArtifactId)art, (AttributeTypeToken)CoreAttributeTypes.StaticId));
                } else if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileTeam})) {
                    JaxAgileTeam agileTeam = AgileFactory.createJaxTeam((IAgileTeam)this.atsApi.getAgileService().getAgileTeam((ArtifactId)art));
                    configs.getIdToAgileTeam().put(agileTeam.getId(), agileTeam);
                    Collection atsTeams = this.atsApi.getRelationResolver().getRelated((ArtifactId)art, AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam);
                    for (ArtifactToken teamDef : atsTeams) {
                        configs.getTeamDefToAgileTeam().put(teamDef.getId(), agileTeam.getId());
                    }
                } else if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileFeatureGroup})) {
                    JaxAgileFeatureGroup feature = AgileFactory.createJaxAgileFeatureGroup((IAgileFeatureGroup)this.atsApi.getAgileService().getAgileFeatureGroup((ArtifactId)art));
                    configs.getIdToAgileFeature().put(feature.getId(), feature);
                    Collection agileTeams = this.atsApi.getRelationResolver().getRelated((ArtifactId)art, AtsRelationTypes.AgileTeamToFeatureGroup_AgileTeam);
                    if (!agileTeams.isEmpty()) {
                        ArtifactToken agileTeam = (ArtifactToken)agileTeams.iterator().next();
                        configs.getFeatureToAgileTeam().put(feature.getId(), agileTeam.getId());
                    }
                }
                idToArtifact.put(art.getId(), art);
            }
            catch (Exception ex) {
                XConsoleLogger.err((String)("Exception " + ex.getLocalizedMessage()), (Object[])new Object[0]);
            }
        }
        time2.end();
    }

    private Map<String, String> setConfigValues(AtsConfigurations configs) {
        ArtifactToken atsConfig = this.atsApi.getQueryService().getArtifact((ArtifactId)AtsArtifactToken.AtsConfig);
        if (atsConfig != null) {
            for (String keyValue : this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)atsConfig, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData)) {
                Matcher m = this.keyValuePattern.matcher(keyValue);
                if (!m.find()) continue;
                String key = m.group(1);
                String value = m.group(2);
                configs.addAtsConfig(key, value);
            }
        }
        return configs.getAtsConfig();
    }

    private TeamDefinition handleTeamDef(ArtifactReadable teamDefArt, TeamDefinition teamDef, Map<Long, ArtifactReadable> idToArtifact, AtsConfigurations configs) {
        ArtifactReadable parent = teamDefArt.getParent();
        if (parent != null) {
            teamDef.setParentId(parent.getId());
        }
        for (ArtifactReadable child : teamDefArt.getChildren()) {
            if (!child.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) continue;
            teamDef.getChildren().add(child.getId());
        }
        for (Long versionId : teamDefArt.getRelatedIds(AtsRelationTypes.TeamDefinitionToVersion_Version)) {
            teamDef.getVersions().add(versionId);
        }
        for (Long aiId : teamDefArt.getRelatedIds(AtsRelationTypes.TeamActionableItem_ActionableItem)) {
            teamDef.getAis().add(aiId);
        }
        teamDef.setHasWorkPackages(teamDefArt.getRelatedIds(AtsRelationTypes.TeamDefinitionToWorkPackage_WorkPackage).size() > 0);
        return teamDef;
    }

    private Version handleVersion(ArtifactReadable verArt, Version ver, Map<Long, ArtifactReadable> idToArtifact, AtsConfigurations configs) {
        for (Long teamDefId : verArt.getRelatedIds(AtsRelationTypes.TeamDefinitionToVersion_TeamDefinition)) {
            ver.setTeamDefId(teamDefId);
        }
        return ver;
    }

    private ActionableItem handleAi(ArtifactReadable aiArt, ActionableItem ai, Map<Long, ArtifactReadable> idToArtifact, AtsConfigurations configs) {
        ArtifactReadable parent = aiArt.getParent();
        if (parent != null) {
            ai.setParentId(parent.getId());
        }
        for (ArtifactReadable child : aiArt.getChildren()) {
            if (!child.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) continue;
            ai.getChildren().add(child.getId());
        }
        for (Long teamDefId : aiArt.getRelatedIds(AtsRelationTypes.TeamActionableItem_TeamDefinition)) {
            ai.setTeamDefId(teamDefId);
        }
        return ai;
    }

    public XResultData configAtsDatabase(AtsApi atsApi) {
        if (this.isAtsBaseCreated()) {
            XResultData results = new XResultData();
            results.error("ATS base config has already been completed");
            return results;
        }
        AtsDbConfigBase config = new AtsDbConfigBase(atsApi, this.orcsApi);
        return config.run();
    }

    public AtsUser getUserByLoginId(String loginId) {
        ArtifactToken userArt;
        AtsUser user = null;
        if (this.isConfigLoaded()) {
            for (AtsUser usr : this.atsApi.getUserService().getUsers()) {
                if (!usr.getLoginIds().contains(loginId)) continue;
                user = usr;
                break;
            }
        }
        if (user == null && (userArt = this.atsApi.getQueryService().getArtifactFromAttribute(CoreAttributeTypes.LoginId, System.getProperty("user.name"), (BranchId)this.atsApi.getAtsBranch())).isValid()) {
            user = this.atsApi.getUserService().getUserById((ArtifactId)userArt);
            if (this.isConfigLoaded()) {
                this.atsApi.getUserService().addUser(user);
            }
        }
        if (user == null) {
            user = this.atsApi.getUserService().getUserById((ArtifactId)SystemUser.UnAuthenticated);
        }
        return user;
    }

    public AtsUser getCurrentUserByLoginId() {
        throw new UnsupportedOperationException("Not supported on the server");
    }
}

