/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.country.CountryEndpointApi;
import org.eclipse.osee.ats.api.country.IAtsCountry;
import org.eclipse.osee.ats.api.country.JaxCountry;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.program.ProgramEndpointApi;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.rest.internal.config.BaseConfigEndpointImpl;
import org.eclipse.osee.ats.rest.internal.config.ProgramEndpointImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class CountryEndpointImpl
extends BaseConfigEndpointImpl<JaxCountry>
implements CountryEndpointApi {
    public CountryEndpointImpl(AtsApi atsApi) {
        super(AtsArtifactTypes.Country, AtsArtifactToken.CountryFolder, atsApi);
    }

    public Response update(JaxCountry country) throws Exception {
        ArtifactReadable artifact = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(country.getId());
        if (artifact == null) {
            throw new OseeStateException("Artifact with id %d not found", new Object[]{country.getIdString()});
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create " + this.artifactType.getName(), AtsCoreUsers.SYSTEM_USER);
        ArtifactToken configArtifact = changes.createArtifact(this.artifactType, country.getName(), country.getId());
        if (!configArtifact.getName().equals(country.getName())) {
            changes.setSoleAttributeValue((ArtifactId)configArtifact, (AttributeTypeToken)CoreAttributeTypes.Name, (Object)country.getName());
        }
        changes.execute();
        return Response.created((URI)new URI("/" + country.getIdString())).build();
    }

    @Override
    public JaxCountry getConfigObject(ArtifactId artifact) {
        JaxCountry jaxCountry = new JaxCountry();
        IAtsCountry country = this.atsApi.getProgramService().getCountryById(artifact);
        jaxCountry.setName(country.getName());
        jaxCountry.setId(country.getId());
        jaxCountry.setActive(country.isActive());
        jaxCountry.setDescription(country.getDescription());
        return jaxCountry;
    }

    @Override
    public List<JaxCountry> getObjects() {
        ArrayList<JaxCountry> configs = new ArrayList<JaxCountry>();
        for (ArtifactToken art : this.atsApi.getQueryService().getArtifacts(this.artifactType)) {
            configs.add(this.getConfigObject((ArtifactId)art));
        }
        return configs;
    }

    public ProgramEndpointApi getProgram(long countryId) {
        return new ProgramEndpointImpl(this.atsApi, countryId);
    }
}

