/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.insertion.InsertionActivityEndpointApi;
import org.eclipse.osee.ats.api.insertion.JaxInsertionActivity;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.rest.internal.config.BaseConfigEndpointImpl;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class InsertionActivityEndpointImpl
extends BaseConfigEndpointImpl<JaxInsertionActivity>
implements InsertionActivityEndpointApi {
    private final long insertionId;

    public InsertionActivityEndpointImpl(AtsApi atsApi) {
        this(atsApi, 0L);
    }

    public InsertionActivityEndpointImpl(AtsApi atsApi, long insertionId) {
        super(AtsArtifactTypes.InsertionActivity, null, atsApi);
        this.insertionId = insertionId;
    }

    @PUT
    public Response update(JaxInsertionActivity activity) throws Exception {
        ArtifactReadable artifact = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(activity.getId());
        if (artifact == null) {
            throw new OseeStateException("Artifact with id %d not found", new Object[]{activity.getIdString()});
        }
        IAtsChangeSet changes = this.atsApi.getStoreService().createAtsChangeSet("Create " + this.artifactType.getName(), AtsCoreUsers.SYSTEM_USER);
        ArtifactToken configArtifact = changes.createArtifact(this.artifactType, activity.getName(), activity.getId());
        IAtsInsertionActivity insertionActivity = this.atsApi.getProgramService().getInsertionActivityById((ArtifactId)configArtifact);
        if (!configArtifact.getName().equals(activity.getName())) {
            changes.setSoleAttributeValue((IAtsObject)insertionActivity, (AttributeTypeToken)CoreAttributeTypes.Name, (Object)activity.getName());
        }
        changes.execute();
        return Response.created((URI)new URI("/" + activity.getIdString())).build();
    }

    @Override
    public JaxInsertionActivity getConfigObject(ArtifactId artifact) {
        JaxInsertionActivity jaxInsertion = new JaxInsertionActivity();
        IAtsInsertionActivity insertion = this.atsApi.getProgramService().getInsertionActivityById(artifact);
        jaxInsertion.setName(insertion.getName());
        jaxInsertion.setId(insertion.getId());
        jaxInsertion.setActive(insertion.isActive());
        jaxInsertion.setDescription(insertion.getDescription());
        return jaxInsertion;
    }

    @Override
    public List<JaxInsertionActivity> getObjects() {
        ArrayList<JaxInsertionActivity> insertions = new ArrayList<JaxInsertionActivity>();
        if (this.insertionId == 0L) {
            for (ArtifactToken art : this.atsApi.getQueryService().getArtifacts(this.artifactType)) {
                insertions.add(this.getConfigObject((ArtifactId)art));
            }
        } else {
            for (ArtifactToken activityArt : this.atsApi.getRelationResolver().getRelated((ArtifactId)this.atsApi.getQueryService().getArtifact(Long.valueOf(this.insertionId)), AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity)) {
                JaxInsertionActivity activity = this.getConfigObject((ArtifactId)activityArt);
                activity.setInsertionId(this.insertionId);
                insertions.add(activity);
            }
        }
        return insertions;
    }

    @Override
    protected void create(JaxInsertionActivity jaxInsertionActivity, ArtifactId insertionActivityArtId, IAtsChangeSet changes) {
        ArtifactReadable insertionActivityArt = (ArtifactReadable)insertionActivityArtId;
        if (insertionActivityArt.getRelatedCount(AtsRelationTypes.InsertionToInsertionActivity_Insertion) == 0) {
            ArtifactReadable insertionArt = (ArtifactReadable)this.atsApi.getQueryService().getArtifact(Long.valueOf(jaxInsertionActivity.getInsertionId()));
            changes.relate((Object)insertionArt, AtsRelationTypes.InsertionToInsertionActivity_InsertionActivity, (Object)insertionActivityArt);
        }
    }
}

