/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.jdbc.OseePreparedStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.ExportImportJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public class ConsolidateRelationsDatabaseTxCallable
extends AbstractDatastoreTxCallable<Object> {
    private static final String SELECT_RELATIONS = "select * from osee_relation_link order by rel_link_type_id, a_art_id, b_art_id, gamma_id";
    private static final String SELECT_RELATION_ADDRESSING = "select txs.*, idj.id1 as net_gamma_id from osee_join_export_import idj, osee_txs txs where idj.query_id = ? and idj.id2 = txs.gamma_id order by net_gamma_id, transaction_id, id2";
    private static final String UPDATE_TXS_GAMMAS = "update osee_txs set gamma_id = ?, mod_type = ?, tx_current = ? where branch_id = ? and transaction_id = ? and gamma_id = ?";
    private static final String DELETE_TXS = "delete from osee_txs where branch_id = ? and transaction_id = ? and gamma_id = ?";
    private static final String DELETE_RELATIONS = "delete from osee_relation_link where gamma_id = ?";
    private final List<Long> obsoleteGammas = new ArrayList<Long>();
    private final StringBuilder addressingBackup = new StringBuilder(100000);
    private OseePreparedStatement deleteAddressing;
    private OseePreparedStatement updateAddressing;
    private OseePreparedStatement deleteRelations;
    private ExportImportJoinQuery gammaJoin;
    private JdbcConnection connection;
    private long previousRelationTypeId;
    private int previousArtifactAId;
    private int previousArtiafctBId;
    private long netGamma;
    private String netRationale;
    boolean materiallyDifferent;
    boolean updatedAddressing;
    private int counter;
    private final SqlJoinFactory joinFactory;
    private final Console console;
    long previousNetGammaId;
    long previousObsoleteGammaId;
    long previousTransactionId;
    long previousBranchId;
    ModificationType netModType;
    TxCurrent netTxCurrent;

    public ConsolidateRelationsDatabaseTxCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, SqlJoinFactory joinFactory, Console console) {
        super(logger, session, jdbcClient);
        this.joinFactory = joinFactory;
        this.console = console;
    }

    private void init() {
        this.previousRelationTypeId = -1L;
        this.previousArtifactAId = -1;
        this.previousArtiafctBId = -1;
        this.materiallyDifferent = true;
        this.obsoleteGammas.clear();
        this.updateAddressing = this.getJdbcClient().getBatchStatement(this.connection, UPDATE_TXS_GAMMAS);
        this.deleteAddressing = this.getJdbcClient().getBatchStatement(this.connection, DELETE_TXS);
        this.deleteRelations = this.getJdbcClient().getBatchStatement(this.connection, DELETE_RELATIONS);
        this.addressingBackup.delete(0, 999999999);
        this.updatedAddressing = false;
        this.previousNetGammaId = -1L;
        this.previousTransactionId = -1L;
        this.previousBranchId = -1L;
        this.gammaJoin = this.joinFactory.createExportImportJoinQuery();
        this.counter = 0;
    }

    @Override
    protected Object handleTxWork(JdbcConnection connection) {
        this.connection = connection;
        this.console.writeln((Object)"Consolidating relations:");
        this.init();
        try {
            this.getJdbcClient().runQueryWithMaxFetchSize(this::findObsoleteRelations, SELECT_RELATIONS, new Object[0]);
            this.console.writeln("gamma join size: [%s]", new Object[]{this.gammaJoin.size()});
            this.determineAffectedAddressing();
        }
        finally {
            this.gammaJoin.close();
        }
        this.updateGammas();
        this.console.writeln((Object)"...done.");
        return null;
    }

    private void findObsoleteRelations(JdbcStatement stmt) {
        int artiafctBId;
        int artifactAId;
        long relationTypeId = stmt.getLong("rel_link_type_id");
        if (this.isNextConceptualRelation(relationTypeId, artifactAId = stmt.getInt("a_art_id"), artiafctBId = stmt.getInt("b_art_id"))) {
            this.consolidate();
            this.initNextConceptualRelation(relationTypeId, artifactAId, artiafctBId, stmt.getLong("gamma_id"), stmt.getString("rationale"));
        } else {
            this.obsoleteGammas.add(stmt.getLong("gamma_id"));
            this.relationMateriallyDiffers(stmt.getString("rationale"));
        }
    }

    private void consolidate() {
        if (!this.materiallyDifferent && this.obsoleteGammas.size() > 0) {
            this.gammaJoin.add(this.netGamma, this.netGamma);
            for (Long obsoleteGamma : this.obsoleteGammas) {
                this.gammaJoin.add(this.netGamma, obsoleteGamma);
                this.deleteRelations.addToBatch((Object)obsoleteGamma);
            }
        }
        if (this.materiallyDifferent) {
            ++this.counter;
            this.console.writeln("rel_type:[%s] a_art_id:[%s]  b_art_id:[%s]", new Object[]{this.previousRelationTypeId, this.previousArtifactAId, this.previousArtiafctBId});
        }
    }

    private void determineAffectedAddressing() {
        this.gammaJoin.store();
        this.console.writeln("counter: [%s]", new Object[]{this.counter});
        this.console.writeln("query id: [%s]", new Object[]{this.gammaJoin.getQueryId()});
        this.getJdbcClient().runQueryWithMaxFetchSize(this::determineAffectedAddressing, SELECT_RELATION_ADDRESSING, new Object[]{this.gammaJoin.getQueryId()});
    }

    private void determineAffectedAddressing(JdbcStatement stmt) {
        long obsoleteGammaId = stmt.getLong("gamma_id");
        long transactionId = stmt.getLong("transaction_id");
        long netGammaId = stmt.getLong("net_gamma_id");
        int modType = stmt.getInt("mod_type");
        TxCurrent txCurrent = TxCurrent.valueOf((int)stmt.getInt("tx_current"));
        long branchId = stmt.getLong("branch_id");
        if (this.isNextAddressing(netGammaId, transactionId)) {
            if (this.updatedAddressing) {
                this.updateAddressing.addToBatch(new Object[]{this.previousNetGammaId, this.netModType, this.netTxCurrent, this.previousBranchId, this.previousTransactionId, this.previousObsoleteGammaId});
            }
            this.updatedAddressing = obsoleteGammaId != netGammaId;
            this.previousNetGammaId = netGammaId;
            this.previousObsoleteGammaId = obsoleteGammaId;
            this.previousTransactionId = transactionId;
            this.previousBranchId = branchId;
            this.netModType = ModificationType.valueOf((long)modType);
            this.netTxCurrent = txCurrent;
        } else {
            this.deleteAddressing.addToBatch((Object)branchId, (Object)transactionId, (Object)obsoleteGammaId);
            this.computeNetAddressing(ModificationType.valueOf((long)modType), txCurrent);
        }
        this.writeAddressingBackup(obsoleteGammaId, transactionId, netGammaId, modType, txCurrent);
    }

    private boolean isNextAddressing(long netGammaId, long transactionId) {
        return this.previousNetGammaId != netGammaId || this.previousTransactionId != transactionId;
    }

    private void computeNetAddressing(ModificationType modificationType, TxCurrent txCurrent) {
        if (this.netTxCurrentNeedsUpdate(txCurrent)) {
            this.netTxCurrent = txCurrent;
            this.updatedAddressing = true;
        }
        if (this.netModTypeNeedsUpdate(modificationType)) {
            this.netModType = modificationType;
            this.updatedAddressing = true;
        } else if (!this.ignoreNetModType(modificationType)) {
            throw new OseeStateException("    modType [%s] != [%s]", new Object[]{modificationType, this.netModType});
        }
    }

    private boolean netTxCurrentNeedsUpdate(TxCurrent txCurrent) {
        if (txCurrent == this.netTxCurrent) {
            return false;
        }
        boolean needsUpdate = txCurrent == TxCurrent.NOT_CURRENT;
        return (needsUpdate |= txCurrent == TxCurrent.CURRENT && this.netTxCurrent.isDeleted()) || this.netTxCurrent == TxCurrent.DELETED && txCurrent == TxCurrent.ARTIFACT_DELETED;
    }

    private boolean netModTypeNeedsUpdate(ModificationType modificationType) {
        boolean needsUpdate = !modificationType.isDeleted() && this.netModType.isDeleted();
        return (needsUpdate |= this.netModType == ModificationType.NEW && modificationType == ModificationType.MODIFIED) || this.netModType == ModificationType.DELETED && modificationType == ModificationType.ARTIFACT_DELETED;
    }

    private boolean ignoreNetModType(ModificationType modificationType) {
        boolean ignore = !this.netModType.isDeleted() && modificationType.isDeleted();
        ignore |= this.netModType == modificationType;
        ignore |= this.netModType == ModificationType.MODIFIED && modificationType == ModificationType.NEW;
        return (ignore |= this.netModType == ModificationType.INTRODUCED && modificationType == ModificationType.NEW) || this.netModType == ModificationType.ARTIFACT_DELETED && modificationType == ModificationType.DELETED;
    }

    private void updateGammas() {
        this.console.writeln("Number of txs rows deleted: [%s]", new Object[]{this.deleteAddressing.execute()});
        this.console.writeln("Number of relation rows deleted: [%s]", new Object[]{this.deleteRelations.execute()});
        this.console.writeln("Number of txs rows updated: [%s]", new Object[]{this.updateAddressing.execute()});
    }

    private void writeAddressingBackup(long obsoleteGammaId, long transactionId, long netGammaId, int modType, TxCurrent txCurrent) {
        StringBuilder strB = new StringBuilder(30);
        strB.append(obsoleteGammaId);
        strB.append(",");
        strB.append(transactionId);
        strB.append(",");
        strB.append(netGammaId);
        strB.append(",");
        strB.append(modType);
        strB.append(",");
        strB.append(txCurrent);
        strB.append("\n");
        this.console.writeln((Object)strB.toString());
    }

    private boolean isNextConceptualRelation(long relationTypeId, int artifactAId, int artiafctBId) {
        return this.previousRelationTypeId != relationTypeId || this.previousArtifactAId != artifactAId || this.previousArtiafctBId != artiafctBId;
    }

    private void relationMateriallyDiffers(String currentRationale) {
        if (!this.materiallyDifferent) {
            this.materiallyDifferent |= Strings.isValid((String)currentRationale) && !currentRationale.equals(this.netRationale);
        }
    }

    private void initNextConceptualRelation(long relationTypeId, int artifactAId, int artiafctBId, long gammaId, String rationale) {
        this.obsoleteGammas.clear();
        this.previousRelationTypeId = relationTypeId;
        this.previousArtifactAId = artifactAId;
        this.previousArtiafctBId = artiafctBId;
        this.netGamma = gammaId;
        this.netRationale = rationale;
        this.materiallyDifferent = false;
    }
}

