/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.sql.Timestamp;
import java.util.HashSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.BranchArchivedState;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.time.GlobalTime;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcDbType;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.jdbc.JdbcTransaction;
import org.eclipse.osee.jdbc.OseePreparedStatement;
import org.eclipse.osee.orcs.data.CreateBranchData;
import org.eclipse.osee.orcs.db.internal.IdentityManager;

public class CreateBranchDatabaseTxCallable
extends JdbcTransaction {
    private static final String INSERT_TX_DETAILS = "INSERT INTO osee_tx_details (branch_id, transaction_id, osee_comment, time, author, tx_type, build_id) VALUES (?,?,?,?,?,?,?)";
    private static final String UPDATE_BASELINE_BRANCH_TX = "UPDATE osee_branch SET baseline_transaction_id = ? WHERE branch_id = ? AND baseline_transaction_id = 1";
    private static final String SELECT_ADDRESSING = "with\ntxs as (select transaction_id, gamma_id, mod_type, app_id from osee_txs where branch_id = ? and transaction_id <= ?),\n\ntxsI as (\n   SELECT transaction_id, item.gamma_id, mod_type, app_id, 1 as item_type, attr_id as group_id FROM osee_attribute item, txs where txs.gamma_id = item.gamma_id\nUNION ALL\n   SELECT transaction_id, item.gamma_id, mod_type, app_id, 2 as item_type, art_id as group_id FROM osee_artifact item, txs where txs.gamma_id = item.gamma_id\nUNION ALL\n   SELECT transaction_id, item.gamma_id, mod_type, app_id, 4 as item_type, item.gamma_id as group_id FROM osee_tuple2 item, txs where txs.gamma_id = item.gamma_id\nUNION ALL\n   SELECT transaction_id, item.gamma_id, mod_type, app_id, 5 as item_type, item.gamma_id as group_id FROM osee_tuple3 item, txs where txs.gamma_id = item.gamma_id\nUNION ALL\n   SELECT transaction_id, item.gamma_id, mod_type, app_id, 6 as item_type, item.gamma_id as group_id FROM osee_tuple4 item, txs where txs.gamma_id = item.gamma_id\nUNION ALL\n   SELECT transaction_id, item.gamma_id, mod_type, app_id, 3 as item_type, rel_link_id as group_id FROM osee_relation_link item, txs where txs.gamma_id = item.gamma_id),\n\ntxsM as (SELECT MAX(transaction_id) AS transaction_id, item_type, group_id FROM txsI GROUP BY item_type, group_id)\n\nselect gamma_id, mod_type, app_id from txsI, txsM where txsM.item_type = txsI.item_type and txsM.group_id = txsI.group_id and txsM.transaction_id = txsI.transaction_id order by txsM.transaction_id desc";
    private static final String INSERT_ADDRESSING = "INSERT INTO osee_txs (transaction_id, gamma_id, mod_type, tx_current, branch_id, app_id) VALUES (?,?,?,?,?,?)";
    private static final String MERGE_BRANCH_INSERT = "INSERT INTO osee_merge (source_branch_id, dest_branch_id, merge_branch_id, commit_transaction_id) VALUES (?,?,?,?)";
    private static final String SELECT_ATTRIBUTE_ADDRESSING_FROM_JOIN = "SELECT item.gamma_id, txs.mod_type, txs.app_id FROM osee_attribute item, osee_txs txs, osee_join_id4 artjoin WHERE txs.branch_id = ? AND txs.tx_current <> ? AND txs.gamma_id = item.gamma_id AND item.art_id = artjoin.id2 and artjoin.query_id = ? ORDER BY txs.transaction_id DESC";
    private static final String SELECT_ARTIFACT_ADDRESSING_FROM_JOIN = "SELECT item.gamma_id, txs.mod_type, txs.app_id FROM osee_artifact item, osee_txs txs, osee_join_id4 artjoin WHERE txs.branch_id = ? AND txs.tx_current <> ? AND txs.gamma_id = item.gamma_id AND item.art_id = artjoin.id2 and artjoin.query_id = ? ORDER BY txs.transaction_id DESC";
    private static final String TEST_MERGE_BRANCH_EXISTENCE = "SELECT COUNT(1) FROM osee_merge WHERE source_branch_id = ? AND dest_branch_id = ?";
    private static final String INSERT_BRANCH = "INSERT INTO osee_branch (branch_id, branch_name, parent_branch_id, parent_transaction_id, archived, associated_art_id, branch_type, branch_state, baseline_transaction_id, inherit_access_control) VALUES (?,?,?,?,?,?,?,?,?,?)";
    private static final String SELECT_INHERIT_ACCESS_CONTROL = "SELECT inherit_access_control from osee_branch where branch_id = ?";
    private final JdbcClient jdbcClient;
    private final IdentityManager idManager;
    private final CreateBranchData newBranchData;
    private final Long buildVersionId;

    public CreateBranchDatabaseTxCallable(JdbcClient jdbcClient, IdentityManager idManager, CreateBranchData branchData, Long buildVersionId) {
        this.jdbcClient = jdbcClient;
        this.idManager = idManager;
        this.newBranchData = branchData;
        this.buildVersionId = buildVersionId;
    }

    public XResultData checkPreconditions(JdbcConnection connection) {
        int count;
        ArtifactId associatedArtifactId;
        XResultData rd = new XResultData();
        BranchId parentBranch = this.newBranchData.getParentBranch();
        BranchId destinationBranch = this.newBranchData.getMergeDestinationBranchId();
        if (this.newBranchData.getBranchType().isMergeBranch()) {
            if ((Integer)this.jdbcClient.fetch(connection, (Object)0, TEST_MERGE_BRANCH_EXISTENCE, new Object[]{parentBranch, destinationBranch}) > 0) {
                rd.errorf("Existing merge branch detected for [%s] and [%d]", new Object[]{parentBranch, destinationBranch});
            }
        } else if (!this.newBranchData.getBranchType().isSystemRootBranch() && (associatedArtifactId = this.newBranchData.getAssociatedArtifact()).isValid() && ArtifactId.SENTINEL.notEqual((Id)associatedArtifactId) && this.newBranchData.getBranchType().isWorkingBranch() && (count = ((Integer)this.jdbcClient.fetch(connection, (Object)0, "SELECT (1) FROM osee_branch WHERE associated_art_id = ? AND branch_state NOT IN (?, ?)", new Object[]{this.newBranchData.getAssociatedArtifact(), BranchState.DELETED, BranchState.REBASELINED})).intValue()) > 0) {
            if (this.newBranchData.getBranchType().equals((Object)BranchType.PORT)) {
                int portcount = (Integer)this.jdbcClient.fetch(connection, (Object)0, "SELECT (1) FROM osee_branch WHERE associated_art_id = ? AND branch_state NOT IN (?, ?) AND branch_type = ?", new Object[]{this.newBranchData.getAssociatedArtifact(), BranchState.DELETED, BranchState.REBASELINED, BranchType.PORT});
                if (portcount > 0) {
                    rd.errorf("Existing port branch creation detected for [%s]", new Object[]{this.newBranchData.getName()});
                }
            } else {
                rd.errorf("Existing branch creation detected for [%s]-[%s]", new Object[]{this.newBranchData.getBranch().getId(), this.newBranchData.getName()});
            }
        }
        return rd;
    }

    public void handleTxWork(JdbcConnection connection) {
        TransactionId sourceTx;
        TransactionId nextTransactionId;
        BranchId parentBranch = this.newBranchData.getParentBranch();
        XResultData rd = this.checkPreconditions(connection);
        if (rd.isErrors()) {
            throw new OseeStateException(rd.toString(), new Object[0]);
        }
        BranchId branch = this.newBranchData.getBranch();
        String truncatedName = Strings.truncate((String)this.newBranchData.getName(), (int)195, (boolean)true);
        Timestamp timestamp = GlobalTime.GreenwichMeanTimestamp();
        TransactionId tobeTransactionId = nextTransactionId = this.idManager.getNextTransactionId();
        boolean needsUpdate = this.jdbcClient.getDbType().matches(new Id[]{JdbcDbType.hsql, JdbcDbType.mysql});
        if (needsUpdate) {
            nextTransactionId = TransactionId.valueOf((int)1);
        }
        if (this.newBranchData.getBranchType().isSystemRootBranch()) {
            sourceTx = tobeTransactionId;
        } else {
            sourceTx = TransactionId.SENTINEL;
            if (BranchType.SYSTEM_ROOT != this.newBranchData.getBranchType()) {
                sourceTx = this.newBranchData.getFromTransaction();
            }
        }
        int inheritAccessControl = (Integer)this.jdbcClient.fetch(connection, (Object)0, SELECT_INHERIT_ACCESS_CONTROL, new Object[]{parentBranch});
        if (inheritAccessControl == 1) {
            this.newBranchData.setInheritAccess(true);
        }
        Object[] toInsert = new Object[]{branch, truncatedName, parentBranch, sourceTx, BranchArchivedState.UNARCHIVED, this.newBranchData.getAssociatedArtifact(), this.newBranchData.getBranchType(), BranchState.CREATED, nextTransactionId, inheritAccessControl};
        this.jdbcClient.runPreparedUpdate(connection, INSERT_BRANCH, toInsert);
        nextTransactionId = tobeTransactionId;
        this.jdbcClient.runPreparedUpdate(connection, INSERT_TX_DETAILS, new Object[]{branch, nextTransactionId, this.newBranchData.getCreationComment(), timestamp, this.newBranchData.getAuthor(), TransactionDetailsType.Baselined, this.buildVersionId});
        if (needsUpdate) {
            this.jdbcClient.runPreparedUpdate(connection, UPDATE_BASELINE_BRANCH_TX, new Object[]{nextTransactionId, branch});
        }
        this.populateBaseTransaction(0.3, connection, nextTransactionId, sourceTx);
        this.addMergeBranchEntry(0.2, connection);
    }

    private void addMergeBranchEntry(double workAmount, JdbcConnection connection) {
        if (this.newBranchData.getBranchType().isMergeBranch()) {
            this.jdbcClient.runPreparedUpdate(connection, MERGE_BRANCH_INSERT, new Object[]{this.newBranchData.getParentBranch(), this.newBranchData.getMergeDestinationBranchId(), this.newBranchData.getBranch(), 0});
        }
    }

    private void populateBaseTransaction(double workAmount, JdbcConnection connection, TransactionId baseTxId, TransactionId sourceTxId) {
        if (this.newBranchData.getBranchType() != BranchType.SYSTEM_ROOT) {
            HashSet<Long> gammas = new HashSet<Long>(100000);
            BranchId parentBranch = this.newBranchData.getParentBranch();
            OseePreparedStatement addressing = this.jdbcClient.getBatchStatement(connection, INSERT_ADDRESSING);
            if (this.newBranchData.getBranchType().isMergeBranch()) {
                this.populateAddressingToCopy(connection, addressing, baseTxId, gammas, SELECT_ATTRIBUTE_ADDRESSING_FROM_JOIN, parentBranch, TxCurrent.NOT_CURRENT, this.newBranchData.getMergeAddressingQueryId());
                this.populateAddressingToCopy(connection, addressing, baseTxId, gammas, SELECT_ARTIFACT_ADDRESSING_FROM_JOIN, parentBranch, TxCurrent.NOT_CURRENT, this.newBranchData.getMergeAddressingQueryId());
            } else {
                this.populateAddressingToCopy(connection, addressing, baseTxId, gammas, SELECT_ADDRESSING, parentBranch, sourceTxId);
            }
            addressing.execute();
        }
    }

    private void populateAddressingToCopy(JdbcConnection connection, OseePreparedStatement addressing, TransactionId baseTxId, HashSet<Long> gammas, String query, Object ... parameters) {
        try (JdbcStatement chStmt = this.jdbcClient.getStatement(connection);){
            chStmt.runPreparedQueryWithMaxFetchSize(query, parameters);
            BranchId branchId = this.newBranchData.getBranch();
            while (chStmt.next()) {
                Long gamma = chStmt.getLong("gamma_id");
                if (gammas.contains(gamma)) continue;
                ModificationType modType = ModificationType.valueOf((long)chStmt.getInt("mod_type"));
                Long appId = chStmt.getLong("app_id");
                TxCurrent txCurrent = TxCurrent.getCurrent((ModificationType)modType);
                addressing.addToBatch(new Object[]{baseTxId, gamma, modType, txCurrent, branchId, appId});
                gammas.add(gamma);
            }
        }
    }
}

