/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.handler;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.orcs.db.internal.exchange.TranslationManager;
import org.eclipse.osee.orcs.db.internal.exchange.handler.MetaData;

public class DataToSql {
    private DataToSql() {
    }

    public static Object[] toDataArray(MetaData metadata, Map<String, Object> dataMap) {
        int notNullCount = 0;
        Object[] data = new Object[metadata.getColumnSize()];
        int index = 0;
        for (String columnName : metadata.getColumnNames()) {
            Object dataValue = dataMap.get(columnName);
            if (dataValue != null) {
                data[index] = dataValue;
                ++notNullCount;
            } else {
                data[index] = metadata.toDataType(columnName);
            }
            ++index;
        }
        return notNullCount > 0 ? data : null;
    }

    public static Object[] toDataArray(MetaData metadata, TranslationManager translator, Map<String, String> fieldMap) {
        int notNullCount = 0;
        Object[] data = new Object[metadata.getColumnSize()];
        int index = 0;
        for (String columnName : metadata.getColumnNames()) {
            String dataValue = fieldMap.get(columnName);
            if (Strings.isValid((String)dataValue)) {
                Class<?> clazz = metadata.toClass(columnName);
                Object object = DataToSql.stringToObject(clazz, columnName, dataValue);
                if (object != null && translator.isTranslatable(columnName)) {
                    object = translator.translate(columnName, object);
                }
                if (object != null) {
                    data[index] = object;
                    ++notNullCount;
                } else {
                    data[index] = metadata.toDataType(columnName);
                }
            } else {
                data[index] = metadata.toDataType(columnName);
            }
            ++index;
        }
        return notNullCount > 0 ? data : null;
    }

    public static Object stringToObject(Class<?> clazz, String columnName, String value) {
        Object convertedObject = null;
        if (clazz != null) {
            if (clazz == BigInteger.class) {
                convertedObject = new BigInteger(value);
            } else if (clazz == BigDecimal.class) {
                convertedObject = new BigDecimal(value);
            } else {
                try {
                    Method mainMethod = clazz.getMethod("valueOf", String.class);
                    convertedObject = mainMethod.invoke(null, value);
                }
                catch (Exception exception) {
                    try {
                        Method mainMethod = clazz.getMethod("valueOf", Object.class);
                        convertedObject = mainMethod.invoke(null, value);
                    }
                    catch (Exception exception2) {
                        throw new OseeArgumentException("Unable to convert from string to object for - attribute [%s] to class [%s]", new Object[]{columnName, clazz.getName()});
                    }
                }
            }
        } else {
            convertedObject = value;
        }
        return convertedObject;
    }
}

