/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.transform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.text.Rule;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.osgi.framework.Version;

public class ManifestVersionRule
extends Rule {
    private static final Pattern exportPattern = Pattern.compile("<export ");
    public static final Pattern versionPattern = Pattern.compile("exportVersion=\"([^\"]+)");
    private String version;
    private boolean replaceVersion;

    public ManifestVersionRule() {
        super(null);
    }

    public ChangeSet computeChanges(CharSequence seq) {
        ChangeSet changeSet = new ChangeSet(seq);
        this.ruleWasApplicable = true;
        Matcher versionMatcher = versionPattern.matcher(seq);
        if (versionMatcher.find()) {
            if (this.replaceVersion) {
                changeSet.replace(versionMatcher.start(1), versionMatcher.end(1), this.version);
            } else {
                this.version = versionMatcher.group(1);
            }
        } else if (this.replaceVersion) {
            Matcher exportMatcher = exportPattern.matcher(seq);
            while (exportMatcher.find()) {
                changeSet.insertBefore(exportMatcher.end(), "exportVersion=\"" + this.version + "\" ");
            }
        }
        return changeSet;
    }

    public void setVersion(Version version) {
        this.version = version.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public void setReplaceVersion(boolean replaceVersion) {
        this.replaceVersion = replaceVersion;
    }
}

