/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.mvc;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public final class JaxRsMvcUtils {
    public static Charset UTF_8_ENCODING = JaxRsMvcUtils.newCharset("UTF-8");

    private JaxRsMvcUtils() {
    }

    private static Charset newCharset(String value) {
        return Charset.forName(value);
    }

    public static Charset computeEncoding(MediaType mediaType, Map<String, List<Object>> httpHeaders) {
        return JaxRsMvcUtils.computeEncoding(mediaType, httpHeaders, null);
    }

    public static Charset computeEncoding(MediaType mediaType, Map<String, List<Object>> httpHeaders, Charset defaultEncoding) {
        String charset = (String)mediaType.getParameters().get("charset");
        Charset encoding = defaultEncoding != null ? defaultEncoding : UTF_8_ENCODING;
        MediaType contentType = mediaType;
        if (charset != null) {
            encoding = Charset.forName(charset);
        } else {
            HashMap<String, String> params = new HashMap<String, String>(mediaType.getParameters());
            params.put("charset", encoding.name());
            contentType = new MediaType(mediaType.getType(), mediaType.getSubtype(), params);
        }
        ArrayList<String> typeList = new ArrayList<String>(1);
        typeList.add(contentType.toString());
        httpHeaders.put("Content-Type", typeList);
        return encoding;
    }
}

