/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util.io;

import java.io.OutputStream;
import java.util.function.Consumer;

public class StringOutputStream
extends OutputStream {
    private final StringBuilder strB;
    private final Consumer<String> onClose;

    public StringOutputStream() {
        this(null);
    }

    public StringOutputStream(Consumer<String> onClose) {
        this(onClose, 5000);
    }

    public StringOutputStream(Consumer<String> onClose, int initialCapacity) {
        this.strB = new StringBuilder(initialCapacity);
        this.onClose = onClose;
    }

    @Override
    public void write(int b) {
        this.strB.append((char)b);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) {
        this.strB.append(new String(bytes, offset, length));
    }

    public String toString() {
        return this.strB.toString();
    }

    @Override
    public void close() {
        if (this.onClose != null) {
            this.onClose.accept(this.toString());
        }
    }
}

