/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jdbc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcClientConfig;
import org.eclipse.osee.jdbc.JdbcConstants;
import org.eclipse.osee.jdbc.JdbcPoolConfig;
import org.eclipse.osee.jdbc.internal.JdbcClientImpl;
import org.eclipse.osee.jdbc.internal.JdbcConnectionFactory;
import org.eclipse.osee.jdbc.internal.JdbcConnectionFactoryManager;
import org.eclipse.osee.jdbc.internal.JdbcConnectionInfo;
import org.eclipse.osee.jdbc.internal.JdbcConnectionProvider;
import org.eclipse.osee.jdbc.internal.JdbcSequenceProvider;
import org.eclipse.osee.jdbc.internal.JdbcUtil;
import org.eclipse.osee.jdbc.internal.PoolFactory;
import org.eclipse.osee.jdbc.internal.PooledConnectionProvider;
import org.eclipse.osee.jdbc.internal.SimpleConnectionProvider;

public final class JdbcClientBuilder
extends JdbcClientConfig {
    public static JdbcClientBuilder newBuilder() {
        return new JdbcClientBuilder();
    }

    public static JdbcClientBuilder newBuilder(JdbcClientConfig config) {
        return JdbcClientBuilder.newBuilder().withConfig(config);
    }

    public static JdbcClientBuilder newBuilder(Map<String, Object> properties) {
        return JdbcClientBuilder.newBuilder().properties(properties);
    }

    public static JdbcClient fromConfig(JdbcClientConfig config) {
        return JdbcClientBuilder.newBuilder(config).build();
    }

    public static JdbcClient fromProperties(Map<String, Object> properties) {
        return JdbcClientBuilder.newBuilder(properties).build();
    }

    public static JdbcClientBuilder hsql(String db, int port) {
        return JdbcClientBuilder.hsql(db, null, port);
    }

    public static JdbcClientBuilder hsql(String db, String host, int port) {
        return JdbcClientBuilder.newBuilder().fromType(JdbcConstants.JdbcDriverType.hsql, db, host, port);
    }

    public static JdbcClientBuilder mysql(String db, String host, int port) {
        return JdbcClientBuilder.newBuilder().fromType(JdbcConstants.JdbcDriverType.mysql, db, host, port);
    }

    public static JdbcClientBuilder postgresql(String db, String host, int port) {
        return JdbcClientBuilder.newBuilder().fromType(JdbcConstants.JdbcDriverType.postgresql, db, host, port);
    }

    public static JdbcClientBuilder oracle(String db, String host, int port) {
        return JdbcClientBuilder.newBuilder().fromType(JdbcConstants.JdbcDriverType.oracle_thin, db, host, port);
    }

    private JdbcClientBuilder() {
    }

    public JdbcClient build() {
        JdbcConstants.JdbcDriverType type;
        JdbcClientConfig cfg = this.copy();
        if (!Strings.isValid((String)cfg.getDbDriver()) && (type = JdbcConstants.JdbcDriverType.fromUri(cfg.getDbUri())) != null) {
            this.dbDriver(type.getDriver());
        }
        JdbcConnectionProvider connectionProvider = this.getConnectionProvider(cfg.getPoolConfig());
        JdbcSequenceProvider sequenceProvider = new JdbcSequenceProvider();
        JdbcConnectionInfo dbInfo = JdbcUtil.newConnectionInfo(cfg.getDbDriver(), cfg.getDbUri(), cfg.getDbProps(), cfg.isDbAppendPropsToUri());
        return new JdbcClientImpl(cfg, connectionProvider, sequenceProvider, dbInfo);
    }

    private JdbcConnectionProvider getConnectionProvider(JdbcPoolConfig poolConfig) {
        JdbcConnectionProvider connectionProvider;
        ConcurrentHashMap<String, JdbcConnectionFactory> factories = new ConcurrentHashMap<String, JdbcConnectionFactory>();
        JdbcConnectionFactoryManager manager = new JdbcConnectionFactoryManager(factories);
        if (poolConfig.isPoolEnabled()) {
            PoolFactory poolFactory = new PoolFactory(manager, poolConfig);
            connectionProvider = new PooledConnectionProvider(poolFactory);
        } else {
            connectionProvider = new SimpleConnectionProvider(manager);
        }
        return connectionProvider;
    }

    public JdbcClientBuilder properties(Map<String, Object> src) {
        this.readProperties(src);
        return this;
    }

    public JdbcClientBuilder withConfig(JdbcClientConfig config) {
        this.copy(config);
        return this;
    }

    public JdbcClientBuilder dbDriver(String driver) {
        this.setDbDriver(driver);
        return this;
    }

    public JdbcClientBuilder production(boolean production) {
        this.setProduction(production);
        return this;
    }

    public JdbcClientBuilder dbUri(String format, Object ... args) {
        this.dbUri(String.format(format, args));
        return this;
    }

    public JdbcClientBuilder dbUri(String uri) {
        this.setDbUri(uri);
        return this;
    }

    public JdbcClientBuilder dbParamsInUri(boolean value) {
        this.setDbAppendPropsToUri(value);
        return this;
    }

    public JdbcClientBuilder dbUsername(String username) {
        this.setDbUsername(username);
        return this;
    }

    public JdbcClientBuilder dbPassword(String password) {
        this.setDbPassword(password);
        return this;
    }

    public JdbcClientBuilder dbParam(String key, String value) {
        this.addDbParam(key, value);
        return this;
    }

    public JdbcClientBuilder poolAbandonedLoggingEnabled(boolean value) {
        this.getPoolConfig().setPoolAbandonedLoggingEnabled(value);
        return this;
    }

    public JdbcClientBuilder poolAbandonedRemovalEnabled(boolean value) {
        this.getPoolConfig().setPoolAbandonedRemovalEnabled(value);
        return this;
    }

    public JdbcClientBuilder poolAbandonedRemovalTimeout(int value) {
        this.getPoolConfig().setPoolAbandonedRemovalTimeout(value);
        return this;
    }

    public JdbcClientBuilder poolEnabled(boolean value) {
        this.getPoolConfig().setPoolEnabled(value);
        return this;
    }

    public JdbcClientBuilder poolExhaustedAction(JdbcConstants.PoolExhaustedAction value) {
        this.getPoolConfig().setPoolExhaustedAction(value);
        return this;
    }

    public JdbcClientBuilder poolLifo(boolean value) {
        this.getPoolConfig().setPoolLifo(value);
        return this;
    }

    public JdbcClientBuilder poolMaxActiveConnections(int value) {
        this.getPoolConfig().setPoolMaxActiveConnections(value);
        return this;
    }

    public JdbcClientBuilder poolMaxActivePreparedStatements(int value) {
        this.getPoolConfig().setPoolMaxActivePreparedStatements(value);
        return this;
    }

    public JdbcClientBuilder poolMaxIdleConnections(int value) {
        this.getPoolConfig().setPoolMaxIdleConnections(value);
        return this;
    }

    public JdbcClientBuilder poolMaxIdlePreparedStatements(int value) {
        this.getPoolConfig().setPoolMaxIdlePreparedStatements(value);
        return this;
    }

    public JdbcClientBuilder poolMaxTotalPreparedStatements(int value) {
        this.getPoolConfig().setPoolMaxTotalPreparedStatements(value);
        return this;
    }

    public JdbcClientBuilder poolMaxWaitForConnection(long value) {
        this.getPoolConfig().setPoolMaxWaitForConnection(value);
        return this;
    }

    public JdbcClientBuilder poolMaxWaitPreparedStatements(long value) {
        this.getPoolConfig().setPoolMaxWaitPreparedStatements(value);
        return this;
    }

    public JdbcClientBuilder poolMinEvictableIdleTimeMillis(long value) {
        this.getPoolConfig().setPoolMinEvictableIdleTimeMillis(value);
        return this;
    }

    public JdbcClientBuilder poolMinIdleConnections(int value) {
        this.getPoolConfig().setPoolMinIdleConnections(value);
        return this;
    }

    public JdbcClientBuilder poolMinIdlePreparedStatements(int value) {
        this.getPoolConfig().setPoolMinIdlePreparedStatements(value);
        return this;
    }

    public JdbcClientBuilder poolNumberTestsPerEvictionRun(int value) {
        this.getPoolConfig().setPoolNumberTestsPerEvictionRun(value);
        return this;
    }

    public JdbcClientBuilder poolPreparedStatementsAllowed(boolean value) {
        this.getPoolConfig().setPoolPreparedStatementsAllowed(value);
        return this;
    }

    public JdbcClientBuilder poolSoftMinEvictableTimeoutMillis(long value) {
        this.getPoolConfig().setPoolSoftMinEvictableTimeoutMillis(value);
        return this;
    }

    public JdbcClientBuilder poolTestOnBorrowEnabled(boolean value) {
        this.getPoolConfig().setPoolTestOnBorrowEnabled(value);
        return this;
    }

    public JdbcClientBuilder poolTestOnReturnEnabled(boolean value) {
        this.getPoolConfig().setPoolTestOnReturnEnabled(value);
        return this;
    }

    public JdbcClientBuilder poolTestWhileIdeEnabled(boolean value) {
        this.getPoolConfig().setPoolTestWhileIdeEnabled(value);
        return this;
    }

    public JdbcClientBuilder poolTimeBetweenEvictionCheckMillis(long value) {
        this.getPoolConfig().setPoolTimeBetweenEvictionCheckMillis(value);
        return this;
    }

    public JdbcClientBuilder poolValidationQueryTimeoutSecs(int value) {
        this.getPoolConfig().setPoolValidationQueryTimeoutSecs(value);
        return this;
    }

    public JdbcClientBuilder fromType(JdbcConstants.JdbcDriverType type, String db, int port) {
        return this.fromType(type, db, null, port);
    }

    public JdbcClientBuilder fromType(JdbcConstants.JdbcDriverType type, String db, String host, int port) {
        this.dbDriver(type.getDriver());
        String dbHost = host;
        if (JdbcConstants.JdbcDriverType.hsql == type && !Strings.isValid((String)dbHost)) {
            dbHost = "127.0.0.1";
        }
        this.dbUri(type.getUriFormat(), type.getPrefix(), dbHost, port, db);
        switch (type) {
            case hsql: {
                this.dbParamsInUri(true);
                if (Strings.isValid((String)this.getDbUsername())) break;
                this.dbUsername("public");
                break;
            }
            case oracle_thin: {
                if (!this.getDbProps().containsKey("SetBigStringTryClob")) {
                    this.dbParam("SetBigStringTryClob", "true");
                }
                if (this.getDbProps().containsKey("includeSynonyms")) break;
                this.dbParam("includeSynonyms", "true");
                break;
            }
        }
        return this;
    }
}

