/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.template.engine.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.MediaType;
import org.eclipse.osee.framework.jdk.core.type.IResourceRegistry;
import org.eclipse.osee.framework.jdk.core.type.ResourceToken;
import org.eclipse.osee.framework.jdk.core.util.ChecksumUtil;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.template.engine.OseeTemplateTokens;
import org.eclipse.osee.template.engine.PageCreator;
import org.eclipse.osee.template.engine.internal.TemplateRegistry;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;

public class TemplateRegistryImpl
implements TemplateRegistry,
IResourceRegistry,
BundleListener {
    private static final String OSEE_TEMPLATE_HDR = "Osee-Template";
    private static final String OSEE_TEMPLATE_HDR__UUID_ATTRIBUTE = "uuid";
    private ConcurrentHashMap<String, TemplateResources> templates;
    private ConcurrentHashMap<Long, ResourceToken> tokenByUuid;
    private ConcurrentHashMap<String, ResourceToken> tokenByName;
    private Log logger;

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void start(BundleContext context) {
        this.templates = new ConcurrentHashMap();
        this.tokenByName = new ConcurrentHashMap();
        this.tokenByUuid = new ConcurrentHashMap();
        OseeTemplateTokens.register(this);
        context.addBundleListener((BundleListener)this);
        Bundle[] bundles = context.getBundles();
        if (bundles != null) {
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                int state = bundle.getState();
                this.processBundle(bundle, state);
                ++n2;
            }
        }
    }

    public void stop(BundleContext context) {
        context.removeBundleListener((BundleListener)this);
        this.templates.clear();
        this.tokenByName.clear();
        this.tokenByUuid.clear();
    }

    private void cache(ResourceToken token) {
        this.tokenByUuid.put((Long)token.getGuid(), token);
        ResourceToken oldToken = this.tokenByName.put(token.getName(), token);
        if (oldToken != null && !((Long)token.getGuid()).equals(oldToken.getGuid())) {
            this.logger.error("Template conflict detected between - [%s] and [%s]", new Object[]{oldToken, token});
        }
    }

    private void decache(ResourceToken token) {
        this.tokenByUuid.remove(token.getGuid());
        this.tokenByName.remove(token.getName());
    }

    private String getTemplateHeader(Bundle bundle) {
        return (String)bundle.getHeaders().get(OSEE_TEMPLATE_HDR);
    }

    private boolean hasTemplateHeader(Bundle bundle) {
        String headerValue = this.getTemplateHeader(bundle);
        return Strings.isValid((String)headerValue);
    }

    @Override
    public void accept(TemplateRegistry.TemplateVisitor visitor) {
        for (TemplateResources resource : this.templates.values()) {
            for (TemplateToken template : resource.getTokens()) {
                visitor.onTemplate(template.getBundle(), template);
            }
        }
    }

    @Override
    public Set<String> getAttributes(ResourceToken template) {
        PageCreator pageCreator = new PageCreator(this);
        pageCreator.readKeyValuePairs(template.getInputStream());
        return pageCreator.getAttributes();
    }

    @Override
    public ResourceToken resolveTemplate(String viewId, MediaType mediaType) {
        ResourceToken resourceToken = null;
        if (Strings.isNumeric((String)viewId)) {
            Long uuid = Long.parseLong(viewId);
            resourceToken = this.getResourceToken(uuid);
        } else {
            String name = viewId;
            int index = name.lastIndexOf("/");
            if (index > -1) {
                name = name.substring(index + 1);
            }
            resourceToken = this.tokenByName.get(name);
        }
        return resourceToken;
    }

    @Override
    public IResourceRegistry getResourceRegistry() {
        return this;
    }

    public ResourceToken registerResource(Long universalId, ResourceToken token) {
        throw new UnsupportedOperationException();
    }

    public void registerAll(Iterable<ResourceToken> tokens) {
        for (ResourceToken token : tokens) {
            this.cache(token);
        }
    }

    public ResourceToken getResourceToken(Long uuid) {
        return this.tokenByUuid.get(uuid);
    }

    public InputStream getResource(Long uuid) {
        ResourceToken token = this.getResourceToken(uuid);
        InputStream toReturn = null;
        if (token != null) {
            toReturn = token.getInputStream();
        } else {
            this.logger.error("Unable to find template-resource [%s]", new Object[]{uuid});
        }
        return toReturn;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        this.processBundle(bundle, event.getType());
    }

    private void processBundle(Bundle bundle, int state) {
        boolean isActive = false;
        boolean isStopping = false;
        if (state == 32 || state == 8 || state == 2 || state == 4) {
            isActive = true;
        } else if (state == 16) {
            isStopping = true;
        }
        if (isActive && this.hasTemplateHeader(bundle)) {
            this.addBundle(bundle);
        } else if (isStopping && this.hasTemplateHeader(bundle)) {
            this.removeBundle(bundle);
        }
    }

    private void removeBundle(Bundle bundle) {
        String bundleName = bundle.getSymbolicName();
        TemplateResources removed = this.templates.remove(bundleName);
        if (removed != null) {
            Iterable<TemplateToken> tokens = removed.getTokens();
            for (TemplateToken token : tokens) {
                this.decache(token);
            }
        }
    }

    private void addBundle(Bundle bundle) {
        String bundleName = bundle.getSymbolicName();
        String headerValue = this.getTemplateHeader(bundle);
        ManifestElement[] elements = null;
        try {
            elements = ManifestElement.parseHeader((String)OSEE_TEMPLATE_HDR, (String)headerValue);
        }
        catch (BundleException ex) {
            this.logger.error((Throwable)ex, "Error parsing manifest header [%s] for bundle [%s]", new Object[]{OSEE_TEMPLATE_HDR, bundleName});
        }
        if (elements != null && elements.length > 0) {
            TemplateResources tokens = new TemplateResources();
            ManifestElement[] manifestElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                ManifestElement element = manifestElementArray[n2];
                String resource = element.getValue();
                String uuidAttribute = element.getAttribute(OSEE_TEMPLATE_HDR__UUID_ATTRIBUTE);
                List<URL> resourceUrls = this.findUrls(bundle, headerValue, false, resource);
                if (resourceUrls != null && !resourceUrls.isEmpty()) {
                    if (Strings.isValid((String)uuidAttribute)) {
                        if (this.isValidUuid(uuidAttribute)) {
                            URL url = resourceUrls.iterator().next();
                            Long uuid = Long.valueOf(uuidAttribute);
                            this.addEntry(bundle, headerValue, tokens, url, uuid);
                        } else {
                            this.logger.error("Invalid uuidAttribute [%s] for manifest element [%s] in bundle [%s]", new Object[]{uuidAttribute, element, bundleName});
                        }
                    } else {
                        for (URL url : resourceUrls) {
                            this.addEntry(bundle, headerValue, tokens, url, null);
                        }
                    }
                }
                ++n2;
            }
            if (!tokens.isEmpty()) {
                this.templates.put(bundleName, tokens);
            }
        }
    }

    private boolean isValidUuid(String value) {
        return Strings.isNumeric((String)value);
    }

    private void addEntry(Bundle bundle, String headerValue, TemplateResources tokens, URL url, Long uuidSpecified) {
        String bundleName = bundle.getSymbolicName();
        try {
            String name = this.urlAsName(url);
            Long uuid = uuidSpecified != null ? uuidSpecified : this.nameToUuid(name);
            TemplateToken token = TemplateRegistryImpl.newToken(bundle, uuid, name, url);
            boolean wasAdded = tokens.addToken(token);
            if (!wasAdded) {
                this.logger.error("Invalid template uuid conflicts with previous definition - bundle [%s] header [%s]", new Object[]{bundleName, headerValue});
            }
            this.cache(token);
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Invalid uuidAttribute for bundle [%s] with header [%s]", new Object[]{bundleName, headerValue});
        }
    }

    private Long nameToUuid(String name) throws Exception {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(name.getBytes("UTF-8"));
        byte[] checksum = ChecksumUtil.createChecksum((InputStream)inputStream, (String)"MD5");
        return ByteBuffer.wrap(checksum).getLong();
    }

    private String urlAsName(URL url) {
        String name = url.toString();
        int index = name.lastIndexOf(47);
        if (index > -1) {
            name = name.substring(index + 1);
        }
        return name;
    }

    private List<URL> findUrls(Bundle bundle, String headerValue, boolean recurse, String ... resources) {
        ArrayList<URL> resourceUrls = new ArrayList<URL>();
        String[] stringArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            String resourceName;
            String resource = stringArray[n2];
            int index = resource.lastIndexOf(47);
            String path = index != -1 ? resource.substring(0, index) : "/";
            Enumeration urls = bundle.findEntries(path, resourceName = index != -1 ? resource.substring(index + 1) : resource, recurse);
            if (urls != null && urls.hasMoreElements()) {
                while (urls.hasMoreElements()) {
                    URL url = (URL)urls.nextElement();
                    resourceUrls.add(url);
                }
            } else {
                this.logger.error("Unable to find template-resource[%s] for bundle [%s]. The component header value is [%s]", new Object[]{resource, bundle.getSymbolicName(), headerValue});
            }
            ++n2;
        }
        return resourceUrls;
    }

    private static TemplateToken newToken(Bundle bundle, Long uuid, String name, URL url) {
        return new TemplateToken(bundle, uuid, name, url);
    }

    private static class TemplateResources {
        private final Set<TemplateToken> tokens = new HashSet<TemplateToken>();

        private TemplateResources() {
        }

        public boolean addToken(TemplateToken token) {
            return this.tokens.add(token);
        }

        public Iterable<TemplateToken> getTokens() {
            return this.tokens;
        }

        public boolean isEmpty() {
            return this.tokens.isEmpty();
        }
    }

    private static class TemplateToken
    extends ResourceToken {
        private final Bundle bundle;
        private final String name;
        private final URL url;

        public TemplateToken(Bundle bundle, Long uuid, String name, URL url) {
            super(uuid, name);
            this.bundle = bundle;
            this.name = name;
            this.url = url;
        }

        public URL getUrl() {
            return this.url;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            ResourceToken other = (ResourceToken)obj;
            return !(this.getUrl() == null ? other.getUrl() != null : !this.getUrl().equals(other.getUrl()));
        }

        public String toString() {
            return String.format("%s::%s::%s - [%s]", this.bundle, this.getGuid(), this.name, this.url);
        }
    }
}

