/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.rest.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.AttributeReadable;
import org.eclipse.osee.orcs.rest.internal.HtmlWriter;
import org.eclipse.osee.orcs.rest.model.AttributeEndpoint;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AttributeEndpointImpl
implements AttributeEndpoint {
    private final QueryBuilder query;
    private final UriInfo uriInfo;
    private final BranchId branch;
    private final ArtifactId artifactId;
    private final OrcsApi orcsApi;

    public AttributeEndpointImpl(ArtifactId artifactId, BranchId branch, OrcsApi orcsApi, QueryBuilder query, UriInfo uriInfo) {
        this.artifactId = artifactId;
        this.query = query;
        this.uriInfo = uriInfo;
        this.branch = branch;
        this.orcsApi = orcsApi;
    }

    public String getAttributesAsHtml(ArtifactId artifactId) {
        ArtifactReadable artifact = (ArtifactReadable)this.query.andId(artifactId).getResults().getExactlyOne();
        HtmlWriter writer = new HtmlWriter(this.uriInfo, this.orcsApi);
        return writer.toHtml((Iterable<? extends Object>)artifact.getAttributes());
    }

    public Response getAttribute(AttributeId attributeId) {
        return this.getAttributeResponse(attributeId, TransactionId.SENTINEL, false);
    }

    public Response getAttributeWithGammaAsText(AttributeId attributeId, TransactionId transaction) {
        return this.getAttributeResponse(attributeId, transaction, true);
    }

    public Response getAttributeWithGamma(AttributeId attributeId, TransactionId transaction) {
        return this.getAttributeResponse(attributeId, transaction, false);
    }

    private Response getAttributeResponse(final AttributeId attributeId, TransactionId transaction, boolean textOut) {
        Response.ResponseBuilder builder = Response.noContent();
        try {
            ArtifactReadable exactlyOne;
            Optional item;
            QueryBuilder queryBuilder = this.query.andId(this.artifactId);
            if (transaction.isValid()) {
                queryBuilder.fromTransaction(transaction);
            }
            if ((item = Iterables.tryFind((Iterable)(exactlyOne = (ArtifactReadable)queryBuilder.getResults().getExactlyOne()).getAttributes(), (Predicate)new Predicate<AttributeReadable<Object>>(){

                public boolean apply(AttributeReadable<Object> attribute) {
                    return attributeId.equals(attribute);
                }
            })).isPresent()) {
                Object value = item.get();
                if (value instanceof AttributeReadable) {
                    builder = Response.ok();
                    AttributeReadable attribute = (AttributeReadable)value;
                    String mediaType = attribute.getAttributeType().getMediaType();
                    String fileExtension = attribute.getAttributeType().getFileExtension();
                    if (mediaType.isEmpty() || mediaType.startsWith("text") || textOut) {
                        builder.entity((Object)attribute.getDisplayableString());
                    } else {
                        ResultSet results = exactlyOne.getAttributes((AttributeTypeToken)CoreAttributeTypes.Extension);
                        AttributeReadable extension = (AttributeReadable)results.getOneOrNull();
                        if (extension != null) {
                            fileExtension = extension.getDisplayableString();
                        }
                        Object content = attribute.getValue();
                        builder.entity(content);
                        builder.header("Content-type", (Object)mediaType);
                        String filename = URLEncoder.encode(String.valueOf(exactlyOne.getName()) + "." + fileExtension, "UTF-8");
                        builder.header("Content-Disposition", (Object)("attachment; filename=" + filename));
                    }
                }
            } else {
                builder = Response.status((Response.Status)Response.Status.NOT_FOUND);
            }
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return builder.build();
    }

    public Response getAttributeTypes() {
        return this.getAttributeTypeResponse();
    }

    public Response getAttributeTypeValues(AttributeTypeToken attributeType) {
        return this.getAttributeTypeResponse(TransactionId.SENTINEL, attributeType);
    }

    public Response getAttributeTypeValuesForTransaction(AttributeTypeToken attributeType, TransactionId transaction) {
        return this.getAttributeTypeResponse(transaction, attributeType);
    }

    private Response getAttributeTypeResponse(TransactionId transaction, AttributeTypeToken attributeType) {
        Response.ResponseBuilder builder;
        block9: {
            builder = Response.noContent();
            try {
                QueryBuilder queryBuilder = this.query.andId(this.artifactId);
                if (transaction.isValid()) {
                    queryBuilder.fromTransaction(transaction);
                }
                ArtifactReadable exactlyOne = (ArtifactReadable)queryBuilder.getResults().getExactlyOne();
                ArrayList<AttributeReadable> attrs = new ArrayList<AttributeReadable>();
                for (AttributeReadable attr : exactlyOne.getAttributes(attributeType)) {
                    attrs.add(attr);
                }
                if (attrs.size() == 1) {
                    builder = Response.ok();
                    AttributeReadable attribute = (AttributeReadable)attrs.iterator().next();
                    String mediaType = attribute.getAttributeType().getMediaType();
                    String fileExtension = attribute.getAttributeType().getFileExtension();
                    if (mediaType.isEmpty() || mediaType.startsWith("text")) {
                        builder.entity((Object)attribute.getDisplayableString());
                    } else {
                        ResultSet results = exactlyOne.getAttributes((AttributeTypeToken)CoreAttributeTypes.Extension);
                        AttributeReadable extension = (AttributeReadable)results.getOneOrNull();
                        if (extension != null) {
                            fileExtension = extension.getDisplayableString();
                        }
                        Object content = attribute.getValue();
                        builder.entity(content);
                        builder.header("Content-type", (Object)mediaType);
                        String filename = URLEncoder.encode(String.valueOf(exactlyOne.getName()) + "." + fileExtension, "UTF-8");
                        builder.header("Content-Disposition", (Object)("attachment; filename=" + filename));
                    }
                    break block9;
                }
                if (attrs.size() > 1) {
                    String values = Collections.toString((String)"</br>", attrs);
                    return Response.ok((Object)AHTML.simplePage((String)values)).build();
                }
                return Response.ok((Object)AHTML.simplePage((String)String.format("No attributes of type [%s] found.", attributeType))).build();
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        return builder.build();
    }

    private Response getAttributeTypeResponse() {
        try {
            QueryBuilder queryBuilder = this.query.andId(this.artifactId);
            ArtifactReadable exactlyOne = (ArtifactReadable)queryBuilder.getResults().getExactlyOne();
            StringBuilder sb = new StringBuilder();
            sb.append(AHTML.beginMultiColumnTable((int)95));
            sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.bold((String)"Valid Types")}));
            sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{""}));
            for (AttributeTypeToken attrType : exactlyOne.getValidAttributeTypes()) {
                sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.bold((String)"Name:"), attrType.getName()}));
                sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{AHTML.bold((String)"Attribute Type:"), AHTML.getHyperlink((String)String.format("/orcs/branch/%s/artifact/%s/attribute/type/%s", this.branch, this.artifactId, attrType.getIdString()), (String)attrType.getIdString())}));
                sb.append(AHTML.addRowMultiColumnTable((String[])new String[]{""}));
            }
            sb.append(AHTML.endMultiColumnTable());
            return Response.ok((Object)AHTML.simplePage((String)sb.toString())).build();
        }
        catch (Exception ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }
}

