/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mail.internal;

import java.util.Map;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.mail.internal.MailConstants;

public class MailConfiguration {
    private String username;
    private String password;
    private String host;
    private int port;
    private String transport;
    private String adminEmail;
    private String replyToEmail;
    private String testEmailSubject;
    private String testEmailBody;
    private long waitTimeInMillis;

    private MailConfiguration() {
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTransport() {
        return this.transport;
    }

    public boolean isAuthenticationRequired() {
        return Strings.isValid((String)this.username) && Strings.isValid((String)this.password);
    }

    public String getUserName() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public String getReplyToEmail() {
        return this.replyToEmail;
    }

    public String getTestEmailSubject() {
        return this.testEmailSubject;
    }

    public String getTestEmailBody() {
        return this.testEmailBody;
    }

    public long getStatusWaitTime() {
        return this.waitTimeInMillis;
    }

    public MailConfiguration copy() {
        MailConfiguration data = new MailConfiguration();
        data.username = this.username;
        data.password = this.password;
        data.host = this.host;
        data.port = this.port;
        data.transport = this.transport;
        data.adminEmail = this.adminEmail;
        data.replyToEmail = this.replyToEmail;
        data.testEmailSubject = this.testEmailSubject;
        data.testEmailBody = this.testEmailBody;
        data.waitTimeInMillis = this.waitTimeInMillis;
        return data;
    }

    void setUserName(String username) {
        this.username = username;
    }

    void setPassword(String password) {
        this.password = password;
    }

    void setHost(String host) {
        this.host = host;
    }

    void setPort(int port) {
        this.port = port;
    }

    void setTransport(String transport) {
        this.transport = transport;
    }

    void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
    }

    void setReplyToEmail(String replyToEmail) {
        this.replyToEmail = replyToEmail;
    }

    void setTestEmailSubject(String testEmailSubject) {
        this.testEmailSubject = testEmailSubject;
    }

    void setTestEmailBody(String testEmailBody) {
        this.testEmailBody = testEmailBody;
    }

    void setStatusWaitTime(long waitTimeInMillis) {
        this.waitTimeInMillis = waitTimeInMillis;
    }

    public String toString() {
        return "MailConfiguration [username=" + this.username + ", password=" + this.password + ", host=" + this.host + ", port=" + this.port + ", transport=" + this.transport + ", adminEmail=" + this.adminEmail + ", replyToEmail=" + this.replyToEmail + ", testEmailSubject=" + this.testEmailSubject + ", testEmailBody=" + this.testEmailBody + ", waitTimeInMillis=" + this.waitTimeInMillis + "]";
    }

    public static MailConfigurationBuilder newBuilder() {
        return new MailConfigurationBuilder();
    }

    public static MailConfigurationBuilder fromProperties(Map<String, Object> props) {
        return MailConfiguration.newBuilder().properties(props);
    }

    public static MailConfiguration newConfig(Map<String, Object> props) {
        return MailConfiguration.fromProperties(props).build();
    }

    /* synthetic */ MailConfiguration(MailConfiguration mailConfiguration) {
        this();
    }

    public static final class MailConfigurationBuilder {
        private final MailConfiguration config = new MailConfiguration(null);

        public MailConfiguration build() {
            return this.config.copy();
        }

        public MailConfigurationBuilder properties(Map<String, Object> props) {
            this.username(MailConfigurationBuilder.get(props, MailConstants.MAIL_SERVER_USERNAME, MailConstants.DEFAULT_MAIL_SERVER_USERNAME));
            this.password(MailConfigurationBuilder.get(props, MailConstants.MAIL_SERVER_PASSWORD, MailConstants.DEFAULT_MAIL_SERVER_PASSWORD));
            this.host(MailConfigurationBuilder.get(props, MailConstants.MAIL_SERVER_HOST, MailConstants.DEFAULT_MAIL_SERVER_HOST));
            this.port(MailConfigurationBuilder.getInt(props, MailConstants.MAIL_SERVER_PORT, 25));
            this.transport(MailConfigurationBuilder.get(props, MailConstants.MAIL_SERVER_TRANSPORT, "smtp"));
            this.adminEmail(MailConfigurationBuilder.get(props, MailConstants.MAIL_SERVER_ADMIN_EMAIL, MailConstants.DEFAULT_MAIL_SERVER_ADMIN_EMAIL));
            this.replyToEmail(MailConfigurationBuilder.get(props, MailConstants.MAIL_SERVER_REPLY_TO_EMAIL, MailConstants.DEFAULT_MAIL_SERVER_REPLY_TO_EMAIL));
            this.testEmailSubject(MailConfigurationBuilder.get(props, MailConstants.MAIL_SERVER_TEST_EMAIL_SUBJECT, "Test Email"));
            this.testEmailBody(MailConfigurationBuilder.get(props, MailConstants.MAIL_SERVER_TEST_EMAIL_BODY, "This is a test email sent from OSEE Mail Service"));
            this.statusWaitTime(this.getLong(props, MailConstants.MAIL_SERVER_STATUS_WAIT_TIME_MILLIS, 60000L));
            return this;
        }

        public MailConfigurationBuilder username(String userName) {
            this.config.setUserName(userName);
            return this;
        }

        public MailConfigurationBuilder password(String password) {
            this.config.setPassword(password);
            return this;
        }

        public MailConfigurationBuilder host(String host) {
            this.config.setHost(host);
            return this;
        }

        public MailConfigurationBuilder port(int port) {
            this.config.setPort(port);
            return this;
        }

        public MailConfigurationBuilder transport(String transport) {
            this.config.setTransport(transport);
            return this;
        }

        public MailConfigurationBuilder adminEmail(String adminEmail) {
            this.config.setAdminEmail(adminEmail);
            return this;
        }

        public MailConfigurationBuilder replyToEmail(String replyToEmail) {
            this.config.setReplyToEmail(replyToEmail);
            return this;
        }

        public MailConfigurationBuilder testEmailSubject(String testMailSubject) {
            this.config.setTestEmailSubject(testMailSubject);
            return this;
        }

        public MailConfigurationBuilder testEmailBody(String testMailBody) {
            this.config.setTestEmailBody(testMailBody);
            return this;
        }

        public MailConfigurationBuilder statusWaitTime(long waitTimeInMillis) {
            this.config.setStatusWaitTime(waitTimeInMillis);
            return this;
        }

        private long getLong(Map<String, Object> props, String key, long defaultValue) {
            String toReturn = MailConfigurationBuilder.get(props, key, String.valueOf(defaultValue));
            return Strings.isNumeric((String)toReturn) ? Long.parseLong(toReturn) : -1L;
        }

        private static int getInt(Map<String, Object> props, String key, int defaultValue) {
            String toReturn = MailConfigurationBuilder.get(props, key, String.valueOf(defaultValue));
            return Strings.isNumeric((String)toReturn) ? Integer.parseInt(toReturn) : -1;
        }

        private static String get(Map<String, Object> props, String key, String defaultValue) {
            Object object;
            String toReturn = defaultValue;
            Object object2 = object = props != null ? props.get(key) : null;
            if (object != null) {
                toReturn = String.valueOf(object);
            }
            return toReturn;
        }
    }
}

