/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.server.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osee.framework.core.data.OseeCredential;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.exception.OseeAuthenticationException;
import org.eclipse.osee.framework.core.server.IAuthenticationManager;
import org.eclipse.osee.framework.core.server.IAuthenticationProvider;
import org.eclipse.osee.framework.core.server.OseeServerProperties;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AuthenticationManager
implements IAuthenticationManager {
    private final Map<String, IAuthenticationProvider> authenticationProviders = new ConcurrentHashMap<String, IAuthenticationProvider>();
    private static AtomicBoolean logged = new AtomicBoolean(false);

    public void addAuthenticationProvider(IAuthenticationProvider authenticationProvider) {
        String providerId = authenticationProvider.getProtocol();
        this.authenticationProviders.put(providerId, authenticationProvider);
    }

    public void removeAuthenticationProvider(IAuthenticationProvider authenticationProvider) {
        this.authenticationProviders.remove(authenticationProvider.getProtocol()).toString();
    }

    @Override
    public boolean authenticate(OseeCredential credential) {
        boolean result = false;
        if (this.isSafeUser(credential)) {
            result = true;
        } else {
            IAuthenticationProvider provider = this.getAuthenticationProvider();
            if (provider != null) {
                result = provider.authenticate(credential);
            }
        }
        return result;
    }

    @Override
    public String[] getProtocols() {
        Set<String> keys = this.authenticationProviders.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    public UserToken asUserToken(OseeCredential credential) {
        UserToken toReturn = null;
        if (this.isAnonymousLogin(credential)) {
            toReturn = SystemUser.Anonymous;
        } else if (this.isBootStrap(credential)) {
            toReturn = SystemUser.BootStrap;
        } else {
            IAuthenticationProvider provider = this.getAuthenticationProvider();
            if (provider != null) {
                toReturn = provider.asOseeUserId(credential);
            }
        }
        return toReturn;
    }

    private IAuthenticationProvider getAuthenticationProvider() {
        String key = this.getProtocol();
        if (Strings.isValid((String)key)) {
            IAuthenticationProvider provider = this.authenticationProviders.get(key);
            if (logged.compareAndSet(false, true)) {
                XConsoleLogger.err((String)"Authentication Provider [%s]-[%s]\n", (Object[])new Object[]{key, provider.getClass().getSimpleName()});
            }
            if (provider != null) {
                return provider;
            }
        }
        throw new OseeAuthenticationException("Invalid authentication protocol [%s]", new Object[]{key});
    }

    private boolean isAnonymousLogin(OseeCredential credential) {
        return credential.getUserName().equals(SystemUser.Anonymous.getName());
    }

    private boolean isBootStrap(OseeCredential credential) {
        return credential.getUserName().equals(SystemUser.BootStrap.getName());
    }

    private boolean isSafeUser(OseeCredential credential) {
        return this.isAnonymousLogin(credential) || this.isBootStrap(credential);
    }

    @Override
    public String getProtocol() {
        return OseeServerProperties.getAuthenticationProtocol();
    }
}

