/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.annotations.OseeArtifactAttribute;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class ArtifactAccessorImpl<T>
implements ArtifactAccessor<T> {
    private ArtifactTypeToken artifactType = ArtifactTypeToken.SENTINEL;
    private final OrcsApi orcsApi;

    public ArtifactAccessorImpl(ArtifactTypeToken artifactType, OrcsApi orcsApi) {
        this.setArtifactType(artifactType);
        this.orcsApi = orcsApi;
    }

    @Override
    public T get(BranchId branch, ArtifactId artId, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArtifactReadable artifact = this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{this.artifactType}).andId(artId).asArtifactOrSentinel();
        if (artifact.isValid()) {
            T returnObj = clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact);
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke(returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken(artId, branch));
            }
            return returnObj;
        }
        return clazz.newInstance();
    }

    @Override
    public Collection<T> getAll(BranchId branch, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        LinkedList<T> artifactList = new LinkedList<T>();
        for (ArtifactReadable artifact : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{this.artifactType}).asArtifacts()) {
            if (!artifact.isValid()) continue;
            T returnObj = clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact);
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke(returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken(ArtifactId.valueOf((Long)artifact.getId()), branch));
            }
            artifactList.add(returnObj);
        }
        return artifactList;
    }

    @Override
    public T getByRelation(BranchId branch, ArtifactId artId, RelationTypeSide relation, ArtifactId relatedId, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArtifactReadable artifact = this.orcsApi.getQueryFactory().fromBranch(branch).andRelatedTo(relation, relatedId).andId(artId).asArtifactOrSentinel();
        if (artifact.isValid()) {
            T returnObj = clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact);
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke(returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken(artId, branch));
            }
            return returnObj;
        }
        return clazz.newInstance();
    }

    @Override
    public Collection<T> getAllByRelation(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        LinkedList<T> artifactList = new LinkedList<T>();
        for (ArtifactReadable artifact : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{this.artifactType}).andRelatedTo(relation, relatedId).asArtifacts()) {
            if (!artifact.isValid()) continue;
            T returnObj = clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact);
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke(returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken(ArtifactId.valueOf((Long)artifact.getId()), branch));
            }
            artifactList.add(returnObj);
        }
        return artifactList;
    }

    @Override
    public Collection<T> getAllByFilter(BranchId branch, String filter, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        LinkedList<T> artifactList = new LinkedList<T>();
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            if (field.isAnnotationPresent(OseeArtifactAttribute.class) && field.getDeclaredAnnotation(OseeArtifactAttribute.class).attributeId() != -1L) {
                attributes.add(AttributeTypeId.valueOf((Long)field.getDeclaredAnnotation(OseeArtifactAttribute.class).attributeId()));
            }
            ++n2;
        }
        for (ArtifactReadable artifact : this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{this.artifactType}).and(attributes, filter, new QueryOption[]{QueryOption.TOKEN_DELIMITER__ANY, QueryOption.CASE__IGNORE, QueryOption.TOKEN_MATCH_ORDER__ANY}).getResults().getList()) {
            if (!artifact.isValid()) continue;
            T returnObj = clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact);
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke(returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken(ArtifactId.valueOf((Long)artifact.getId()), branch));
            }
            artifactList.add(returnObj);
        }
        return artifactList;
    }

    @Override
    public Collection<T> getAllByRelationAndFilter(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, String filter, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        LinkedList<T> artifactList = new LinkedList<T>();
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            if (field.isAnnotationPresent(OseeArtifactAttribute.class) && field.getDeclaredAnnotation(OseeArtifactAttribute.class).attributeId() != -1L) {
                attributes.add(AttributeTypeId.valueOf((Long)field.getDeclaredAnnotation(OseeArtifactAttribute.class).attributeId()));
            }
            ++n2;
        }
        for (ArtifactReadable artifact : this.orcsApi.getQueryFactory().fromBranch(branch).andRelatedTo(relation, relatedId).and(attributes, filter, new QueryOption[]{QueryOption.TOKEN_DELIMITER__ANY, QueryOption.CASE__IGNORE, QueryOption.TOKEN_MATCH_ORDER__ANY}).getResults().getList()) {
            if (!artifact.isValid()) continue;
            T returnObj = clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact);
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke(returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken(ArtifactId.valueOf((Long)artifact.getId()), branch));
            }
            artifactList.add(returnObj);
        }
        return artifactList;
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(ArtifactTypeToken artifactType) {
        this.artifactType = artifactType;
    }

    @Override
    public T getByRelationWithoutId(BranchId branch, RelationTypeSide relation, ArtifactId relatedId, Class<T> clazz) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArtifactReadable artifact = this.orcsApi.getQueryFactory().fromBranch(branch).andRelatedTo(relation, relatedId).asArtifactOrSentinel();
        if (artifact.isValid()) {
            T returnObj = clazz.getDeclaredConstructor(ArtifactReadable.class).newInstance(artifact);
            if (this.hasSetApplic(clazz)) {
                this.getSetApplic(clazz).invoke(returnObj, this.orcsApi.getQueryFactory().applicabilityQuery().getApplicabilityToken(ArtifactId.valueOf((Long)artifact.getId()), branch));
            }
            return returnObj;
        }
        return clazz.newInstance();
    }

    private boolean hasSetApplic(Class<?> type) {
        return this.getSetApplic(type) != null;
    }

    private Method getSetApplic(Class<?> type) {
        Method[] methodArray = type.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("set") && method.getParameterTypes().length == 1 && Void.TYPE.equals(method.getReturnType()) && method.getName().endsWith("Applicability")) {
                return method;
            }
            ++n2;
        }
        return null;
    }
}

