/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.ArtifactInserter;
import org.eclipse.osee.mim.annotations.OseeArtifactAttribute;
import org.eclipse.osee.mim.annotations.OseeArtifactRequiredAttribute;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class ArtifactInserterImpl<T>
implements ArtifactInserter<T> {
    private final OrcsApi orcsApi;
    private ArtifactTypeToken artifactType;
    private String objectTypeToInsert;
    private final ArtifactAccessor<T> accessor;
    ArtifactToken folder;

    public ArtifactInserterImpl(ArtifactTypeToken artifactType, OrcsApi orcsApi, String objectTypeToInsert, ArtifactAccessor<T> accessor, ArtifactToken folder) {
        this.setArtifactType(artifactType);
        this.setObjectTypeToInsert(objectTypeToInsert);
        this.orcsApi = orcsApi;
        this.accessor = accessor;
        this.folder = folder;
    }

    @Override
    public XResultData addArtifact(T newArtifact, UserId account, BranchId branch) {
        XResultData results = new XResultData();
        try {
            TransactionBuilder tx;
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            if (this.createAndValidateNewArtifact(newArtifact, branch, tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Create " + this.getObjectTypeToInsert()), results)) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(ArtifactTypeToken artifactType) {
        this.artifactType = artifactType;
    }

    public String getObjectTypeToInsert() {
        return this.objectTypeToInsert;
    }

    public void setObjectTypeToInsert(String objectTypeToInsert) {
        this.objectTypeToInsert = objectTypeToInsert;
    }

    private boolean createAndValidateNewArtifact(T newArtifact, BranchId branch, TransactionBuilder tx, XResultData results) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArtifactToken defArt = ArtifactToken.SENTINEL;
        T foundArtifact = this.accessor.get(tx.getBranch(), ArtifactId.valueOf((String)((String)newArtifact.getClass().getMethod("getIdString", new Class[0]).invoke(newArtifact, new Object[0]))), newArtifact.getClass());
        if (!this.validateFieldsExists(newArtifact).isEmpty()) {
            results.error(this.validateFieldsExists(newArtifact));
            return false;
        }
        if (((Boolean)foundArtifact.getClass().getMethod("isValid", new Class[0]).invoke(foundArtifact, new Object[0])).booleanValue()) {
            results.error(String.valueOf(newArtifact.getClass().getCanonicalName()) + " already exists.");
            return false;
        }
        ArtifactToken writeFolder = tx.getWriteable((ArtifactId)this.folder);
        if (writeFolder.isInvalid()) {
            writeFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andId((ArtifactId)this.folder).asArtifactOrSentinel();
        }
        if (writeFolder.isInvalid()) {
            results.error("Folder cannot be null");
            return false;
        }
        defArt = tx.createArtifact((ArtifactId)writeFolder, this.artifactType, (String)newArtifact.getClass().getMethod("getName", new Class[0]).invoke(newArtifact, new Object[0]));
        results.setTitle("Add " + this.objectTypeToInsert + " " + defArt.getIdString());
        LinkedList<String> idList = new LinkedList<String>();
        idList.add(defArt.getIdString());
        results.setIds(idList);
        for (Field field : this.getAllFields(new LinkedList<Field>(), newArtifact.getClass())) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(OseeArtifactAttribute.class)) continue;
            Method getter = this.getGetter(newArtifact.getClass(), field.getName());
            if (getter != null && getter.invoke(newArtifact, new Object[0]) != null) {
                tx.setSoleAttributeValue((ArtifactId)defArt, AttributeTypeToken.valueOf((String)String.valueOf(field.getDeclaredAnnotation(OseeArtifactAttribute.class).attributeId())), getter.invoke(newArtifact, new Object[0]));
                continue;
            }
            if (field.get(newArtifact) == null) continue;
            tx.setSoleAttributeValue((ArtifactId)defArt, AttributeTypeToken.valueOf((String)String.valueOf(field.getDeclaredAnnotation(OseeArtifactAttribute.class).attributeId())), field.get(newArtifact));
        }
        return true;
    }

    private String validateFieldsExists(T newArtifact) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String results = "";
        for (Field field : this.getAllFields(new LinkedList<Field>(), newArtifact.getClass())) {
            field.setAccessible(true);
            if (!field.isAnnotationPresent(OseeArtifactRequiredAttribute.class) || !field.isAnnotationPresent(OseeArtifactAttribute.class) || this.getGetter(newArtifact.getClass(), field.getName()) == null || this.getGetter(newArtifact.getClass(), field.getName()).invoke(newArtifact, new Object[0]) != null && !this.getGetter(newArtifact.getClass(), field.getName()).invoke(newArtifact, new Object[0]).equals("")) continue;
            results = String.valueOf(field.getName()) + " must be set to a value";
        }
        return results;
    }

    @Override
    public XResultData relateArtifact(ArtifactId artifactToRelate, ArtifactId artifactToRelateTo, RelationTypeToken relation, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Relate " + this.getObjectTypeToInsert());
            tx.relate(artifactToRelateTo, relation, artifactToRelate);
            tx.commit();
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    @Override
    public XResultData replaceArtifact(T newArtifact, UserId account, BranchId branch) {
        XResultData results = new XResultData();
        try {
            TransactionBuilder tx;
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            if (this.replaceExistingArtifact(newArtifact, branch, tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Replace " + this.getObjectTypeToInsert()), results)) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    @Override
    public XResultData patchArtifact(T newArtifact, UserId account, BranchId branch) {
        XResultData results = new XResultData();
        try {
            TransactionBuilder tx;
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            if (this.partialUpdateArtifact(newArtifact, branch, tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Replace " + this.getObjectTypeToInsert()), results)) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    @Override
    public XResultData unrelateArtifact(ArtifactId artifactToUnRelate, ArtifactId artifactToUnRelateFrom, RelationTypeToken relation, BranchId branch, UserId account) {
        XResultData results = new XResultData();
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Unrelate " + this.getObjectTypeToInsert());
            tx.unrelate(artifactToUnRelateFrom, relation, artifactToUnRelate);
            tx.commit();
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    @Override
    public XResultData removeArtifact(ArtifactId artifactToRemove, UserId account, BranchId branch) {
        XResultData results = new XResultData();
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Delete Artifact");
            tx.deleteArtifact((ArtifactId)this.orcsApi.getQueryFactory().fromBranch(branch).andIsOfType(new ArtifactTypeToken[]{this.artifactType}).andId(artifactToRemove).asArtifact());
            tx.commit();
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    @Override
    public XResultData setApplicability(ArtifactId artifactId, ApplicabilityId applicId, UserId account, BranchId branch) {
        XResultData results = new XResultData();
        try {
            UserId user = account;
            if (user == null) {
                user = SystemUser.OseeSystem;
            }
            TransactionBuilder tx = this.orcsApi.getTransactionFactory().createTransaction(branch, user, "Set Applicability for Artifact.");
            tx.setApplicability(artifactId, applicId);
            tx.commit();
        }
        catch (Exception ex) {
            results.error(Lib.exceptionToString((Exception)ex));
        }
        return results;
    }

    private boolean replaceExistingArtifact(T newArtifact, BranchId branch, TransactionBuilder tx, XResultData results) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArtifactToken defArt = ArtifactToken.SENTINEL;
        T foundArtifact = this.accessor.get(tx.getBranch(), ArtifactId.valueOf((String)((String)newArtifact.getClass().getMethod("getIdString", new Class[0]).invoke(newArtifact, new Object[0]))), newArtifact.getClass());
        if (!this.checkIfIdExists(newArtifact)) {
            results.error("Artifact must contain an id");
        }
        if (!this.validateFieldsExists(newArtifact).isEmpty()) {
            results.error(this.validateFieldsExists(newArtifact));
            return false;
        }
        ArtifactToken writeFolder = tx.getWriteable((ArtifactId)this.folder);
        if (writeFolder.isInvalid()) {
            writeFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andId((ArtifactId)this.folder).asArtifactOrSentinel();
        }
        if (writeFolder.isInvalid()) {
            results.error("Folder cannot be null");
            return false;
        }
        defArt = this.orcsApi.getQueryFactory().fromBranch(tx.getBranch()).andId(ArtifactId.valueOf((String)((String)foundArtifact.getClass().getMethod("getIdString", new Class[0]).invoke(foundArtifact, new Object[0])))).asArtifactOrSentinel();
        results.setTitle("Replace " + this.objectTypeToInsert + " " + defArt.getIdString());
        LinkedList<String> idList = new LinkedList<String>();
        idList.add(defArt.getIdString());
        results.setIds(idList);
        for (Field field : this.getAllFields(new LinkedList<Field>(), newArtifact.getClass())) {
            Method getter;
            field.setAccessible(true);
            if (!field.isAnnotationPresent(OseeArtifactAttribute.class) || (getter = this.getGetter(newArtifact.getClass(), field.getName())) == null || getter.invoke(newArtifact, new Object[0]) == null) continue;
            tx.setSoleAttributeValue((ArtifactId)defArt, AttributeTypeToken.valueOf((String)String.valueOf(field.getDeclaredAnnotation(OseeArtifactAttribute.class).attributeId())), getter.invoke(newArtifact, new Object[0]));
        }
        if (this.hasGetApplic(newArtifact.getClass())) {
            ApplicabilityToken applic = (ApplicabilityToken)this.getGetApplic(newArtifact.getClass()).invoke(newArtifact, new Object[0]);
            tx.setApplicability((ArtifactId)defArt, ApplicabilityId.valueOf((Long)applic.getId()));
        }
        return true;
    }

    private boolean partialUpdateArtifact(T newArtifact, BranchId branch, TransactionBuilder tx, XResultData results) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        ArtifactToken writeFolder;
        ArtifactToken defArt = ArtifactToken.SENTINEL;
        T foundArtifact = this.accessor.get(tx.getBranch(), ArtifactId.valueOf((String)((String)newArtifact.getClass().getMethod("getIdString", new Class[0]).invoke(newArtifact, new Object[0]))), newArtifact.getClass());
        if (!this.checkIfIdExists(newArtifact)) {
            results.error("Artifact must contain an id");
        }
        if ((writeFolder = tx.getWriteable((ArtifactId)this.folder)).isInvalid()) {
            writeFolder = this.orcsApi.getQueryFactory().fromBranch(branch).andId((ArtifactId)this.folder).asArtifactOrSentinel();
        }
        if (writeFolder.isInvalid()) {
            results.error("Folder cannot be null");
            return false;
        }
        defArt = this.orcsApi.getQueryFactory().fromBranch(tx.getBranch()).andId(ArtifactId.valueOf((String)((String)foundArtifact.getClass().getMethod("getIdString", new Class[0]).invoke(foundArtifact, new Object[0])))).asArtifactOrSentinel();
        results.setTitle("Edit " + this.objectTypeToInsert + " " + defArt.getIdString());
        LinkedList<String> idList = new LinkedList<String>();
        idList.add(defArt.getIdString());
        results.setIds(idList);
        for (Field field : this.getAllFields(new LinkedList<Field>(), newArtifact.getClass())) {
            Method getter;
            field.setAccessible(true);
            if (!field.isAnnotationPresent(OseeArtifactAttribute.class) || (getter = this.getGetter(newArtifact.getClass(), field.getName())) == null || getter.invoke(newArtifact, new Object[0]) == null || getter.invoke(newArtifact, new Object[0]) == "") continue;
            tx.setSoleAttributeValue((ArtifactId)defArt, AttributeTypeToken.valueOf((String)String.valueOf(field.getDeclaredAnnotation(OseeArtifactAttribute.class).attributeId())), getter.invoke(newArtifact, new Object[0]));
        }
        if (this.hasGetApplic(newArtifact.getClass())) {
            ApplicabilityToken applic = (ApplicabilityToken)this.getGetApplic(newArtifact.getClass()).invoke(newArtifact, new Object[0]);
            tx.setApplicability((ArtifactId)defArt, ApplicabilityId.valueOf((Long)applic.getId()));
        }
        return true;
    }

    private Method getGetter(Class<?> type, String name) {
        Method[] methodArray = type.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("get") && method.getParameterTypes().length == 0 && !Void.TYPE.equals(method.getReturnType()) && method.getName().endsWith(name)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    private boolean checkIfIdExists(T newArtifact) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Long Id = (Long)this.getGetter(this.getNamedIdBase(newArtifact.getClass()), "Id").invoke(newArtifact, new Object[0]);
        return Id != null && Id > 0L;
    }

    Class<?> getNamedIdBase(Class<?> type) {
        if (type.getSuperclass() != null) {
            if (type.getSuperclass() == NamedIdBase.class) {
                return type.getSuperclass();
            }
            return this.getNamedIdBase(type.getSuperclass());
        }
        return null;
    }

    List<Field> getAllFields(List<Field> fields, Class<?> type) {
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            this.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    private boolean hasGetApplic(Class<?> type) {
        return this.getGetApplic(type) != null;
    }

    private Method getGetApplic(Class<?> type) {
        return this.getGetter(type, "Applicability");
    }
}

